/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.tools.api.RecordReader;

public class LineMessageReader
implements RecordReader {
    private String topic;
    private boolean parseKey;
    private String keySeparator = "\t";
    private boolean parseHeaders;
    private String headersDelimiter = "\t";
    private String headersSeparator = ",";
    private String headersKeySeparator = ":";
    private boolean ignoreError;
    private int lineNumber;
    private final boolean printPrompt = System.console() != null;
    private Pattern headersSeparatorPattern;
    private String nullMarker;

    public void configure(Map<String, ?> props) {
        this.topic = props.get("topic").toString();
        if (props.containsKey("parse.key")) {
            this.parseKey = props.get("parse.key").toString().trim().equalsIgnoreCase("true");
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator = props.get("key.separator").toString();
        }
        if (props.containsKey("parse.headers")) {
            this.parseHeaders = props.get("parse.headers").toString().trim().equalsIgnoreCase("true");
        }
        if (props.containsKey("headers.delimiter")) {
            this.headersDelimiter = props.get("headers.delimiter").toString();
        }
        if (props.containsKey("headers.separator")) {
            this.headersSeparator = props.get("headers.separator").toString();
        }
        this.headersSeparatorPattern = Pattern.compile(this.headersSeparator);
        if (props.containsKey("headers.key.separator")) {
            this.headersKeySeparator = props.get("headers.key.separator").toString();
        }
        if (props.containsKey("ignore.error")) {
            this.ignoreError = props.get("ignore.error").toString().trim().equalsIgnoreCase("true");
        }
        if (this.headersDelimiter.equals(this.headersSeparator)) {
            throw new KafkaException("headers.delimiter and headers.separator may not be equal");
        }
        if (this.headersDelimiter.equals(this.headersKeySeparator)) {
            throw new KafkaException("headers.delimiter and headers.key.separator may not be equal");
        }
        if (this.headersSeparator.equals(this.headersKeySeparator)) {
            throw new KafkaException("headers.separator and headers.key.separator may not be equal");
        }
        if (props.containsKey("null.marker")) {
            this.nullMarker = props.get("null.marker").toString();
        }
        if (this.keySeparator.equals(this.nullMarker)) {
            throw new KafkaException("null.marker and key.separator may not be equal");
        }
        if (this.headersSeparator.equals(this.nullMarker)) {
            throw new KafkaException("null.marker and headers.separator may not be equal");
        }
        if (this.headersDelimiter.equals(this.nullMarker)) {
            throw new KafkaException("null.marker and headers.delimiter may not be equal");
        }
        if (this.headersKeySeparator.equals(this.nullMarker)) {
            throw new KafkaException("null.marker and headers.key.separator may not be equal");
        }
    }

    public Iterator<ProducerRecord<byte[], byte[]>> readRecords(final InputStream inputStream) {
        return new Iterator<ProducerRecord<byte[], byte[]>>(){
            private final BufferedReader reader;
            private ProducerRecord<byte[], byte[]> current;
            {
                this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            }

            @Override
            public boolean hasNext() {
                String line;
                if (this.current != null) {
                    return true;
                }
                ++LineMessageReader.this.lineNumber;
                if (LineMessageReader.this.printPrompt) {
                    System.out.print(">");
                }
                try {
                    line = this.reader.readLine();
                }
                catch (IOException e) {
                    throw new KafkaException((Throwable)e);
                }
                if (line == null) {
                    this.current = null;
                } else {
                    String headers = LineMessageReader.this.parse(LineMessageReader.this.parseHeaders, line, 0, LineMessageReader.this.headersDelimiter, "headers delimiter");
                    int headerOffset = headers == null ? 0 : headers.length() + LineMessageReader.this.headersDelimiter.length();
                    String key = LineMessageReader.this.parse(LineMessageReader.this.parseKey, line, headerOffset, LineMessageReader.this.keySeparator, "key separator");
                    int keyOffset = key == null ? 0 : key.length() + LineMessageReader.this.keySeparator.length();
                    String value = line.substring(headerOffset + keyOffset);
                    ProducerRecord record = new ProducerRecord(LineMessageReader.this.topic, key != null && !key.equals(LineMessageReader.this.nullMarker) ? key.getBytes(StandardCharsets.UTF_8) : null, value != null && !value.equals(LineMessageReader.this.nullMarker) ? value.getBytes(StandardCharsets.UTF_8) : null);
                    if (headers != null && !headers.equals(LineMessageReader.this.nullMarker)) {
                        Arrays.stream(LineMessageReader.this.splitHeaders(headers)).forEach(header -> record.headers().add(header.key(), header.value()));
                    }
                    this.current = record;
                }
                return this.current != null;
            }

            @Override
            public ProducerRecord<byte[], byte[]> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more record");
                }
                try {
                    ProducerRecord<byte[], byte[]> producerRecord = this.current;
                    return producerRecord;
                }
                finally {
                    this.current = null;
                }
            }
        };
    }

    private String parse(boolean enabled, String line, int startIndex, String demarcation, String demarcationName) {
        if (!enabled) {
            return null;
        }
        int index = line.indexOf(demarcation, startIndex);
        if (index == -1) {
            if (this.ignoreError) {
                return null;
            }
            throw new KafkaException("No " + demarcationName + " found on line number " + this.lineNumber + ": '" + line + "'");
        }
        return line.substring(startIndex, index);
    }

    private Header[] splitHeaders(String headers) {
        return (Header[])Arrays.stream(this.headersSeparatorPattern.split(headers)).map(pair -> {
            int i = pair.indexOf(this.headersKeySeparator);
            if (i == -1) {
                if (this.ignoreError) {
                    return new RecordHeader(pair, null);
                }
                throw new KafkaException("No header key separator found in pair '" + pair + "' on line number " + this.lineNumber);
            }
            String headerKey = pair.substring(0, i);
            if (headerKey.equals(this.nullMarker)) {
                throw new KafkaException("Header keys should not be equal to the null marker '" + this.nullMarker + "' as they can't be null");
            }
            String value = pair.substring(i + this.headersKeySeparator.length());
            byte[] headerValue = value.equals(this.nullMarker) ? null : value.getBytes(StandardCharsets.UTF_8);
            return new RecordHeader(headerKey, headerValue);
        }).toArray(Header[]::new);
    }

    String keySeparator() {
        return this.keySeparator;
    }

    boolean parseKey() {
        return this.parseKey;
    }

    boolean parseHeaders() {
        return this.parseHeaders;
    }
}

