/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.function.BiFunction;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.slf4j.Logger;

public class CoordinatorOperationExceptionHelper {
    public static <IN, OUT> OUT handleOperationException(String operationName, IN operationInput, Throwable exception, BiFunction<Errors, String, OUT> handler, Logger log) {
        ApiError apiError = ApiError.fromThrowable((Throwable)exception);
        switch (apiError.error()) {
            case UNKNOWN_SERVER_ERROR: {
                log.error("Operation {} with {} hit an unexpected exception: {}.", new Object[]{operationName, operationInput, exception.getMessage(), exception});
                return handler.apply(Errors.UNKNOWN_SERVER_ERROR, null);
            }
            case NETWORK_EXCEPTION: {
                return handler.apply(Errors.COORDINATOR_LOAD_IN_PROGRESS, null);
            }
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case NOT_ENOUGH_REPLICAS: 
            case REQUEST_TIMED_OUT: {
                return handler.apply(Errors.COORDINATOR_NOT_AVAILABLE, null);
            }
            case NOT_LEADER_OR_FOLLOWER: 
            case KAFKA_STORAGE_ERROR: {
                return handler.apply(Errors.NOT_COORDINATOR, null);
            }
            case MESSAGE_TOO_LARGE: 
            case RECORD_LIST_TOO_LARGE: 
            case INVALID_FETCH_SIZE: {
                return handler.apply(Errors.UNKNOWN_SERVER_ERROR, null);
            }
        }
        return handler.apply(apiError.error(), apiError.message());
    }
}

