/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.source;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTaskContext;

public abstract class SourceTask
implements Task {
    public static final String TRANSACTION_BOUNDARY_CONFIG = "transaction.boundary";
    protected SourceTaskContext context;

    public void initialize(SourceTaskContext context) {
        this.context = context;
    }

    @Override
    public abstract void start(Map<String, String> var1);

    public abstract List<SourceRecord> poll() throws InterruptedException;

    public void commit() throws InterruptedException {
    }

    @Override
    public abstract void stop();

    public void commitRecord(SourceRecord record, RecordMetadata metadata) throws InterruptedException {
    }

    public static enum TransactionBoundary {
        POLL,
        INTERVAL,
        CONNECTOR;

        public static final TransactionBoundary DEFAULT;

        public static TransactionBoundary fromProperty(String property) {
            Objects.requireNonNull(property, "Value for transaction boundary property may not be null");
            return TransactionBoundary.valueOf(property.toUpperCase(Locale.ROOT).trim());
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            DEFAULT = POLL;
        }
    }
}

