/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.session;

import java.util.Objects;
import org.apache.kafka.common.Uuid;

public class ShareSessionKey {
    private final String groupId;
    private final Uuid memberId;

    public ShareSessionKey(String groupId, Uuid memberId) {
        this.groupId = Objects.requireNonNull(groupId);
        this.memberId = Objects.requireNonNull(memberId);
    }

    public Uuid memberId() {
        return this.memberId;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.memberId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShareSessionKey that = (ShareSessionKey)obj;
        return this.groupId.equals(that.groupId) && Objects.equals(this.memberId, that.memberId);
    }

    public String toString() {
        return "ShareSessionKey( groupId=" + this.groupId + ", memberId=" + String.valueOf(this.memberId) + ")";
    }
}

