/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;

public class ErroneousAndValidPartitionData {
    private final Map<TopicIdPartition, ShareFetchResponseData.PartitionData> erroneous;
    private final Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> validTopicIdPartitions;

    public ErroneousAndValidPartitionData(Map<TopicIdPartition, ShareFetchResponseData.PartitionData> erroneous, Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> validTopicIdPartitions) {
        this.erroneous = erroneous;
        this.validTopicIdPartitions = validTopicIdPartitions;
    }

    public ErroneousAndValidPartitionData(Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData) {
        this.erroneous = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        this.validTopicIdPartitions = new HashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        shareFetchData.forEach((topicIdPartition, sharePartitionData) -> {
            if (topicIdPartition.topic() == null) {
                this.erroneous.put((TopicIdPartition)topicIdPartition, ShareFetchResponse.partitionResponse((TopicIdPartition)topicIdPartition, (Errors)Errors.UNKNOWN_TOPIC_ID));
            } else {
                this.validTopicIdPartitions.put((TopicIdPartition)topicIdPartition, (ShareFetchRequest.SharePartitionData)sharePartitionData);
            }
        });
    }

    public ErroneousAndValidPartitionData() {
        this.erroneous = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        this.validTopicIdPartitions = new HashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
    }

    public Map<TopicIdPartition, ShareFetchResponseData.PartitionData> erroneous() {
        return this.erroneous;
    }

    public Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> validTopicIdPartitions() {
        return this.validTopicIdPartitions;
    }
}

