/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001\u0002\t\u0012\u0001YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0006\u0001B\u0001B\u0003%Q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003_\u0001\u0011\u0005q\fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u00111\u0017\u0001\u0005\n\u0005U\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!!;\u0001\t\u0013\tY\u000fC\u0004\u0003\u001a\u0001!IAa\u0007\u0003\u0019\r{gNZ5h\u0011\u0016d\u0007/\u001a:\u000b\u0005I\u0019\u0012AB:feZ,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011a$I\u0007\u0002?)\u0011\u0001eE\u0001\u0006kRLGn]\u0005\u0003E}\u0011q\u0001T8hO&tw-A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0003K\u0019j\u0011!E\u0005\u0003OE\u0011Q\"T3uC\u0012\fG/Y\"bG\",\u0017AB2p]\u001aLw\r\u0005\u0002&U%\u00111&\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ssB\u0011a&M\u0007\u0002_)\u0011\u0001'E\u0001\t[\u0016$\u0018\rZ1uC&\u0011!g\f\u0002\u0011\u0007>tg-[4SKB|7/\u001b;pef\fa\u0001P5oSRtD\u0003B\u001b7oa\u0002\"!\n\u0001\t\u000b\r\"\u0001\u0019\u0001\u0013\t\u000b!\"\u0001\u0019A\u0015\t\u000b1\"\u0001\u0019A\u0017\u0002\u0015\u0005dGnQ8oM&<7\u000f\u0006\u0002<#B!A(Q\"O\u001b\u0005i$B\u0001 @\u0003\u001diW\u000f^1cY\u0016T!\u0001Q\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C{\t\u0019Q*\u00199\u0011\u0005\u0011[eBA#J!\t1\u0015$D\u0001H\u0015\tAU#\u0001\u0004=e>|GOP\u0005\u0003\u0015f\ta\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!*\u0007\t\u00031=K!\u0001U\r\u0003\u0007\u0005s\u0017\u0010C\u0003)\u000b\u0001\u0007!\u000b\u0005\u0002T96\tAK\u0003\u0002)+*\u0011akV\u0001\u0007G>lWn\u001c8\u000b\u0005QA&BA-[\u0003\u0019\t\u0007/Y2iK*\t1,A\u0002pe\u001eL!!\u0018+\u0003\u001d\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c4jO\u0006a\u0002.\u00198eY\u0016$Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z9vKN$Hc\u00011geB\u0011\u0011\rZ\u0007\u0002E*\u00111-V\u0001\b[\u0016\u001c8/Y4f\u0013\t)'MA\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006O\u001a\u0001\r\u0001[\u0001\be\u0016\fX/Z:u!\tIwN\u0004\u0002k[6\t1N\u0003\u0002m'\u00059a.\u001a;x_J\\\u0017B\u00018l\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!\u0001]9\u0003\u000fI+\u0017/^3ti*\u0011an\u001b\u0005\u0006g\u001a\u0001\r\u0001^\u0001\u000bCV$\b\u000eS3ma\u0016\u0014\bCA\u0013v\u0013\t1\u0018C\u0001\u0006BkRD\u0007*\u001a7qKJ\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\bs\u0006M\u00111HA#!\u0011Qx0!\u0002\u000f\u0005mlhB\u0001$}\u0013\u0005Q\u0012B\u0001@\u001a\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0001\u0002\u0004\t!A*[:u\u0015\tq\u0018\u0004\u0005\u0003\u0002\b\u00055abA1\u0002\n%\u0019\u00111\u00022\u00027\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\ty!!\u0005\u0003+\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm];mi*\u0019\u00111\u00022\t\u000f\u0005Uq\u00011\u0001\u0002\u0018\u0005)\"/Z:pkJ\u001cW\rV8D_:4\u0017n\u001a(b[\u0016\u001c\b\u0003\u0002>\u0000\u00033\u0001B!a\u0007\u000269!\u0011QDA\u0019\u001d\u0011\ty\"a\f\u000f\t\u0005\u0005\u0012Q\u0006\b\u0005\u0003G\tYC\u0004\u0003\u0002&\u0005%bb\u0001$\u0002(%\t1,\u0003\u0002Z5&\u0011A\u0003W\u0005\u0003-^K!aY+\n\u0007\u0005M\"-\u0001\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u00028\u0005e\"a\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN|WO]2f\u0015\r\t\u0019D\u0019\u0005\b\u0003{9\u0001\u0019AA \u0003=Ign\u00197vI\u0016\u001c\u0016P\\8os6\u001c\bc\u0001\r\u0002B%\u0019\u00111I\r\u0003\u000f\t{w\u000e\\3b]\"9\u0011qI\u0004A\u0002\u0005}\u0012\u0001F5oG2,H-\u001a#pGVlWM\u001c;bi&|g.\u0001\fde\u0016\fG/Z$s_V\u00048i\u001c8gS\u001e,e\u000e\u001e:z))\ti%!\u0018\u0002r\u0005\u0015\u0015q\u0011\u000b\u0007\u0003\u001f\n)&!\u0017\u0011\t\u0005\u001d\u0011\u0011K\u0005\u0005\u0003'\n\tBA\u000fEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cx.\u001e:dKJ+7/\u001e7u\u0011\u0019\t9\u0006\u0003a\u0001\u0007\u0006!a.Y7f\u0011\u0019\tY\u0006\u0003a\u0001\u001d\u0006)a/\u00197vK\"9\u0011q\f\u0005A\u0002\u0005\u0005\u0014aC4s_V\u00048i\u001c8gS\u001e\u0004B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0003he>,\bOC\u0002\u0002l]\u000b1bY8pe\u0012Lg.\u0019;pe&!\u0011qNA3\u0005-9%o\\;q\u0007>tg-[4\t\u000f\u0005M\u0004\u00021\u0001\u0002v\u0005QqM]8vaB\u0013x\u000e]:\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005!Q\u000f^5m\u0015\t\ty(\u0001\u0003kCZ\f\u0017\u0002BAB\u0003s\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\ti\u0004\u0003a\u0001\u0003\u007fAq!a\u0012\t\u0001\u0004\ty$\u0001\fde\u0016\fG/\u001a+pa&\u001c7i\u001c8gS\u001e,e\u000e\u001e:z))\ti)a%\u0002,\u0006=\u0016\u0011\u0017\u000b\u0007\u0003\u001f\ny)!%\t\r\u0005]\u0013\u00021\u0001D\u0011\u0019\tY&\u0003a\u0001\u001d\"9\u0011QS\u0005A\u0002\u0005]\u0015!\u00037pO\u000e{gNZ5h!\u0011\tI*a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b1\u0001\\8h\u0015\u0011\t\t+a)\u0002\u0013%tG/\u001a:oC2\u001c(bAAS/\u000691\u000f^8sC\u001e,\u0017\u0002BAU\u00037\u0013\u0011\u0002T8h\u0007>tg-[4\t\u000f\u00055\u0016\u00021\u0001\u0002v\u0005QAo\u001c9jGB\u0013x\u000e]:\t\u000f\u0005u\u0012\u00021\u0001\u0002@!9\u0011qI\u0005A\u0002\u0005}\u0012aF2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e,e\u000e\u001e:z)!\t9,!0\u0002B\u0006\rGCBA(\u0003s\u000bY\f\u0003\u0004\u0002X)\u0001\ra\u0011\u0005\u0007\u00037R\u0001\u0019\u0001(\t\u000f\u0005}&\u00021\u0001\u0002@\u0005y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rC\u0004\u0002>)\u0001\r!a\u0010\t\u000f\u0005\u001d#\u00021\u0001\u0002@\u0005q1m\u001c8gS\u001e\u001c\u0016P\\8os6\u001cH\u0003CAe\u0003#\f\u0019.!7\u0011\ti|\u00181\u001a\t\u0005\u0003\u000f\ti-\u0003\u0003\u0002P\u0006E!A\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:Ts:|g._7\t\r\u0005]3\u00021\u0001D\u0011\u001d\t)n\u0003a\u0001\u0003/\f\u0001b]=o_:LXn\u001d\t\u0004u~\u001c\u0005bBAn\u0017\u0001\u0007\u0011qH\u0001\fSN\u001cVM\\:ji&4X-\u0001\bce>\\WM]*z]>t\u00170\\:\u0015\t\u0005]\u0017\u0011\u001d\u0005\u0007\u0003/b\u0001\u0019A\"\u0002'\t\u0014xn[3s\t>\u001cW/\\3oi\u0006$\u0018n\u001c8\u0015\u0007\r\u000b9\u000f\u0003\u0004\u0002X5\u0001\raQ\u0001\u0013G>tg-[4SKN\u0004xN\\:f)f\u0004X\r\u0006\u0003\u0002n\n\u0005\u0001\u0003BAx\u0003wtA!!=\u0002x6\u0011\u00111\u001f\u0006\u0004\u0003k,\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005e\u00181_\u0001\u0018\t\u0016\u001c8M]5cK\u000e{gNZ5hgJ+7\u000f]8og\u0016LA!!@\u0002\u0000\nQ1i\u001c8gS\u001e$\u0016\u0010]3\u000b\t\u0005e\u00181\u001f\u0005\b\u0005\u0007q\u0001\u0019\u0001B\u0003\u0003)\u0019wN\u001c4jORK\b/\u001a\t\u00061\t\u001d!1B\u0005\u0004\u0005\u0013I\"AB(qi&|g\u000e\u0005\u0003\u0003\u000e\tMabA*\u0003\u0010%\u0019!\u0011\u0003+\u0002\u0013\r{gNZ5h\t\u00164\u0017\u0002\u0002B\u000b\u0005/\u0011A\u0001V=qK*\u0019!\u0011\u0003+\u0002-I,7o\\;sG\u0016t\u0015-\\3U_\n\u0013xn[3s\u0013\u0012$BA!\b\u0003$A\u0019\u0001Da\b\n\u0007\t\u0005\u0012DA\u0002J]RDaA!\n\u0010\u0001\u0004\u0019\u0015\u0001\u0004:fg>,(oY3OC6,\u0007")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(config.originals()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(config.nonInternalValues()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    public DescribeConfigsResponseData handleDescribeConfigsRequest(RequestChannel.Request request, AuthHelper authHelper) {
        void var6_6;
        void var5_5;
        DescribeConfigsRequest describeConfigsRequest = (DescribeConfigsRequest)request.body(ClassTag$.MODULE$.apply(DescribeConfigsRequest.class));
        Tuple2 tuple2 = CollectionConverters$.MODULE$.ListHasAsScala(describeConfigsRequest.data().resources()).asScala().partition((Function1 & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$handleDescribeConfigsRequest$1(authHelper, request, resource)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer authorizedResources = (Buffer)tuple2._1();
        Buffer unauthorizedResources = (Buffer)tuple2._2();
        List<DescribeConfigsResponseData.DescribeConfigsResult> authorizedConfigs = this.describeConfigs((List<DescribeConfigsRequestData.DescribeConfigsResource>)var5_5.toList(), describeConfigsRequest.data().includeSynonyms(), describeConfigsRequest.data().includeDocumentation());
        Buffer unauthorizedConfigs = (Buffer)var6_6.map((Function1 & Serializable)resource -> {
            Errors errors;
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            if (ConfigResource.Type.BROKER.equals(type) ? true : (ConfigResource.Type.BROKER_LOGGER.equals(type) ? true : ConfigResource.Type.CLIENT_METRICS.equals(type))) {
                errors = Errors.CLUSTER_AUTHORIZATION_FAILED;
            } else if (ConfigResource.Type.TOPIC.equals(type)) {
                errors = Errors.TOPIC_AUTHORIZATION_FAILED;
            } else if (ConfigResource.Type.GROUP.equals(type)) {
                errors = Errors.GROUP_AUTHORIZATION_FAILED;
            } else {
                throw new InvalidRequestException("Unexpected resource type " + type + " for resource " + resource.resourceName());
            }
            Errors error = errors;
            return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(error.code()).setErrorMessage(error.message()).setConfigs(Collections.emptyList()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
        });
        return new DescribeConfigsResponseData().setResults(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)authorizedConfigs.$plus$plus((IterableOnce)unauthorizedConfigs)).asJava());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, boolean includeDocumentation) {
        return resourceToConfigNames.map((Function1 & Serializable)resource -> {
            try {
                ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    String topic = resource.resourceName();
                    Topic.validate((String)topic);
                    if ($this.metadataCache.contains(topic)) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        LogConfig logConfig = LogConfig.fromProps($this.config.extractLogConfigMap(), (Properties)topicProps);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)(resource.configurationKeys() == null || resource.configurationKeys().isEmpty() ? createResponseConfig$1_configs.toBuffer() : ((IterableOnceOps)createResponseConfig$1_configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(resource, x0$1)))).toBuffer()).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    }
                    v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                } else {
                    if (ConfigResource.Type.BROKER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (resource.resourceName() == null || resource.resourceName().isEmpty()) {
                            void createResponseConfig$1_createConfigEntry2;
                            Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                            Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                            Buffer createResponseConfig$1_configEntries = (Buffer)(resource.configurationKeys() == null || resource.configurationKeys().isEmpty() ? createResponseConfig$1_configs.toBuffer() : ((IterableOnceOps)createResponseConfig$1_configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(resource, x0$1)))).toBuffer()).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry2, arg_0));
                            v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                            return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                        }
                        if (this.resourceNameToBrokerId(resource.resourceName()) != $this.config.brokerId()) throw new InvalidRequestException("Unexpected broker id, expected " + $this.config.brokerId() + " or empty string, but received " + resource.resourceName());
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)$this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)(resource.configurationKeys() == null || resource.configurationKeys().isEmpty() ? createResponseConfig$1_configs.toBuffer() : ((IterableOnceOps)createResponseConfig$1_configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(resource, x0$1)))).toBuffer()).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    }
                    if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (resource.resourceName() == null || resource.resourceName().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(resource.resourceName()) != $this.config.brokerId()) {
                            throw new InvalidRequestException("Unexpected broker id, expected " + $this.config.brokerId() + " but received " + resource.resourceName());
                        }
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
                        scala.collection.immutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                        Buffer createResponseConfig$1_configEntries = (Buffer)(resource.configurationKeys() == null || resource.configurationKeys().isEmpty() ? createResponseConfig$1_configs.toBuffer() : ((IterableOnceOps)createResponseConfig$1_configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(resource, x0$1)))).toBuffer()).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    }
                    if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
                        String subscriptionName = resource.resourceName();
                        if (subscriptionName == null || subscriptionName.isEmpty()) {
                            throw new InvalidRequestException("Client metrics subscription name must not be empty");
                        }
                        Properties entityProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, subscriptionName));
                        ListBuffer configEntries = new ListBuffer();
                        entityProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> configEntries.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name.toString()).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.CLIENT_METRICS_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()))));
                        v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)configEntries).asJava());
                        return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    } else {
                        void createResponseConfig$1_createConfigEntry;
                        if (!ConfigResource.Type.GROUP.equals(type)) throw new InvalidRequestException("Unsupported resource type: " + type);
                        String group = resource.resourceName();
                        if (group == null || group.isEmpty()) {
                            throw new InvalidRequestException("Group name must not be empty");
                        }
                        Properties groupProps = $this.configRepository.groupConfig(group);
                        GroupConfig groupConfig = GroupConfig.fromProps((java.util.Map)$this.config.groupCoordinatorConfig().extractGroupConfigMap($this.config.shareGroupConfig()), (Properties)groupProps);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createGroupConfigEntry(groupConfig, groupProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)groupConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)(resource.configurationKeys() == null || resource.configurationKeys().isEmpty() ? createResponseConfig$1_configs.toBuffer() : ((IterableOnceOps)createResponseConfig$1_configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(resource, x0$1)))).toBuffer()).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$3((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        v0 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return v0.setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
                    }
                }
            }
            catch (Throwable e) {
                String message = "Error processing describe configs request for resource " + resource;
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource.resourceName()).setResourceType(resource.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        });
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createGroupConfigEntry(GroupConfig groupConfig, Properties groupProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        List<String> allNames = DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
        Option configEntryType = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(GroupConfig.configType((String)name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        List<DescribeConfigsResponseData.DescribeConfigsSynonym> list2 = this.configSynonyms(name, allNames, isSensitive);
        if (!groupProps.containsKey(name)) {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym);
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.GROUP_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType((Option<ConfigDef.Type>)configEntryType);
        String configDocumentation = includeDocumentation ? groupConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option configEntryType = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(LogConfig.configType((String)name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        List list2 = (List)Option$.MODULE$.apply(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(name)).map((Function1 & Serializable)s -> this.configSynonyms((String)s, DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)s, true), isSensitive)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType((Option<ConfigDef.Type>)configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List<String> allNames = DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : (value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        List allSynonyms = this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$3)));
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$2$adapted(dynamicConfig.currentDynamicBrokerConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$3$adapted(dynamicConfig.currentDynamicDefaultConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)allSynonyms.dropWhile((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        if (ConfigDef.Type.BOOLEAN.equals(type)) {
            return DescribeConfigsResponse.ConfigType.BOOLEAN;
        }
        if (ConfigDef.Type.STRING.equals(type)) {
            return DescribeConfigsResponse.ConfigType.STRING;
        }
        if (ConfigDef.Type.INT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.INT;
        }
        if (ConfigDef.Type.SHORT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.SHORT;
        }
        if (ConfigDef.Type.LONG.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LONG;
        }
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            return DescribeConfigsResponse.ConfigType.DOUBLE;
        }
        if (ConfigDef.Type.LIST.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LIST;
        }
        if (ConfigDef.Type.CLASS.equals(type)) {
            return DescribeConfigsResponse.ConfigType.CLASS;
        }
        if (ConfigDef.Type.PASSWORD.equals(type)) {
            return DescribeConfigsResponse.ConfigType.PASSWORD;
        }
        return DescribeConfigsResponse.ConfigType.UNKNOWN;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(resourceName));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException("Broker id must be an integer, but it is: " + resourceName);
        }
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsRequest$1(AuthHelper authHelper$1, RequestChannel.Request request$1, DescribeConfigsRequestData.DescribeConfigsResource resource) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
        if (ConfigResource.Type.BROKER.equals(type) ? true : (ConfigResource.Type.BROKER_LOGGER.equals(type) ? true : ConfigResource.Type.CLIENT_METRICS.equals(type))) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, resource.resourceName(), authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        if (ConfigResource.Type.GROUP.equals(type)) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.GROUP, resource.resourceName(), authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        throw new InvalidRequestException("Unexpected resource type " + type + " for resource " + resource.resourceName());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(DescribeConfigsRequestData.DescribeConfigsResource resource$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String configName = (String)x0$1._1();
            return CollectionConverters$.MODULE$.ListHasAsScala(resource$1.configurationKeys()).asScala().contains((Object)configName);
        }
        throw new MatchError(null);
    }

    private static final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource resource$1) {
        Buffer configEntries = (Buffer)(resource$1.configurationKeys() == null || resource$1.configurationKeys().isEmpty() ? configs.toBuffer() : ((IterableOnceOps)configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$describeConfigs$2(resource, x0$1)))).toBuffer()).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String name = (String)x0$2._1();
                Object value = x0$2._2();
                return (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            }
            throw new MatchError(null);
        });
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$3) {
        return perBrokerConfig$1 || x$3.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$2, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return (Buffer)allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }
}

