/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Objects;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.raft.OffsetAndEpoch;

public final class MetadataImage {
    public static final MetadataImage EMPTY = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY);
    private final MetadataProvenance provenance;
    private final FeaturesImage features;
    private final ClusterImage cluster;
    private final TopicsImage topics;
    private final ConfigurationsImage configs;
    private final ClientQuotasImage clientQuotas;
    private final ProducerIdsImage producerIds;
    private final AclsImage acls;
    private final ScramImage scram;
    private final DelegationTokenImage delegationTokens;

    public MetadataImage(MetadataProvenance provenance, FeaturesImage features, ClusterImage cluster, TopicsImage topics, ConfigurationsImage configs, ClientQuotasImage clientQuotas, ProducerIdsImage producerIds, AclsImage acls, ScramImage scram, DelegationTokenImage delegationTokens) {
        this.provenance = provenance;
        this.features = features;
        this.cluster = cluster;
        this.topics = topics;
        this.configs = configs;
        this.clientQuotas = clientQuotas;
        this.producerIds = producerIds;
        this.acls = acls;
        this.scram = scram;
        this.delegationTokens = delegationTokens;
    }

    public boolean isEmpty() {
        return this.features.isEmpty() && this.cluster.isEmpty() && this.topics.isEmpty() && this.configs.isEmpty() && this.clientQuotas.isEmpty() && this.producerIds.isEmpty() && this.acls.isEmpty() && this.scram.isEmpty() && this.delegationTokens.isEmpty();
    }

    public MetadataProvenance provenance() {
        return this.provenance;
    }

    public OffsetAndEpoch highestOffsetAndEpoch() {
        return new OffsetAndEpoch(this.provenance.lastContainedOffset(), this.provenance.lastContainedEpoch());
    }

    public long offset() {
        return this.provenance.lastContainedOffset();
    }

    public FeaturesImage features() {
        return this.features;
    }

    public ClusterImage cluster() {
        return this.cluster;
    }

    public TopicsImage topics() {
        return this.topics;
    }

    public ConfigurationsImage configs() {
        return this.configs;
    }

    public ClientQuotasImage clientQuotas() {
        return this.clientQuotas;
    }

    public ProducerIdsImage producerIds() {
        return this.producerIds;
    }

    public AclsImage acls() {
        return this.acls;
    }

    public ScramImage scram() {
        return this.scram;
    }

    public DelegationTokenImage delegationTokens() {
        return this.delegationTokens;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        this.features.write(writer, options);
        this.cluster.write(writer, options);
        this.topics.write(writer, options);
        this.configs.write(writer, options);
        this.clientQuotas.write(writer, options);
        this.producerIds.write(writer, options);
        this.acls.write(writer);
        this.scram.write(writer, options);
        this.delegationTokens.write(writer, options);
        writer.close(true);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataImage other = (MetadataImage)o;
        return this.provenance.equals(other.provenance) && this.features.equals(other.features) && this.cluster.equals(other.cluster) && this.topics.equals(other.topics) && this.configs.equals(other.configs) && this.clientQuotas.equals(other.clientQuotas) && this.producerIds.equals(other.producerIds) && this.acls.equals(other.acls) && this.scram.equals(other.scram) && this.delegationTokens.equals(other.delegationTokens);
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.features, this.cluster, this.topics, this.configs, this.clientQuotas, this.producerIds, this.acls, this.scram, this.delegationTokens);
    }

    public String toString() {
        return new MetadataImageNode(this).stringify();
    }
}

