/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.ConfigurableProducerSpec;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.PayloadIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableProducerWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableProducerWorker.class);
    private final String id;
    private final ConfigurableProducerSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;

    public ConfigurableProducerWorker(String id, ConfigurableProducerSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("ConfigurableProducerWorker is already running.");
        }
        log.info("{}: Activating ConfigurableProducerWorker with {}", (Object)this.id, (Object)this.spec);
        this.executor = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory((String)"ConfigurableProducerWorkerThread%d", (boolean)false));
        this.status = status;
        this.doneFuture = doneFuture;
        this.executor.submit(new Prepare());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("ConfigurableProducerWorker is not running.");
        }
        log.info("{}: Deactivating ConfigurableProducerWorker.", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public class Prepare
    implements Runnable {
        @Override
        public void run() {
            try {
                HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
                if (ConfigurableProducerWorker.this.spec.activeTopic().materialize().size() != 1) {
                    throw new RuntimeException("Can only run against 1 topic.");
                }
                ArrayList<TopicPartition> active = new ArrayList<TopicPartition>();
                for (Map.Entry<String, PartitionsSpec> entry : ConfigurableProducerWorker.this.spec.activeTopic().materialize().entrySet()) {
                    String topicName = entry.getKey();
                    PartitionsSpec partSpec = entry.getValue();
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                    for (Integer partitionNumber : partSpec.partitionNumbers()) {
                        active.add(new TopicPartition(topicName, partitionNumber.intValue()));
                    }
                }
                ConfigurableProducerWorker.this.status.update((JsonNode)new TextNode("Creating " + newTopics.keySet().size() + " topic(s)"));
                WorkerUtils.createTopics(log, ConfigurableProducerWorker.this.spec.bootstrapServers(), ConfigurableProducerWorker.this.spec.commonClientConf(), ConfigurableProducerWorker.this.spec.adminClientConf(), newTopics, false);
                ConfigurableProducerWorker.this.status.update((JsonNode)new TextNode("Created " + newTopics.keySet().size() + " topic(s)"));
                ConfigurableProducerWorker.this.executor.submit(new SendRecords(((TopicPartition)active.get(0)).topic(), ConfigurableProducerWorker.this.spec.activePartition()));
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, ConfigurableProducerWorker.this.doneFuture);
            }
        }
    }

    public static class StatusData {
        private final long totalSent;
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p95LatencyMs;
        private final int p99LatencyMs;
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs) {
            this.totalSent = totalSent;
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p95LatencyMs = p95latencyMs;
            this.p99LatencyMs = p99latencyMs;
        }

        @JsonProperty
        public long totalSent() {
            return this.totalSent;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p95LatencyMs() {
            return this.p95LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;

        StatusUpdater(Histogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, ConfigurableProducerWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(summary.numSamples(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value());
            ConfigurableProducerWorker.this.status.update(JsonUtil.JSON_SERDE.valueToTree((Object)statusData));
            return statusData;
        }
    }

    public class SendRecords
    implements Callable<Void> {
        private final String activeTopic;
        private final int activePartition;
        private final Histogram histogram;
        private final Future<?> statusUpdaterFuture;
        private final KafkaProducer<byte[], byte[]> producer;
        private final PayloadIterator keys;
        private final PayloadIterator values;
        private Future<RecordMetadata> sendFuture;

        SendRecords(String topic, int partition) {
            this.activeTopic = topic;
            this.activePartition = partition;
            this.histogram = new Histogram(10000);
            this.statusUpdaterFuture = ConfigurableProducerWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram), 30L, 30L, TimeUnit.SECONDS);
            Properties props = new Properties();
            props.put("bootstrap.servers", ConfigurableProducerWorker.this.spec.bootstrapServers());
            WorkerUtils.addConfigsToProperties(props, ConfigurableProducerWorker.this.spec.commonClientConf(), ConfigurableProducerWorker.this.spec.producerConf());
            this.producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
            this.keys = new PayloadIterator(ConfigurableProducerWorker.this.spec.keyGenerator());
            this.values = new PayloadIterator(ConfigurableProducerWorker.this.spec.valueGenerator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long startTimeMs = Time.SYSTEM.milliseconds();
            try {
                try {
                    try {
                        long sentMessages = 0L;
                        while (true) {
                            this.sendMessage();
                            ++sentMessages;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.sendFuture != null) {
                            try {
                                this.sendFuture.get();
                            }
                            catch (Exception e) {
                                log.error("Exception on final future", (Throwable)e);
                            }
                        }
                        this.producer.close();
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    WorkerUtils.abort(log, "SendRecords", e, ConfigurableProducerWorker.this.doneFuture);
                    this.statusUpdaterFuture.cancel(false);
                    StatusData statusData = new StatusUpdater(this.histogram).update();
                    long curTimeMs = Time.SYSTEM.milliseconds();
                    log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
                }
            }
            catch (Throwable throwable) {
                this.statusUpdaterFuture.cancel(false);
                StatusData statusData = new StatusUpdater(this.histogram).update();
                long curTimeMs = Time.SYSTEM.milliseconds();
                log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
                throw throwable;
            }
            ConfigurableProducerWorker.this.doneFuture.complete((Object)"");
            return null;
        }

        private void sendMessage() throws InterruptedException {
            ProducerRecord record = this.activePartition != -1 ? new ProducerRecord(this.activeTopic, Integer.valueOf(this.activePartition), (Object)this.keys.next(), (Object)this.values.next()) : new ProducerRecord(this.activeTopic, (Object)this.keys.next(), (Object)this.values.next());
            this.sendFuture = this.producer.send(record, (Callback)new SendRecordsCallback(this, Time.SYSTEM.milliseconds()));
            ConfigurableProducerWorker.this.spec.flushGenerator().ifPresent(flushGenerator -> flushGenerator.increment(this.producer));
            ConfigurableProducerWorker.this.spec.throughputGenerator().throttle();
        }

        void recordDuration(long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    private static class SendRecordsCallback
    implements Callback {
        private final SendRecords sendRecords;
        private final long startMs;

        SendRecordsCallback(SendRecords sendRecords, long startMs) {
            this.sendRecords = sendRecords;
            this.startMs = startMs;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = Time.SYSTEM.milliseconds();
            long durationMs = now - this.startMs;
            this.sendRecords.recordDuration(durationMs);
            if (exception != null) {
                log.error("SendRecordsCallback: error", (Throwable)exception);
            }
        }
    }
}

