/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.time.Duration;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StringFormatter {
    public static String dateString(long timeMs, ZoneOffset zoneOffset) {
        return new Date(timeMs).toInstant().atOffset(zoneOffset).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String durationString(long periodMs) {
        long seconds;
        long minutes;
        StringBuilder bld = new StringBuilder();
        Duration duration = Duration.ofMillis(periodMs);
        long hours = duration.toHours();
        if (hours > 0L) {
            bld.append(hours).append("h");
            duration = duration.minusHours(hours);
        }
        if ((minutes = duration.toMinutes()) > 0L) {
            bld.append(minutes).append("m");
            duration = duration.minusMinutes(minutes);
        }
        if ((seconds = duration.getSeconds()) != 0L || bld.toString().isEmpty()) {
            bld.append(seconds).append("s");
        }
        return bld.toString();
    }

    public static String prettyPrintGrid(List<List<String>> lines) {
        int numColumns = -1;
        int rowIndex = 0;
        for (List<String> col : lines) {
            if (numColumns == -1) {
                numColumns = col.size();
            } else if (numColumns != col.size()) {
                throw new RuntimeException("Expected " + numColumns + " columns in row " + rowIndex + ", but got " + col.size());
            }
            ++rowIndex;
        }
        ArrayList<Integer> widths = new ArrayList<Integer>(numColumns);
        for (int x = 0; x < numColumns; ++x) {
            int w = 0;
            for (List<String> cols : lines) {
                w = Math.max(w, cols.get(x).length() + 1);
            }
            widths.add(w);
        }
        StringBuilder bld = new StringBuilder();
        for (List<String> cols : lines) {
            for (int x = 0; x < cols.size(); ++x) {
                String val = cols.get(x);
                int minWidth = (Integer)widths.get(x);
                bld.append(val);
                for (int i = 0; i < minWidth - val.length(); ++i) {
                    bld.append(" ");
                }
            }
            bld.append(String.format("%n", new Object[0]));
        }
        return bld.toString();
    }
}

