/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.common.Location;
import com.sparshui.server.GestureServer;
import com.sparshui.server.TouchPoint;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class InputDeviceConnection
implements Runnable {
    private GestureServer _gestureServer;
    private Socket _socket;
    private DataInputStream _in;
    private Map<Integer, TouchPoint> _touchPoints;
    private List<Integer> _flaggedids;

    public InputDeviceConnection(GestureServer gestureServer, Socket socket) throws IOException {
        this._gestureServer = gestureServer;
        this._socket = socket;
        this._in = new DataInputStream(socket.getInputStream());
        this._touchPoints = new Hashtable<Integer, TouchPoint>();
        this._flaggedids = new ArrayList<Integer>();
        this.startListening();
    }

    private void removeDeadTouchPoints() {
        for (int i = 0; i < this._flaggedids.size(); ++i) {
            Integer id = this._flaggedids.get(i);
            this._touchPoints.remove(id);
        }
        this._flaggedids.clear();
    }

    private void flagTouchPointForRemoval(int id) {
        this._flaggedids.add(id);
    }

    private void receiveData() {
        try {
            while (!this._socket.isInputShutdown()) {
                this.readTouchPoints();
            }
        }
        catch (IOException e) {
            System.out.println("[InputDeviceConnection] InputDevice Disconnected");
            this._gestureServer.notifyInputLost();
        }
    }

    private boolean readTouchPoints() throws IOException {
        int touchPointDataLength;
        int count = this._in.readInt();
        if (count == 0) {
            this._in.close();
            return false;
        }
        if (count < 0) {
            count = -count;
            touchPointDataLength = this._in.readInt();
        } else {
            touchPointDataLength = 13;
        }
        boolean doConsume = false;
        for (int i = 0; i < count; ++i) {
            doConsume |= this.readTouchPoint(touchPointDataLength);
        }
        this.removeDeadTouchPoints();
        return doConsume;
    }

    private boolean readTouchPoint(int len) throws IOException {
        long time;
        int id = this._in.readInt();
        float x = this._in.readFloat();
        float y = this._in.readFloat();
        byte state = this._in.readByte();
        long l = time = len >= 21 ? this._in.readLong() : System.currentTimeMillis();
        if (len > 21) {
            this._in.read(new byte[len - 21]);
        }
        Location location = new Location(x, y);
        boolean doConsume = this._gestureServer.processTouchPoint(this._touchPoints, id, location, time, state);
        if (state == 1) {
            this.flagTouchPointForRemoval(id);
        }
        return doConsume;
    }

    private void startListening() {
        Thread thread = new Thread(this);
        thread.setName("SparshUI Server->InputDeviceConnection on port 5947");
        thread.start();
    }

    @Override
    public void run() {
        this.receiveData();
    }
}

