/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.ExclusiveContentRepository;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.artifacts.repositories.InclusiveRepositoryContentDescriptor;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.ConfigureByMapAction;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.internal.artifacts.DefaultArtifactRepositoryContainer;
import org.gradle.api.internal.artifacts.dsl.RepositoryHandlerInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultRepositoryHandler
extends DefaultArtifactRepositoryContainer
implements RepositoryHandlerInternal {
    public static final String GRADLE_PLUGIN_PORTAL_REPO_NAME = "Gradle Central Plugin Repository";
    public static final String DEFAULT_BINTRAY_JCENTER_REPO_NAME = "BintrayJCenter";
    public static final String BINTRAY_JCENTER_URL = "https://jcenter.bintray.com/";
    public static final String GOOGLE_REPO_NAME = "Google";
    public static final String FLAT_DIR_DEFAULT_NAME = "flatDir";
    private static final String MAVEN_REPO_DEFAULT_NAME = "maven";
    private static final String IVY_REPO_DEFAULT_NAME = "ivy";
    private final BaseRepositoryFactory repositoryFactory;
    private final Instantiator instantiator;
    private boolean exclusiveContentInUse = false;

    public DefaultRepositoryHandler(BaseRepositoryFactory repositoryFactory, Instantiator instantiator, CollectionCallbackActionDecorator decorator) {
        super(instantiator, decorator);
        this.repositoryFactory = repositoryFactory;
        this.instantiator = instantiator;
    }

    public FlatDirectoryArtifactRepository flatDir(Action<? super FlatDirectoryArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createFlatDirRepository(), FLAT_DIR_DEFAULT_NAME, action);
    }

    public FlatDirectoryArtifactRepository flatDir(Closure configureClosure) {
        return this.flatDir((Action<? super FlatDirectoryArtifactRepository>)ConfigureUtil.configureUsing((Closure)configureClosure));
    }

    public FlatDirectoryArtifactRepository flatDir(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        if (modifiedArgs.containsKey("dirs")) {
            modifiedArgs.put("dirs", CollectionUtils.flattenCollections((Object[])new Object[]{modifiedArgs.get("dirs")}));
        }
        return this.flatDir((Action<? super FlatDirectoryArtifactRepository>)new ConfigureByMapAction(modifiedArgs));
    }

    public ArtifactRepository gradlePluginPortal() {
        return this.addRepository(this.repositoryFactory.createGradlePluginPortal(), GRADLE_PLUGIN_PORTAL_REPO_NAME);
    }

    public ArtifactRepository gradlePluginPortal(Action<? super ArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createGradlePluginPortal(), GRADLE_PLUGIN_PORTAL_REPO_NAME, action);
    }

    public MavenArtifactRepository mavenCentral() {
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo");
    }

    public MavenArtifactRepository mavenCentral(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo", action);
    }

    public MavenArtifactRepository mavenCentral(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.addRepository(this.repositoryFactory.createMavenCentralRepository(), "MavenRepo", new ConfigureByMapAction(modifiedArgs));
    }

    public MavenArtifactRepository mavenLocal() {
        return this.addRepository(this.repositoryFactory.createMavenLocalRepository(), "MavenLocal");
    }

    public MavenArtifactRepository mavenLocal(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createMavenLocalRepository(), "MavenLocal", action);
    }

    public MavenArtifactRepository google() {
        return this.addRepository(this.repositoryFactory.createGoogleRepository(), GOOGLE_REPO_NAME);
    }

    public MavenArtifactRepository google(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createGoogleRepository(), GOOGLE_REPO_NAME, action);
    }

    public MavenArtifactRepository maven(Action<? super MavenArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createMavenRepository(), MAVEN_REPO_DEFAULT_NAME, action);
    }

    public MavenArtifactRepository maven(Closure closure) {
        return this.maven((Action<? super MavenArtifactRepository>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public IvyArtifactRepository ivy(Action<? super IvyArtifactRepository> action) {
        return this.addRepository(this.repositoryFactory.createIvyRepository(), IVY_REPO_DEFAULT_NAME, action);
    }

    public IvyArtifactRepository ivy(Closure closure) {
        return this.ivy((Action<? super IvyArtifactRepository>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public void exclusiveContent(Action<? super ExclusiveContentRepository> action) {
        ExclusiveContentRepositorySpec spec = (ExclusiveContentRepositorySpec)Cast.uncheckedCast((Object)this.instantiator.newInstance(ExclusiveContentRepositorySpec.class, new Object[]{this}));
        spec.apply(action);
        this.exclusiveContentInUse = true;
    }

    @Override
    public boolean isExclusiveContentInUse() {
        return this.exclusiveContentInUse;
    }

    private static Action<? super RepositoryContentDescriptor> transformForExclusivity(Action<? super InclusiveRepositoryContentDescriptor> config) {
        return desc -> config.execute((Object)new InclusiveRepositoryContentDescriptor((RepositoryContentDescriptor)desc){
            final /* synthetic */ RepositoryContentDescriptor val$desc;
            {
                this.val$desc = repositoryContentDescriptor;
            }

            public void includeGroup(String group) {
                this.val$desc.excludeGroup(group);
            }

            public void includeGroupAndSubgroups(String groupPrefix) {
                this.val$desc.excludeGroupAndSubgroups(groupPrefix);
            }

            public void includeGroupByRegex(String groupRegex) {
                this.val$desc.excludeGroupByRegex(groupRegex);
            }

            public void includeModule(String group, String moduleName) {
                this.val$desc.excludeModule(group, moduleName);
            }

            public void includeModuleByRegex(String groupRegex, String moduleNameRegex) {
                this.val$desc.excludeModuleByRegex(groupRegex, moduleNameRegex);
            }

            public void includeVersion(String group, String moduleName, String version) {
                this.val$desc.excludeVersion(group, moduleName, version);
            }

            public void includeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
                this.val$desc.excludeVersionByRegex(groupRegex, moduleNameRegex, versionRegex);
            }
        });
    }

    public static class ExclusiveContentRepositorySpec
    implements ExclusiveContentRepository {
        private final RepositoryHandler repositories;
        private final List<Factory<? extends ArtifactRepository>> forRepositories = new ArrayList<Factory<? extends ArtifactRepository>>(2);
        private Action<? super InclusiveRepositoryContentDescriptor> filter;

        public ExclusiveContentRepositorySpec(RepositoryHandler repositories) {
            this.repositories = repositories;
        }

        public ExclusiveContentRepository forRepository(Factory<? extends ArtifactRepository> repositoryProducer) {
            this.forRepositories.add(repositoryProducer);
            return this;
        }

        public ExclusiveContentRepository forRepositories(ArtifactRepository ... repositories) {
            Stream.of(repositories).forEach(r -> this.forRepositories.add((Factory<? extends ArtifactRepository>)((Factory)() -> r)));
            return this;
        }

        public ExclusiveContentRepository filter(Action<? super InclusiveRepositoryContentDescriptor> config) {
            this.filter = this.filter == null ? config : Actions.composite((Action[])new Action[]{this.filter, config});
            return this;
        }

        void apply(Action<? super ExclusiveContentRepository> action) {
            action.execute((Object)this);
            if (this.forRepositories.isEmpty()) {
                throw new InvalidUserCodeException("You must declare the repository using forRepository { ... }");
            }
            if (this.filter == null) {
                throw new InvalidUserCodeException("You must specify the filter for the repository using filter { ... }");
            }
            Set targetRepositories = this.forRepositories.stream().map(Factory::create).collect(Collectors.toSet());
            Action forExclusivity = DefaultRepositoryHandler.transformForExclusivity((Action<? super InclusiveRepositoryContentDescriptor>)this.filter);
            this.repositories.all(repo -> {
                if (targetRepositories.contains(repo)) {
                    repo.content(this.filter);
                } else {
                    repo.content(forExclusivity);
                }
            });
        }
    }
}

