/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueFactory;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.CalcValue;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorMixFunction;
import io.sf.carte.doc.style.css.property.CounterValue;
import io.sf.carte.doc.style.css.property.CountersValue;
import io.sf.carte.doc.style.css.property.ElementReferenceValue;
import io.sf.carte.doc.style.css.property.EnvVariableValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.GradientValue;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.HWBColorValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.InitialValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.MathFunctionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OKLABColorValue;
import io.sf.carte.doc.style.css.property.OKLCHColorValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColorValue;
import io.sf.carte.doc.style.css.property.RatioValue;
import io.sf.carte.doc.style.css.property.RectValue;
import io.sf.carte.doc.style.css.property.RevertValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.UnicodeRangeValue;
import io.sf.carte.doc.style.css.property.UnicodeWildcardValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.doc.style.css.property.UnsetValue;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class ValueFactory
implements CSSValueFactory {
    private final short flags;

    public ValueFactory() {
        this(0);
    }

    public ValueFactory(short flags) {
        this.flags = flags;
    }

    public static boolean isSizeSACUnit(LexicalUnit unit) {
        return ValueFactory.sizeSACUnit(unit) != 255;
    }

    private static short sizeSACUnit(LexicalUnit unit) {
        LexicalUnit.LexicalType type = unit.getLexicalUnitType();
        short cssUnit = ValueFactory.isFunctionType(type) ? ValueFactory.functionDimensionArgumentUnit(unit) : (type == LexicalUnit.LexicalType.SUB_EXPRESSION ? ValueFactory.subexpressionDimensionUnit(unit) : unit.getCssUnit());
        if (CSSUnit.isLengthUnitType(cssUnit) || cssUnit == 2) {
            return cssUnit;
        }
        if (type == LexicalUnit.LexicalType.INTEGER && unit.getIntegerValue() == 0) {
            return 0;
        }
        return 255;
    }

    private static boolean isFunctionType(LexicalUnit.LexicalType type) {
        return type == LexicalUnit.LexicalType.MATH_FUNCTION || type == LexicalUnit.LexicalType.FUNCTION || type == LexicalUnit.LexicalType.CALC || type == LexicalUnit.LexicalType.VAR || type == LexicalUnit.LexicalType.ATTR;
    }

    public static boolean isResolutionSACUnit(LexicalUnit unit) {
        LexicalUnit.LexicalType type = unit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(type)) {
            return (unit = ValueFactory.firstDimensionArgument(unit)) != null && ValueFactory.isResolutionSACUnit(unit);
        }
        short cssUnit = unit.getCssUnit();
        return CSSUnit.isResolutionUnitType(cssUnit);
    }

    public static boolean isPositiveSizeSACUnit(LexicalUnit unit) {
        boolean function;
        short cssUnit;
        LexicalUnit.LexicalType utype = unit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(utype)) {
            cssUnit = ValueFactory.functionDimensionArgumentUnit(unit);
            function = true;
        } else {
            cssUnit = unit.getCssUnit();
            function = false;
        }
        return !(!CSSUnit.isLengthUnitType(cssUnit) && cssUnit != 2 && cssUnit != 1 || !function && !(unit.getFloatValue() > 0.0f));
    }

    public static boolean isSizeOrNumberSACUnit(LexicalUnit unit) {
        short cssUnit;
        LexicalUnit.LexicalType type = unit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(type)) {
            cssUnit = ValueFactory.functionDimensionArgumentUnit(unit);
        } else {
            if (type == LexicalUnit.LexicalType.INTEGER || type == LexicalUnit.LexicalType.REAL) {
                return true;
            }
            cssUnit = unit.getCssUnit();
        }
        return CSSUnit.isLengthUnitType(cssUnit) || cssUnit == 2 || cssUnit == 1;
    }

    public static boolean isPlainNumberOrPercentSACUnit(LexicalUnit unit) {
        LexicalUnit.LexicalType type = unit.getLexicalUnitType();
        switch (type) {
            case PERCENTAGE: 
            case INTEGER: 
            case REAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAngleSACUnit(LexicalUnit unit) {
        LexicalUnit.LexicalType type = unit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(type)) {
            if (ValueFactory.isGradientFunction(unit)) {
                return false;
            }
            return (unit = ValueFactory.firstDimensionArgument(unit)) != null && ValueFactory.isAngleSACUnit(unit);
        }
        if (type == LexicalUnit.LexicalType.INTEGER) {
            return unit.getIntegerValue() == 0;
        }
        short cssunit = unit.getCssUnit();
        return CSSUnit.isAngleUnitType(cssunit);
    }

    public static boolean isTimeSACUnit(LexicalUnit unit) {
        LexicalUnit.LexicalType type = unit.getLexicalUnitType();
        if (ValueFactory.isFunctionType(type)) {
            return (unit = ValueFactory.firstDimensionArgument(unit)) != null && ValueFactory.isTimeSACUnit(unit);
        }
        if (type == LexicalUnit.LexicalType.INTEGER) {
            return unit.getIntegerValue() == 0;
        }
        short cssunit = unit.getCssUnit();
        return CSSUnit.isTimeUnitType(cssunit);
    }

    static short functionDimensionArgumentUnit(LexicalUnit lunit) {
        if (ValueFactory.isGradientFunction(lunit)) {
            return -1;
        }
        LexicalUnit lu = lunit.getParameters();
        while (lu != null) {
            short type = ValueFactory.sizeSACUnit(lu);
            if (type != 255) {
                return type;
            }
            if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            lu = lu.getNextLexicalUnit();
        }
        return -1;
    }

    static short subexpressionDimensionUnit(LexicalUnit lunit) {
        LexicalUnit lu = lunit.getSubValues();
        while (lu != null) {
            short type = ValueFactory.sizeSACUnit(lu);
            if (type != 255) {
                return type;
            }
            if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            lu = lu.getNextLexicalUnit();
        }
        return -1;
    }

    private static LexicalUnit firstDimensionArgument(LexicalUnit lunit) {
        for (LexicalUnit lu = lunit.getParameters(); lu != null; lu = lu.getNextLexicalUnit()) {
            LexicalUnit.LexicalType sacType = lu.getLexicalUnitType();
            if (sacType != LexicalUnit.LexicalType.DIMENSION) continue;
            return lu;
        }
        return null;
    }

    private static boolean isGradientFunction(LexicalUnit lunit) {
        String name = lunit.getFunctionName().toLowerCase(Locale.ROOT);
        return name.endsWith("-gradient");
    }

    public StyleValue parseProperty(String value) throws DOMException {
        return this.parseProperty(value, new CSSOMParser());
    }

    public StyleValue parseProperty(String value, Parser parser) throws DOMException {
        return this.parseProperty("", value, parser);
    }

    public StyleValue parseProperty(String propertyName, String value, CSSParser parser) throws DOMException {
        StringReader re = new StringReader(value);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(propertyName, re);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        StyleValue css = this.createCSSValue(lunit);
        if (css == null) {
            css = this.createUnknownValue(value, lunit);
        }
        return css;
    }

    public StyleValue parseProperty(String propertyName, String value, Parser parser) throws DOMException {
        StringReader re = new StringReader(value);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(re);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        StyleValue css = this.createCSSValue(lunit);
        if (css == null) {
            css = this.createUnknownValue(value, lunit);
        }
        return css;
    }

    private UnknownValue createUnknownValue(String value, LexicalUnit lunit) {
        UnknownValue css;
        if (!this.isOperatorType(lunit.getLexicalUnitType())) {
            css = new UnknownValue();
            css.setCssText(value);
            ((PrimitiveValue)css).newLexicalSetter().setLexicalUnit(lunit);
        } else {
            css = null;
        }
        return css;
    }

    private boolean isOperatorType(LexicalUnit.LexicalType luType) {
        switch (luType) {
            case OPERATOR_COMMA: 
            case OPERATOR_EXP: 
            case OPERATOR_GE: 
            case OPERATOR_GT: 
            case OPERATOR_LE: 
            case OPERATOR_LT: 
            case OPERATOR_MINUS: 
            case OPERATOR_MULTIPLY: 
            case OPERATOR_PLUS: 
            case OPERATOR_SEMICOLON: 
            case OPERATOR_SLASH: 
            case OPERATOR_TILDE: {
                return true;
            }
        }
        return false;
    }

    public PrimitiveValue parseMediaFeature(String feature) throws DOMException {
        return this.parseMediaFeature(feature, new CSSOMParser());
    }

    public PrimitiveValue parseMediaFeature(String feature, Parser parser) throws DOMException {
        StringReader re = new StringReader(feature);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(re);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        PrimitiveValue.LexicalSetter item = this.createCSSPrimitiveValueItem(lunit, true, false);
        if (item.getNextLexicalUnit() != null) {
            throw new DOMException(12, "Bad feature: " + feature);
        }
        return item.getCSSValue();
    }

    @Override
    public StyleValue createCSSValue(LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(lunit, null);
    }

    public StyleValue createCSSValue(LexicalUnit lunit, AbstractCSSStyleDeclaration style) throws DOMException {
        return this.createCSSValue(lunit, style, false);
    }

    public StyleValue createCSSValue(LexicalUnit lunit, AbstractCSSStyleDeclaration style, boolean subproperty) throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        if (lunit.getNextLexicalUnit() != null) {
            ValueList superlist = null;
            ValueList list = ValueList.createWSValueList();
            try {
                StyleValue value;
                LexicalUnit nlu = lunit;
                do {
                    if (nlu.getLexicalUnitType() != LexicalUnit.LexicalType.LEFT_BRACKET) {
                        CSSValue.CssType cat;
                        StyleDeclarationErrorHandler errHandler2;
                        ValueItem item = this.createCSSValueItem(nlu, subproperty);
                        if (item.hasWarnings() && style != null && (errHandler2 = style.getStyleDeclarationErrorHandler()) != null) {
                            item.handleSyntaxWarnings(errHandler2);
                        }
                        nlu = (cat = (value = item.getCSSValue()).getCssValueType()) == CSSValue.CssType.TYPED || cat == CSSValue.CssType.PROXY ? item.getNextLexicalUnit() : nlu.getNextLexicalUnit();
                    } else {
                        if ((nlu = nlu.getNextLexicalUnit()) == null) {
                            throw new DOMException(12, "Unmatched '['");
                        }
                        ListValueItem listitem = this.parseBracketList(nlu, style, subproperty);
                        if (listitem != null) {
                            value = listitem.getCSSValue();
                            nlu = listitem.getNextLexicalUnit();
                        } else {
                            nlu = nlu.getNextLexicalUnit();
                            continue;
                        }
                    }
                    if (nlu != null) {
                        if (nlu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            nlu = nlu.getNextLexicalUnit();
                            if (superlist == null) {
                                superlist = ValueList.createCSValueList();
                            }
                            if (list.getLength() > 0) {
                                list.add(value);
                                superlist.add(list);
                                list = ValueList.createWSValueList();
                                continue;
                            }
                            superlist.add(value);
                            continue;
                        }
                        list.add(value);
                        continue;
                    }
                    if (superlist == null) {
                        list.add(value);
                        break;
                    }
                    if (list.getLength() > 0) {
                        list.add(value);
                        superlist.add(list);
                        break;
                    }
                    superlist.add(value);
                    break;
                } while (nlu != null);
                if (superlist != null) {
                    value = ValueFactory.listOrFirstItem(superlist);
                    if (value.getCssValueType() == CSSValue.CssType.LIST) {
                        return ValueFactory.listOrFirstItem((ValueList)value);
                    }
                    return value;
                }
            }
            catch (CSSLexicalProcessingException e) {
                PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
                item.setLexicalUnit(lunit);
                return item.getCSSValue();
            }
            return ValueFactory.listOrFirstItem(list);
        }
        ValueItem item = this.createCSSValueItem(lunit, subproperty);
        if (item.hasWarnings() && style != null && (errHandler = style.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        return item.getCSSValue();
    }

    public ListValueItem parseBracketList(LexicalUnit nlu, AbstractCSSStyleDeclaration style, boolean subproperty) {
        ListValueItem listitem = new ListValueItem();
        listitem.list = ValueList.createBracketValueList();
        try {
            while (nlu.getLexicalUnitType() != LexicalUnit.LexicalType.RIGHT_BRACKET) {
                StyleValue value;
                StyleDeclarationErrorHandler errHandler;
                ValueItem item = this.createCSSValueItem(nlu, subproperty);
                if (item.hasWarnings() && style != null && (errHandler = style.getStyleDeclarationErrorHandler()) != null) {
                    item.handleSyntaxWarnings(errHandler);
                }
                nlu = (value = item.getCSSValue()).getCssValueType() == CSSValue.CssType.TYPED ? item.getNextLexicalUnit() : nlu.getNextLexicalUnit();
                listitem.list.add(value);
                if (nlu != null) {
                    if (nlu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || (nlu = nlu.getNextLexicalUnit()) != null) continue;
                    throw new DOMException(12, "Unmatched '['");
                }
                throw new DOMException(12, "Unmatched '['");
            }
            if (listitem.list.getLength() != 0) {
                listitem.nextLexicalUnit = nlu.getNextLexicalUnit();
            } else {
                listitem = null;
            }
        }
        catch (CSSLexicalProcessingException e) {
            listitem.list.clear();
            PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
            item.setLexicalUnit(nlu);
            listitem.list.add(item.getCSSValue());
            listitem.nextLexicalUnit = null;
        }
        return listitem;
    }

    private static StyleValue listOrFirstItem(ValueList list) {
        int ll = list.getLength();
        if (ll > 1) {
            return list;
        }
        if (ll == 1) {
            return list.item(0);
        }
        return null;
    }

    public ValueItem createCSSValueItem(LexicalUnit lunit, boolean subproperty) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case INHERIT: {
                KeywordValue value = InheritValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
            case UNSET: {
                KeywordValue value = UnsetValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
            case REVERT: {
                KeywordValue value = RevertValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
            case INITIAL: {
                KeywordValue value = InitialValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
        }
        try {
            return this.createCSSPrimitiveValueItem(lunit, !subproperty, subproperty);
        }
        catch (CSSLexicalProcessingException e) {
            if (!this.isNotListLexicalUnit(lunit)) {
                throw e;
            }
            PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
            item.setLexicalUnit(lunit);
            return item;
        }
    }

    @Override
    public PrimitiveValue createCSSPrimitiveValue(LexicalUnit lunit) throws DOMException {
        PrimitiveValue value;
        try {
            value = this.createCSSPrimitiveValueItem(lunit, false, true).getCSSValue();
        }
        catch (CSSLexicalProcessingException e) {
            if (!this.isIsolatedLexicalUnit(lunit)) {
                throw e;
            }
            PrimitiveValue.LexicalSetter item = new LexicalValue().newLexicalSetter();
            item.setLexicalUnit(lunit);
            value = item.getCSSValue();
        }
        return value;
    }

    PrimitiveValue createCSSPrimitiveValue(LexicalUnit lunit, boolean subp) throws DOMException {
        return this.createCSSPrimitiveValueItem(lunit, !subp, subp).getCSSValue();
    }

    PrimitiveValue.LexicalSetter createCSSPrimitiveValueItem(LexicalUnit lunit, boolean ratioContext, boolean subp) throws DOMException {
        PrimitiveValue.LexicalSetter setter;
        PrimitiveValue primi;
        LexicalUnit.LexicalType unitType = lunit.getLexicalUnitType();
        try {
            switch (unitType) {
                case IDENT: {
                    primi = new IdentifierValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case STRING: {
                    primi = new StringValue(this.flags);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case URI: {
                    primi = new URIValue(this.flags);
                    setter = primi.newLexicalSetter();
                    try {
                        setter.setLexicalUnit(lunit);
                    }
                    catch (CSSLexicalProcessingException e) {
                        primi = new LexicalValue();
                        setter = primi.newLexicalSetter();
                        setter.setLexicalUnit(lunit);
                    }
                    break;
                }
                case PERCENTAGE: {
                    primi = new PercentageValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case DIMENSION: {
                    primi = new NumberValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    if (CSSUnit.isLengthUnitType(lunit.getCssUnit())) {
                        ((NumberValue)primi).lengthUnitType = true;
                    }
                    break;
                }
                case REAL: {
                    primi = new NumberValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    if (ratioContext) {
                        return this.checkForRatio(setter, subp);
                    }
                    break;
                }
                case INTEGER: {
                    primi = new NumberValue();
                    ((NumberValue)primi).setIntegerValue(lunit.getIntegerValue());
                    setter = primi.newLexicalSetter();
                    primi.newLexicalSetter().nextLexicalUnit = lunit.getNextLexicalUnit();
                    if (ratioContext) {
                        return this.checkForRatio(setter, subp);
                    }
                    break;
                }
                case RGBCOLOR: {
                    primi = new RGBColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case HSLCOLOR: {
                    primi = new HSLColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case LABCOLOR: {
                    primi = new LABColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case LCHCOLOR: {
                    primi = new LCHColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case OKLABCOLOR: {
                    primi = new OKLABColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case OKLCHCOLOR: {
                    primi = new OKLCHColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case HWBCOLOR: {
                    primi = new HWBColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case CALC: {
                    primi = new CalcValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    if (ratioContext) {
                        return this.checkForRatio(setter, subp);
                    }
                    break;
                }
                case COLOR_FUNCTION: {
                    primi = new ColorFunction();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case FUNCTION: {
                    String func = lunit.getFunctionName().toLowerCase(Locale.ROOT);
                    if (func.endsWith("linear-gradient") || func.endsWith("radial-gradient") || func.endsWith("conic-gradient")) {
                        primi = new GradientValue();
                        setter = primi.newLexicalSetter();
                        try {
                            setter.setLexicalUnit(lunit);
                            break;
                        }
                        catch (CSSLexicalProcessingException e) {
                            if (!this.isNotListLexicalUnit(lunit)) {
                                throw e;
                            }
                            primi = new LexicalValue();
                            setter = primi.newLexicalSetter();
                            setter.setLexicalUnit(lunit);
                            break;
                        }
                        catch (RuntimeException e) {
                            if (func.charAt(0) == '-') {
                                primi = new FunctionValue();
                                setter = primi.newLexicalSetter();
                                setter.setLexicalUnit(lunit);
                                break;
                            }
                            throw e;
                        }
                    }
                    primi = "env".equals(func) ? new EnvVariableValue() : new FunctionValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case MATH_FUNCTION: {
                    primi = new MathFunctionValue(lunit.getMathFunctionIndex());
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case COLOR_MIX: {
                    primi = new ColorMixFunction();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case VAR: 
                case ATTR: {
                    if (!this.isIsolatedLexicalUnit(lunit)) {
                        throw new CSSLexicalProcessingException((Object)((Object)unitType) + " found.");
                    }
                }
                case EMPTY: {
                    primi = new LexicalValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case UNICODE_RANGE: {
                    primi = new UnicodeRangeValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case UNICODE_WILDCARD: {
                    primi = new UnicodeWildcardValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case RECT_FUNCTION: {
                    primi = new RectValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case COUNTER_FUNCTION: {
                    primi = new CounterValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case COUNTERS_FUNCTION: {
                    primi = new CountersValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case CUBIC_BEZIER_FUNCTION: {
                    primi = new FunctionValue(CSSValue.Type.CUBIC_BEZIER);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case STEPS_FUNCTION: {
                    primi = new FunctionValue(CSSValue.Type.STEPS);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case ELEMENT_REFERENCE: {
                    primi = new ElementReferenceValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case SRC: {
                    primi = new FunctionValue(CSSValue.Type.SRC);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    throw new DOMException(12, "A comma or semicolon is not a valid primitive");
                }
                case INHERIT: 
                case UNSET: 
                case REVERT: {
                    throw new DOMException(17, (Object)((Object)unitType) + " keyword is not a primitive.");
                }
                case OPERATOR_SLASH: {
                    if (this.isContentContext(lunit)) {
                        primi = new LexicalValue();
                        setter = primi.newLexicalSetter();
                        setter.setLexicalUnit(lunit.shallowClone());
                        setter.nextLexicalUnit = lunit.getNextLexicalUnit();
                        break;
                    }
                }
                case OPERATOR_MINUS: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_PLUS: {
                    if (!lunit.isParameter()) {
                        throw new DOMException(12, "A '" + lunit.toString() + "' is not a valid primitive");
                    }
                }
                default: {
                    primi = new UnknownValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                }
            }
        }
        catch (DOMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        primi.setSubproperty(subp);
        return setter;
    }

    private boolean isIsolatedLexicalUnit(LexicalUnit lunit) {
        return !lunit.isParameter() && lunit.getNextLexicalUnit() == null && lunit.getPreviousLexicalUnit() == null;
    }

    private boolean isNotListLexicalUnit(LexicalUnit lunit) {
        return lunit.getNextLexicalUnit() == null && lunit.getPreviousLexicalUnit() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PrimitiveValue.LexicalSetter checkForRatio(PrimitiveValue.LexicalSetter setter, boolean subp) throws DOMException {
        LexicalUnit nlu = setter.getNextLexicalUnit();
        if (nlu == null || nlu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) return setter;
        if ((nlu = nlu.getNextLexicalUnit()) == null) throw new DOMException(12, "Invalid ratio.");
        PrimitiveValue.LexicalSetter consec = this.createCSSPrimitiveValueItem(nlu, false, false);
        RatioValue ratio = new RatioValue();
        try {
            ratio.setAntecedentValue(setter.getCSSValue());
            ratio.setConsequentValue(consec.getCSSValue());
            setter = ratio.newLexicalSetter();
            setter.setLexicalUnit(consec.getNextLexicalUnit());
            ratio.setSubproperty(subp);
            return setter;
        }
        catch (DOMException e) {
            if (e.code != 15) return setter;
            throw e;
        }
    }

    private boolean isContentContext(LexicalUnit lunit) {
        LexicalUnit prevu = lunit.getPreviousLexicalUnit();
        LexicalUnit nextu = lunit.getNextLexicalUnit();
        if (prevu != null && nextu != null && !lunit.isParameter()) {
            CSSValueSyntax synpre = new SyntaxParser().parseSyntax("<string> | <counter> | <image> | <custom-ident>");
            CSSValueSyntax synafter = new SyntaxParser().parseSyntax("<string> | <counter>");
            return prevu.shallowClone().matches(synpre) != CSSValueSyntax.Match.FALSE && nextu.matches(synafter) != CSSValueSyntax.Match.FALSE;
        }
        return false;
    }

    public LexicalUnit appendValueString(StringBuilder buf, LexicalUnit lunit) {
        LexicalUnit nlu;
        LexicalUnit.LexicalType type = lunit.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(',');
        } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(' ').append('/');
        } else if (type != LexicalUnit.LexicalType.LEFT_BRACKET) {
            ValueItem item = this.createCSSValueItem(lunit, true);
            nlu = item.getNextLexicalUnit();
            StyleValue cssValue = item.getCSSValue();
            String cssText = cssValue.getCssText();
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(cssText);
        } else {
            nlu = lunit.getNextLexicalUnit();
            ListValueItem item = this.parseBracketList(nlu, null, false);
            if (item != null) {
                nlu = item.getNextLexicalUnit();
                buf.append(item.getCSSValue().getCssText());
            } else {
                nlu = nlu.getNextLexicalUnit();
            }
        }
        return nlu;
    }

    public LexicalUnit appendMinifiedValueString(StringBuilder buf, LexicalUnit lunit) {
        LexicalUnit nlu;
        LexicalUnit.LexicalType type = lunit.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(',');
        } else if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
            nlu = lunit.getNextLexicalUnit();
            buf.append('/');
        } else if (type != LexicalUnit.LexicalType.LEFT_BRACKET) {
            char c;
            ValueItem item = this.createCSSValueItem(lunit, true);
            nlu = item.getNextLexicalUnit();
            StyleValue cssValue = item.getCSSValue();
            String cssText = cssValue.getMinifiedCssText("");
            int len = buf.length();
            if (len != 0 && (c = buf.charAt(len - 1)) != ',' && c != '/') {
                buf.append(' ');
            }
            buf.append(cssText);
        } else {
            nlu = lunit.getNextLexicalUnit();
            ListValueItem item = this.parseBracketList(nlu, null, false);
            if (item != null) {
                nlu = item.getNextLexicalUnit();
                buf.append(item.getCSSValue().getMinifiedCssText(""));
            } else {
                nlu = nlu.getNextLexicalUnit();
            }
        }
        return nlu;
    }

    public boolean hasFactoryFlag(short flag) {
        return (this.flags & flag) == flag;
    }

    public static class ListValueItem
    extends BasicValueItem {
        private ValueList list = null;

        @Override
        public ValueList getCSSValue() {
            return this.list;
        }
    }

    static class BasicValueItem
    implements ValueItem {
        LexicalUnit nextLexicalUnit = null;

        BasicValueItem() {
        }

        @Override
        public StyleValue getCSSValue() {
            return null;
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler handler) {
        }
    }
}

