/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class GlyphOrientationManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 5;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case DIMENSION: {
                switch (lu.getCssUnit()) {
                    case 80: {
                        return new FloatValue(80, lu.getFloatValue());
                    }
                    case 81: {
                        return new FloatValue(81, lu.getFloatValue());
                    }
                    case 82: {
                        return new FloatValue(82, lu.getFloatValue());
                    }
                    case 83: {
                        return new FloatValue(80, lu.getFloatValue() * 360.0f);
                    }
                }
                break;
            }
            case INTEGER: {
                int n = lu.getIntegerValue();
                return new FloatValue(80, n);
            }
            case REAL: {
                float n = lu.getFloatValue();
                return new FloatValue(80, n);
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lu);
            }
            case CALC: {
                Value calc = this.createCalc(lu);
                if (calc.getPrimitiveType() != CSSValue.Type.EXPRESSION) {
                    return calc;
                }
                FloatValue f = ((CalcValue)calc).evaluate(null, null, engine, -1, null, (short)80);
                if (f.getUnitType() == 0) {
                    f = new FloatValue(80, f.getFloatValue());
                }
                return f;
            }
            case MATH_FUNCTION: {
                Value v;
                try {
                    v = this.createMathFunction(lu, "<angle>");
                }
                catch (Exception e) {
                    DOMException ife = this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                    ife.initCause(e);
                    throw ife;
                }
                return ((NumericDelegateValue)v).evaluate(null, null, engine, -1, null, (short)80);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short type, float floatValue) throws DOMException {
        switch (type) {
            case 80: 
            case 81: 
            case 82: {
                return new FloatValue(type, floatValue);
            }
        }
        float f = NumberValue.floatValueConversion((float)floatValue, (short)type, (short)80);
        return new FloatValue(80, f);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        return value;
    }
}

