/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.BasicTextPainter;
import io.sf.carte.echosvg.bridge.DefaultFontFamilyResolver;
import io.sf.carte.echosvg.bridge.FontFamilyResolver;
import io.sf.carte.echosvg.bridge.Mark;
import io.sf.carte.echosvg.bridge.TextHit;
import io.sf.carte.echosvg.bridge.TextNode;
import io.sf.carte.echosvg.bridge.TextPainter;
import io.sf.carte.echosvg.bridge.TextSpanLayout;
import io.sf.carte.echosvg.gvt.font.GVTFont;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.gvt.font.GVTGlyphMetrics;
import io.sf.carte.echosvg.gvt.font.GVTLineMetrics;
import io.sf.carte.echosvg.gvt.text.AttributedCharacterSpanIterator;
import io.sf.carte.echosvg.gvt.text.BidiAttributedCharacterIterator;
import io.sf.carte.echosvg.gvt.text.GVTAttributedCharacterIterator;
import io.sf.carte.echosvg.gvt.text.TextPaintInfo;
import io.sf.carte.echosvg.gvt.text.TextPath;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONTS = GVTAttributedCharacterIterator.TextAttribute.GVT_FONTS;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    public static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    public static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final Integer ADJUST_SPACING = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
    public static final Integer ADJUST_ALL = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
    public static final GVTAttributedCharacterIterator.TextAttribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    static Set<AttributedCharacterIterator.Attribute> extendedAtts = new HashSet<AttributedCharacterIterator.Attribute>();
    private static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    @Override
    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return;
        }
        List<TextRun> list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    protected void printAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        int n = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n2 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n2 - n) + ", ");
            attributedCharacterIterator.setIndex(n2);
            n = n2;
        }
        System.out.println("");
    }

    public List<TextRun> getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        List<TextRun> list = textNode.getTextRuns();
        if (list != null) {
            return list;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        list = this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray);
        textNode.setTextRuns(list);
        return textNode.getTextRuns();
    }

    public List<TextRun> computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        int[][] nArrayArray = new int[attributedCharacterIteratorArray.length][];
        int n = attributedCharacterIterator.getBeginIndex();
        for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
            BidiAttributedCharacterIterator bidiAttributedCharacterIterator = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[i], this.fontRenderContext, n);
            attributedCharacterIteratorArray[i] = bidiAttributedCharacterIterator;
            nArrayArray[i] = bidiAttributedCharacterIterator.getCharMap();
            n += attributedCharacterIteratorArray[i].getEndIndex() - attributedCharacterIteratorArray[i].getBeginIndex();
        }
        return this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray, nArrayArray);
    }

    protected List<TextRun> computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray, int[][] nArray) {
        TextChunk textChunk;
        int n = attributedCharacterIterator.getBeginIndex();
        for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
            attributedCharacterIteratorArray[i] = this.createModifiedACIForFontMatching(attributedCharacterIteratorArray[i]);
            n += attributedCharacterIteratorArray[i].getEndIndex() - attributedCharacterIteratorArray[i].getBeginIndex();
        }
        ArrayList<TextRun> arrayList = new ArrayList<TextRun>();
        TextChunk textChunk2 = null;
        int n2 = 0;
        Point2D point2D = textNode.getLocation();
        do {
            attributedCharacterIteratorArray[n2].first();
            List<TextRun> list = new ArrayList<TextRun>();
            textChunk = this.getTextChunk(textNode, attributedCharacterIteratorArray[n2], nArray != null ? nArray[n2] : null, list, textChunk2);
            list = this.reorderTextRuns(textChunk, list);
            attributedCharacterIteratorArray[n2].first();
            if (textChunk != null) {
                point2D = this.adjustChunkOffsets(point2D, list, textChunk);
            }
            arrayList.addAll(list);
            textChunk2 = textChunk;
        } while (textChunk != null && ++n2 < attributedCharacterIteratorArray.length);
        return arrayList;
    }

    protected List<TextRun> reorderTextRuns(TextChunk textChunk, List<TextRun> list) {
        return list;
    }

    protected AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        TextPath textPath;
        boolean bl;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        int n2 = attributedCharacterIterator.getBeginIndex();
        attributedCharacterIterator.first();
        Object object = attributedCharacterIterator.getAttribute(WRITING_MODE);
        boolean bl2 = bl = object == WRITING_MODE_TTB;
        while (attributedCharacterIterator.setIndex(n2) != '\uffff') {
            textPath = null;
            int n3 = n2;
            n = 0;
            while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
                Float f;
                Serializable serializable;
                TextPath textPath2 = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
                if (n3 != n2) {
                    if (!bl ? (serializable = (Float)attributedCharacterIterator.getAttribute(XPOS)) != null && !serializable.isNaN() : (serializable = (Float)attributedCharacterIterator.getAttribute(YPOS)) != null && !serializable.isNaN()) break;
                    if (textPath == null && textPath2 != null || textPath != null && textPath2 == null) break;
                }
                textPath = textPath2;
                if (attributedCharacterIterator.getAttribute(FLOW_PARAGRAPH) != null) {
                    n = attributedCharacterIterator.getRunLimit(FLOW_PARAGRAPH);
                    attributedCharacterIterator.setIndex(n);
                    break;
                }
                n = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
                if (n3 == n2 && (serializable = (TextNode.Anchor)attributedCharacterIterator.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START && !(bl ? (f = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f.isNaN() : (f = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f.isNaN())) {
                    int n4 = n3 + 1;
                    while (n4 < n) {
                        Float f2;
                        attributedCharacterIterator.setIndex(n4);
                        if (bl ? (f2 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f2.isNaN() : (f2 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f2.isNaN()) break;
                        arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n4 - 1, n4));
                        n2 = n4++;
                    }
                }
                n3 = n;
            }
            n3 = attributedCharacterIterator.getIndex();
            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n3));
            n2 = n3;
        }
        textPath = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            textPath[n] = (AttributedCharacterIterator)iterator.next();
            ++n;
        }
        return textPath;
    }

    protected AttributedCharacterIterator createModifiedACIForFontMatching(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedString attributedString = null;
        int n = 0;
        int n2 = attributedCharacterIterator.getBeginIndex();
        boolean bl = true;
        int n3 = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_ID);
        while (bl) {
            int n4;
            GVTFont gVTFont3;
            Object object;
            int n5 = n3;
            n3 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
            int n6 = n3 - n5;
            List list = (List)attributedCharacterIterator.getAttribute(GVT_FONTS);
            float f = 12.0f;
            Float f2 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            if (f2 != null) {
                f = f2.floatValue();
            }
            if (list.isEmpty() && (object = (Object)this.getFontFamilyResolver().getDefault().deriveFont(f, attributedCharacterIterator)) != null) {
                list.add(object);
            }
            object = new boolean[n6];
            if (attributedString == null) {
                attributedString = new AttributedString(attributedCharacterIterator);
            }
            GVTFont gVTFont2 = null;
            int n7 = 0;
            int n8 = n5;
            for (GVTFont gVTFont3 : list) {
                int n9 = n8;
                boolean bl2 = false;
                attributedCharacterIterator.setIndex(n9);
                if (gVTFont2 == null) {
                    gVTFont2 = gVTFont3;
                }
                while (n9 < n3) {
                    n4 = gVTFont3.canDisplayUpTo((CharacterIterator)attributedCharacterIterator, n9, n3);
                    Object object2 = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)ALT_GLYPH_HANDLER);
                    if (object2 != null) {
                        n4 = -1;
                    }
                    if (n4 == -1) {
                        n4 = n3;
                    }
                    if (n4 <= n9) {
                        if (!bl2) {
                            n8 = n9;
                            bl2 = true;
                        }
                        ++n9;
                        continue;
                    }
                    int n10 = -1;
                    for (int i = n9; i < n4; ++i) {
                        if (object[i - n5]) {
                            if (n10 != -1) {
                                attributedString.addAttribute(GVT_FONT, gVTFont3, n10 - n2, i - n2);
                                n10 = -1;
                            }
                        } else if (n10 == -1) {
                            n10 = i;
                        }
                        object[i - n5] = true;
                        ++n7;
                    }
                    if (n10 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont3, n10 - n2, n4 - n2);
                    }
                    n9 = n4 + 1;
                }
                if (n7 != n6) continue;
                break;
            }
            int n11 = -1;
            gVTFont3 = null;
            GVTFont gVTFont4 = gVTFont2;
            for (n4 = 0; n4 < n6; ++n4) {
                if (object[n4]) {
                    if (n11 == -1) continue;
                    attributedString.addAttribute(GVT_FONT, gVTFont4, n11 + n, n4 + n);
                    n11 = -1;
                    gVTFont4 = null;
                    gVTFont3 = null;
                    continue;
                }
                char c = attributedCharacterIterator.setIndex(n5 + n4);
                GVTFontFamily gVTFontFamily = this.getFontFamilyResolver().getFamilyThatCanDisplay(c);
                if (n11 == -1) {
                    n11 = n4;
                    gVTFont3 = gVTFontFamily;
                    if (gVTFont3 == null) {
                        gVTFont4 = gVTFont2;
                        continue;
                    }
                    gVTFont4 = gVTFontFamily.deriveFont(f, attributedCharacterIterator);
                    continue;
                }
                if (gVTFont3 == gVTFontFamily) continue;
                attributedString.addAttribute(GVT_FONT, gVTFont4, n11 + n, n4 + n);
                n11 = n4;
                gVTFont3 = gVTFontFamily;
                gVTFont4 = gVTFont3 == null ? gVTFont2 : gVTFontFamily.deriveFont(f, attributedCharacterIterator);
            }
            if (n11 != -1) {
                attributedString.addAttribute(GVT_FONT, gVTFont4, n11 + n, n6 + n);
            }
            n += n6;
            if (attributedCharacterIterator.setIndex(n3) == '\uffff') {
                bl = false;
            }
            n5 = n3;
        }
        if (attributedString != null) {
            return attributedString.getIterator();
        }
        return attributedCharacterIterator;
    }

    protected FontFamilyResolver getFontFamilyResolver() {
        return DefaultFontFamilyResolver.SINGLETON;
    }

    protected Set<AttributedCharacterIterator.Attribute> getTextRunBoundaryAttributes() {
        return extendedAtts;
    }

    protected TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, int[] nArray, List<TextRun> list, TextChunk textChunk) {
        int n = 0;
        if (textChunk != null) {
            n = textChunk.end;
        }
        int n2 = n;
        int n3 = attributedCharacterIterator.getIndex();
        if (attributedCharacterIterator.current() == '\uffff') {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
        boolean bl = true;
        TextSpanLayout textSpanLayout = null;
        Set<AttributedCharacterIterator.Attribute> set = this.getTextRunBoundaryAttributes();
        while (true) {
            int n4 = attributedCharacterIterator.getRunStart(set);
            int n5 = attributedCharacterIterator.getRunLimit(set);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n4, n5);
            int[] nArray2 = new int[n5 - n4];
            if (nArray != null) {
                System.arraycopy(nArray, n4 - n3, nArray2, 0, nArray2.length);
            } else {
                int n6 = nArray2.length;
                for (int i = 0; i < n6; ++i) {
                    nArray2[i] = i;
                }
            }
            FontRenderContext fontRenderContext = this.fontRenderContext;
            RenderingHints renderingHints = textNode.getRenderingHints();
            if (renderingHints != null && renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                fontRenderContext = this.aaOffFontRenderContext;
            }
            textSpanLayout = this.getTextLayoutFactory().createTextLayout((AttributedCharacterIterator)attributedCharacterSpanIterator, nArray2, float_, fontRenderContext);
            list.add(new TextRun(textSpanLayout, (AttributedCharacterIterator)attributedCharacterSpanIterator, bl));
            Point2D point2D = textSpanLayout.getAdvance2D();
            float_2.x += (float)point2D.getX();
            float_2.y += (float)point2D.getY();
            ++n2;
            if (attributedCharacterIterator.setIndex(n5) == '\uffff') break;
            bl = false;
        }
        return new TextChunk(n, n2, float_2);
    }

    protected Point2D adjustChunkOffsets(Point2D point2D, List<TextRun> list, TextChunk textChunk) {
        Point2D.Float float_;
        int n = textChunk.end - textChunk.begin;
        TextRun textRun = list.get(0);
        int n2 = textRun.getAnchorType();
        Float f = textRun.getLength();
        Integer n3 = textRun.getLengthAdjust();
        boolean bl = true;
        if (f == null || f.isNaN()) {
            bl = false;
        }
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            textRun = list.get(i);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            n4 += attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        if (n3 == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && n4 == 1) {
            bl = false;
        }
        float f2 = 1.0f;
        float f3 = 1.0f;
        textRun = list.get(n - 1);
        TextSpanLayout textSpanLayout = textRun.getLayout();
        GVTGlyphMetrics gVTGlyphMetrics = textSpanLayout.getGlyphMetrics(textSpanLayout.getGlyphCount() - 1);
        GVTLineMetrics gVTLineMetrics = textSpanLayout.getLineMetrics();
        Rectangle2D rectangle2D = gVTGlyphMetrics.getBounds2D();
        float f4 = (gVTGlyphMetrics.getVerticalAdvance() - (gVTLineMetrics.getAscent() + gVTLineMetrics.getDescent())) / 2.0f;
        float f5 = (float)(rectangle2D.getWidth() + rectangle2D.getX());
        float f6 = (float)((double)(f4 + gVTLineMetrics.getAscent()) + (rectangle2D.getHeight() + rectangle2D.getY()));
        if (!bl) {
            float_ = new Point2D.Float((float)textChunk.advance.getX(), (float)(textChunk.advance.getY() + (double)f6 - (double)gVTGlyphMetrics.getVerticalAdvance()));
        } else {
            double d;
            Point2D point2D2 = textChunk.advance;
            if (textSpanLayout.isVertical()) {
                if (n3 == ADJUST_SPACING) {
                    f3 = (float)((double)(f.floatValue() - f6) / (point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance()));
                } else {
                    d = point2D2.getY() + (double)f6 - (double)gVTGlyphMetrics.getVerticalAdvance();
                    f3 = (float)((double)f.floatValue() / d);
                }
                float_ = new Point2D.Float(0.0f, f.floatValue());
            } else {
                if (n3 == ADJUST_SPACING) {
                    f2 = (float)((double)(f.floatValue() - f5) / (point2D2.getX() - (double)gVTGlyphMetrics.getHorizontalAdvance()));
                } else {
                    d = point2D2.getX() + (double)f5 - (double)gVTGlyphMetrics.getHorizontalAdvance();
                    f2 = (float)((double)f.floatValue() / d);
                }
                float_ = new Point2D.Float(f.floatValue(), 0.0f);
            }
            Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
            for (int i = 0; i < n; ++i) {
                textRun = list.get(i);
                textSpanLayout = textRun.getLayout();
                textSpanLayout.setScale(f2, f3, n3 == ADJUST_SPACING);
                Point2D point2D3 = textSpanLayout.getAdvance2D();
                float_2.x += (float)point2D3.getX();
                float_2.y += (float)point2D3.getY();
            }
            textChunk.advance = float_2;
        }
        float f7 = 0.0f;
        float f8 = 0.0f;
        switch (n2) {
            case 1: {
                f7 = (float)(-((Point2D)float_).getX() / 2.0);
                f8 = (float)(-((Point2D)float_).getY() / 2.0);
                break;
            }
            case 2: {
                f7 = (float)(-((Point2D)float_).getX());
                f8 = (float)(-((Point2D)float_).getY());
                break;
            }
        }
        textRun = list.get(0);
        textSpanLayout = textRun.getLayout();
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        boolean bl2 = textSpanLayout.isVertical();
        Float f9 = (Float)attributedCharacterIterator.getAttribute(XPOS);
        Float f10 = (Float)attributedCharacterIterator.getAttribute(YPOS);
        TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
        float f11 = (float)point2D.getX();
        float f12 = (float)point2D.getY();
        float f13 = 0.0f;
        float f14 = 0.0f;
        if (f9 != null && !f9.isNaN()) {
            f13 = f11 = f9.floatValue();
        }
        if (f10 != null && !f10.isNaN()) {
            f14 = f12 = f10.floatValue();
        }
        if (bl2) {
            f12 += f8;
            f14 += f8;
            f13 = 0.0f;
        } else {
            f11 += f7;
            f13 += f7;
            f14 = 0.0f;
        }
        for (int i = 0; i < n; ++i) {
            Point2D point2D4;
            textRun = list.get(i);
            textSpanLayout = textRun.getLayout();
            attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
            if (bl2) {
                f9 = (Float)attributedCharacterIterator.getAttribute(XPOS);
                if (f9 != null && !f9.isNaN()) {
                    f11 = f9.floatValue();
                }
            } else {
                f10 = (Float)attributedCharacterIterator.getAttribute(YPOS);
                if (f10 != null && !f10.isNaN()) {
                    f12 = f10.floatValue();
                }
            }
            if (textPath == null) {
                textSpanLayout.setOffset(new Point2D.Float(f11, f12));
                point2D4 = textSpanLayout.getAdvance2D();
                f11 += (float)point2D4.getX();
                f12 += (float)point2D4.getY();
                continue;
            }
            textSpanLayout.setOffset(new Point2D.Float(f13, f14));
            point2D4 = textSpanLayout.getAdvance2D();
            f13 += (float)point2D4.getX();
            f14 += (float)point2D4.getY();
            point2D4 = textSpanLayout.getTextPathAdvance();
            f11 = (float)point2D4.getX();
            f12 = (float)point2D4.getY();
        }
        return new Point2D.Float(f11, f12);
    }

    protected void paintDecorations(List<TextRun> list, Graphics2D graphics2D, int n) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        boolean bl = true;
        RectangularShape rectangularShape = null;
        double d = 0.0;
        double d2 = 0.0;
        for (TextRun textRun : list) {
            Rectangle2D rectangle2D;
            Shape shape;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            boolean bl2 = true;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                bl2 = textPaintInfo.visible;
                if (textPaintInfo.composite != null) {
                    graphics2D.setComposite(textPaintInfo.composite);
                }
                switch (n) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n);
                rectangle2D = shape.getBounds2D();
                d = rectangle2D.getY();
                d2 = rectangle2D.getHeight();
            }
            if (textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2 || bl2 != bl) {
                if (bl && rectangularShape != null) {
                    if (paint != null) {
                        graphics2D.setPaint(paint);
                        graphics2D.fill(rectangularShape);
                    }
                    if (stroke != null && paint2 != null) {
                        graphics2D.setPaint(paint2);
                        graphics2D.setStroke(stroke);
                        graphics2D.draw(rectangularShape);
                    }
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d3 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d4 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d3, d, d4 - d3, d2);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            bl = bl2;
        }
        if (bl && rectangularShape != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangularShape);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    protected void paintTextRuns(List<TextRun> list, Graphics2D graphics2D) {
        for (TextRun textRun : list) {
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null && textPaintInfo.composite != null) {
                graphics2D.setComposite(textPaintInfo.composite);
            }
            textRun.getLayout().draw(graphics2D);
        }
    }

    @Override
    public Shape getOutline(TextNode textNode) {
        Object object;
        GeneralPath generalPath = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List<TextRun> list = this.getTextRuns(textNode, attributedCharacterIterator);
        for (TextRun object22 : list) {
            object = object22.getLayout();
            GeneralPath generalPath2 = new GeneralPath(object.getOutline());
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            generalPath.setWindingRule(1);
            generalPath.append(generalPath2, false);
        }
        Shape shape = this.getDecorationOutline(list, 1);
        Shape shape2 = this.getDecorationOutline(list, 2);
        object = this.getDecorationOutline(list, 4);
        if (shape != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath(shape);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append(shape, false);
            }
        }
        if (shape2 != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath(shape2);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append(shape2, false);
            }
        }
        if (object != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object, false);
            }
        }
        return generalPath;
    }

    @Override
    public Rectangle2D getBounds2D(TextNode textNode) {
        Shape shape;
        Object object;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List<TextRun> list = this.getTextRuns(textNode, attributedCharacterIterator);
        Rectangle2D rectangle2D = null;
        for (TextRun object22 : list) {
            object = object22.getLayout();
            Rectangle2D rectangle2D2 = object.getBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        Shape shape2 = this.getDecorationStrokeOutline(list, 1);
        if (shape2 != null) {
            if (rectangle2D == null) {
                rectangle2D = shape2.getBounds2D();
            } else {
                rectangle2D.add(shape2.getBounds2D());
            }
        }
        if ((shape = this.getDecorationStrokeOutline(list, 2)) != null) {
            if (rectangle2D == null) {
                rectangle2D = shape.getBounds2D();
            } else {
                rectangle2D.add(shape.getBounds2D());
            }
        }
        if ((object = this.getDecorationStrokeOutline(list, 4)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object.getBounds2D();
            } else {
                rectangle2D.add(object.getBounds2D());
            }
        }
        return rectangle2D;
    }

    protected Shape getDecorationOutline(List<TextRun> list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d = 0.0;
        double d2 = 0.0;
        for (TextRun textRun : list) {
            Rectangle2D rectangle2D;
            Shape shape;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n);
                rectangle2D = shape.getBounds2D();
                d = rectangle2D.getY();
                d2 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangularShape);
                } else {
                    path2D.append(rectangularShape, false);
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d3 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d4 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d3, d, d4 - d3, d2);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangularShape);
            } else {
                path2D.append(rectangularShape, false);
            }
        }
        return path2D;
    }

    protected Shape getDecorationStrokeOutline(List<TextRun> list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d = 0.0;
        double d2 = 0.0;
        for (TextRun textRun : list) {
            Rectangle2D rectangle2D;
            Shape shape;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n);
                rectangle2D = shape.getBounds2D();
                d = rectangle2D.getY();
                d2 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                shape = null;
                if (stroke != null && paint2 != null) {
                    shape = stroke.createStrokedShape(rectangularShape);
                } else if (paint != null) {
                    shape = rectangularShape;
                }
                if (shape != null) {
                    if (path2D == null) {
                        path2D = new GeneralPath(shape);
                    } else {
                        path2D.append(shape, false);
                    }
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d, rectangle2D.getWidth(), d2);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d3 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d4 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d3, d, d4 - d3, d2);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            Object object = null;
            if (stroke != null && paint2 != null) {
                object = stroke.createStrokedShape(rectangularShape);
            } else if (paint != null) {
                object = rectangularShape;
            }
            if (object != null) {
                if (path2D == null) {
                    path2D = new GeneralPath((Shape)object);
                } else {
                    path2D.append((Shape)object, false);
                }
            }
        }
        return path2D;
    }

    @Override
    public Mark getMark(TextNode textNode, int n, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null || n < attributedCharacterIterator.getBeginIndex() || n > attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        TextHit textHit = new TextHit(n, bl);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    protected Mark hitTest(double d, double d2, TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List<TextRun> list = this.getTextRuns(textNode, attributedCharacterIterator);
        if (list != null) {
            for (TextRun textRun : list) {
                TextSpanLayout textSpanLayout = textRun.getLayout();
                TextHit textHit = textSpanLayout.hitTestChar((float)d, (float)d2);
                Rectangle2D rectangle2D = textSpanLayout.getBounds2D();
                if (textHit == null || rectangle2D == null || !rectangle2D.contains(d, d2)) continue;
                return new BasicTextPainter.BasicMark(textNode, textHit);
            }
        }
        return null;
    }

    @Override
    public Mark selectFirst(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getBeginIndex(), false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    public Mark selectLast(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getEndIndex() - 1, false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    public int[] getSelected(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new RuntimeException("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        List<TextRun> list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = -1;
        int n2 = -1;
        TextSpanLayout textSpanLayout = null;
        TextSpanLayout textSpanLayout2 = null;
        for (TextRun textRun : list) {
            TextSpanLayout textSpanLayout3 = textRun.getLayout();
            if (n == -1 && (n = textSpanLayout3.getGlyphIndex(nArray[0])) != -1) {
                textSpanLayout = textSpanLayout3;
            }
            if (n2 == -1 && (n2 = textSpanLayout3.getGlyphIndex(nArray[1])) != -1) {
                textSpanLayout2 = textSpanLayout3;
            }
            if (n == -1 || n2 == -1) continue;
            break;
        }
        if (textSpanLayout == null || textSpanLayout2 == null) {
            return null;
        }
        int n3 = textSpanLayout.getCharacterCount(n, n);
        int n4 = textSpanLayout2.getCharacterCount(n2, n2);
        if (n3 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n3 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n3 - 1);
            }
        }
        if (n4 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n4 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n4 - 1);
            }
        }
        return nArray;
    }

    @Override
    public Shape getHighlightShape(Mark mark, Mark mark2) {
        Object object;
        int n;
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new RuntimeException("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n2 = basicMark2.getHit().getCharIndex();
        if (n2 > (n = basicMark.getHit().getCharIndex())) {
            object = basicMark2;
            basicMark2 = basicMark;
            basicMark = object;
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        object = this.getTextRuns(textNode, attributedCharacterIterator);
        GeneralPath generalPath = new GeneralPath();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            TextRun textRun = (TextRun)iterator.next();
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Shape shape = textSpanLayout.getHighlightShape(n2, n);
            if (shape == null || shape.getBounds().isEmpty()) continue;
            generalPath.append(shape, false);
        }
        return generalPath;
    }

    static {
        extendedAtts.add(FLOW_PARAGRAPH);
        extendedAtts.add(TEXT_COMPOUND_ID);
        extendedAtts.add(GVT_FONT);
        singleton = new StrokingTextPainter();
    }

    public static class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n, int n2, Point2D point2D) {
            this.begin = n;
            this.end = n2;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }

    public static class TextRun {
        protected AttributedCharacterIterator aci;
        protected TextSpanLayout layout;
        protected int anchorType;
        protected boolean firstRunInChunk;
        protected Float length;
        protected Integer lengthAdjust;
        private int level;
        private int reversals;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl;
            this.anchorType = 0;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
            this.length = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
            this.lengthAdjust = (Integer)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
            Integer n = (Integer)attributedCharacterIterator.getAttribute(BIDI_LEVEL);
            this.level = n != null ? n : -1;
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public Float getLength() {
            return this.length;
        }

        public Integer getLengthAdjust() {
            return this.lengthAdjust;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }

        public int getBidiLevel() {
            return this.level;
        }

        public void reverse() {
            ++this.reversals;
        }

        public void maybeReverseGlyphs(boolean bl) {
            if ((this.reversals & 1) == 1) {
                this.layout.maybeReverse(bl);
            }
        }
    }
}

