/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSRectValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class RectValue
extends TypedValue
implements CSSRectValue {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue top = null;
    private PrimitiveValue right = null;
    private PrimitiveValue bottom = null;
    private PrimitiveValue left = null;

    RectValue() {
        super(CSSValue.Type.RECT);
    }

    protected RectValue(RectValue rectValue) {
        super(rectValue);
        this.left = rectValue.left;
        this.top = rectValue.top;
        this.right = rectValue.right;
        this.bottom = rectValue.bottom;
    }

    public void setTop(PrimitiveValue primitiveValue) {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.top = primitiveValue;
    }

    @Override
    public PrimitiveValue getTop() {
        return this.top;
    }

    public void setRight(PrimitiveValue primitiveValue) {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.right = primitiveValue;
    }

    @Override
    public PrimitiveValue getRight() {
        return this.right;
    }

    public void setBottom(PrimitiveValue primitiveValue) {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.bottom = primitiveValue;
    }

    @Override
    public PrimitiveValue getBottom() {
        return this.bottom;
    }

    public void setLeft(PrimitiveValue primitiveValue) {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        this.left = primitiveValue;
    }

    @Override
    public PrimitiveValue getLeft() {
        return this.left;
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        switch (n) {
            case 0: {
                return this.top;
            }
            case 1: {
                return this.right;
            }
            case 2: {
                return this.bottom;
            }
            case 3: {
                return this.left;
            }
        }
        return null;
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        if (styleValue == null) {
            throw new NullPointerException();
        }
        PrimitiveValue primitiveValue = (PrimitiveValue)styleValue;
        switch (n) {
            case 0: {
                this.top = primitiveValue;
                break;
            }
            case 1: {
                this.right = primitiveValue;
                break;
            }
            case 2: {
                this.bottom = primitiveValue;
                break;
            }
            case 3: {
                this.left = primitiveValue;
            }
        }
    }

    @Override
    public int getComponentCount() {
        return 4;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(32);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("rect(").append(this.getTop().getCssText()).append(',').append(this.getRight().getCssText()).append(',').append(this.getBottom().getCssText()).append(',').append(this.getLeft().getCssText()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"rect(");
        this.getTop().writeCssText(simpleWriter);
        simpleWriter.write(',');
        simpleWriter.write(' ');
        this.getRight().writeCssText(simpleWriter);
        simpleWriter.write(',');
        simpleWriter.write(' ');
        this.getBottom().writeCssText(simpleWriter);
        simpleWriter.write(',');
        simpleWriter.write(' ');
        this.getLeft().writeCssText(simpleWriter);
        simpleWriter.write(')');
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.bottom == null ? 0 : this.bottom.hashCode());
        n2 = 31 * n2 + (this.left == null ? 0 : this.left.hashCode());
        n2 = 31 * n2 + (this.right == null ? 0 : this.right.hashCode());
        n2 = 31 * n2 + (this.top == null ? 0 : this.top.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RectValue rectValue = (RectValue)object;
        if (this.bottom == null ? rectValue.bottom != null : !this.bottom.equals(rectValue.bottom)) {
            return false;
        }
        if (this.left == null ? rectValue.left != null : !this.left.equals(rectValue.left)) {
            return false;
        }
        if (this.right == null ? rectValue.right != null : !this.right.equals(rectValue.right)) {
            return false;
        }
        if (this.top == null) {
            return rectValue.top == null;
        }
        return this.top.equals(rectValue.top);
    }

    @Override
    public RectValue clone() {
        return new RectValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            ValueFactory valueFactory = new ValueFactory();
            boolean bl = false;
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            this.checkProxyValue(lexicalUnit2);
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RectValue.this.setTop(primitiveValue);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                bl = true;
            }
            this.checkProxyValue(lexicalUnit2);
            primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RectValue.this.setRight(primitiveValue);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (bl) {
                    throw new DOMException(12, "Bad syntax for rect.");
                }
            } else {
                if (!bl) {
                    throw new DOMException(12, "Bad syntax for rect.");
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            this.checkProxyValue(lexicalUnit2);
            primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RectValue.this.setBottom(primitiveValue);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (bl) {
                    throw new DOMException(12, "Bad syntax for rect.");
                }
            } else {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            this.checkProxyValue(lexicalUnit2);
            primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RectValue.this.setLeft(primitiveValue);
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

