/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.Serializable;

class PositionalConditionImpl
implements PositionalCondition,
Serializable {
    private static final long serialVersionUID = 1L;
    int offset = 1;
    int slope = 0;
    boolean forwardCondition = true;
    boolean oftype = false;
    private final boolean hasArgument;
    boolean hasKeyword = false;
    SelectorList ofList = null;

    PositionalConditionImpl(boolean bl) {
        this.hasArgument = bl;
    }

    @Override
    public Condition.ConditionType getConditionType() {
        return Condition.ConditionType.POSITIONAL;
    }

    @Override
    public boolean isForwardCondition() {
        return this.forwardCondition;
    }

    @Override
    public boolean isOfType() {
        return this.oftype;
    }

    @Override
    public int getFactor() {
        return this.slope;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean hasArgument() {
        return this.hasArgument;
    }

    @Override
    public boolean hasKeyword() {
        return this.hasKeyword;
    }

    @Override
    public SelectorList getOfList() {
        return this.ofList;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.forwardCondition ? 1231 : 1237);
        n2 = 31 * n2 + (this.hasArgument ? 1231 : 1237);
        n2 = 31 * n2 + (this.hasKeyword ? 1231 : 1237);
        n2 = 31 * n2 + (this.ofList == null ? 0 : this.ofList.hashCode());
        n2 = 31 * n2 + this.offset;
        n2 = 31 * n2 + (this.oftype ? 1231 : 1237);
        n2 = 31 * n2 + this.slope;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PositionalConditionImpl positionalConditionImpl = (PositionalConditionImpl)object;
        if (this.forwardCondition != positionalConditionImpl.forwardCondition) {
            return false;
        }
        if (this.hasArgument != positionalConditionImpl.hasArgument) {
            return false;
        }
        if (this.hasKeyword != positionalConditionImpl.hasKeyword) {
            return false;
        }
        if (this.ofList == null ? positionalConditionImpl.ofList != null : !ParseHelper.equalSelectorList(this.ofList, positionalConditionImpl.ofList)) {
            return false;
        }
        if (this.offset != positionalConditionImpl.offset) {
            return false;
        }
        if (this.oftype != positionalConditionImpl.oftype) {
            return false;
        }
        return this.slope == positionalConditionImpl.slope;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(':');
        if (this.oftype) {
            this.ofTypeSerialization(stringBuilder);
        } else {
            this.normalSerialization(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void normalSerialization(StringBuilder stringBuilder) {
        if (this.slope == 0) {
            if (this.offset == 1 && this.ofList == null && !this.hasArgument) {
                if (this.forwardCondition) {
                    stringBuilder.append("first-child");
                } else {
                    stringBuilder.append("last-child");
                }
            } else {
                if (this.forwardCondition) {
                    stringBuilder.append("nth-child(");
                } else {
                    stringBuilder.append("nth-last-child(");
                }
                stringBuilder.append(this.offset);
                if (!this.isUniversalOfList()) {
                    stringBuilder.append(" of ").append(this.ofList.toString());
                }
                stringBuilder.append(')');
            }
        } else {
            if (this.forwardCondition) {
                stringBuilder.append("nth-child(");
            } else {
                stringBuilder.append("nth-last-child(");
            }
            this.appendAnB(stringBuilder);
            if (!this.isUniversalOfList()) {
                stringBuilder.append(" of ").append(this.ofList.toString());
            }
            stringBuilder.append(')');
        }
    }

    private void ofTypeSerialization(StringBuilder stringBuilder) {
        if (this.slope == 0) {
            if (this.offset == 1 && this.ofList == null && !this.hasArgument) {
                if (this.forwardCondition) {
                    stringBuilder.append("first-of-type");
                } else {
                    stringBuilder.append("last-of-type");
                }
            } else {
                if (this.forwardCondition) {
                    stringBuilder.append("nth-of-type(");
                } else {
                    stringBuilder.append("nth-last-of-type(");
                }
                stringBuilder.append(this.offset).append(')');
            }
        } else {
            if (this.forwardCondition) {
                stringBuilder.append("nth-of-type(");
            } else {
                stringBuilder.append("nth-last-of-type(");
            }
            this.appendAnB(stringBuilder);
            stringBuilder.append(')');
        }
    }

    private void appendAnB(StringBuilder stringBuilder) {
        if (this.hasKeyword && this.slope == 2) {
            if (this.offset == 0) {
                stringBuilder.append("even");
            } else {
                stringBuilder.append("odd");
            }
            return;
        }
        if (this.slope == -1) {
            stringBuilder.append('-');
        } else if (this.slope != 1) {
            stringBuilder.append(this.slope);
        }
        stringBuilder.append('n');
        if (this.offset > 0) {
            stringBuilder.append('+');
            stringBuilder.append(this.offset);
        } else if (this.offset != 0) {
            stringBuilder.append(this.offset);
        }
    }

    private boolean isUniversalOfList() {
        if (this.ofList == null) {
            return true;
        }
        for (int i = 0; i < this.ofList.getLength(); ++i) {
            Selector selector = this.ofList.item(i);
            if (selector.getSelectorType() != Selector.SelectorType.UNIVERSAL || ((ElementSelector)selector).getNamespaceURI() != null) continue;
            return true;
        }
        return false;
    }
}

