/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.om.SheetHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;

abstract class BaseCSSRule
extends AbstractCSSRule {
    private static final long serialVersionUID = 1L;
    private AbstractCSSStyleSheet parentSheet = null;
    private AbstractCSSRule parentRule = null;
    private final short ruleType;
    private final byte ruleOrigin;
    private StringList precedingComments = null;
    private StringList trailingComments = null;

    protected BaseCSSRule(AbstractCSSStyleSheet abstractCSSStyleSheet, short s, byte by) {
        this.parentSheet = abstractCSSStyleSheet;
        this.ruleType = s;
        this.ruleOrigin = by;
    }

    protected BaseCSSRule(BaseCSSRule baseCSSRule) {
        this(baseCSSRule.parentSheet, baseCSSRule.ruleType, baseCSSRule.ruleOrigin);
        this.precedingComments = baseCSSRule.precedingComments;
        this.trailingComments = baseCSSRule.trailingComments;
    }

    @Override
    public short getType() {
        return this.ruleType;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentSheet != null ? this.parentSheet : (this.parentRule != null ? this.parentRule.getParentStyleSheet() : null);
    }

    @Override
    void setParentStyleSheet(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        this.parentSheet = abstractCSSStyleSheet;
    }

    protected Parser createSACParser() throws DOMException {
        Parser parser = this.getParentStyleSheet() != null ? this.getParentStyleSheet().getStyleSheetFactory().createSACParser() : new CSSOMParser();
        return parser;
    }

    @Override
    public AbstractCSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public void setParentRule(AbstractCSSRule abstractCSSRule) {
        this.parentRule = abstractCSSRule;
    }

    @Override
    public byte getOrigin() {
        return this.ruleOrigin;
    }

    @Override
    public void enablePrecedingComments() {
        if (this.precedingComments == null) {
            this.precedingComments = new LinkedStringList();
        }
    }

    @Override
    public StringList getPrecedingComments() {
        return this.precedingComments;
    }

    @Override
    void setPrecedingComments(StringList stringList) {
        this.precedingComments = stringList;
    }

    @Override
    public void enableTrailingComments() {
        if (this.trailingComments == null) {
            this.trailingComments = new LinkedStringList();
        }
    }

    @Override
    public StringList getTrailingComments() {
        return this.trailingComments;
    }

    @Override
    void setTrailingComments(StringList stringList) {
        this.trailingComments = stringList;
    }

    void resetComments() {
        this.precedingComments = null;
        this.trailingComments = null;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return false;
    }

    @Override
    public String getMinifiedCssText() {
        return this.getCssText();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
        if (abstractCSSStyleSheet == null) {
            throw new DOMException(11, "This rule must be added to a sheet first");
        }
        BaseCSSStyleSheet baseCSSStyleSheet = (BaseCSSStyleSheet)abstractCSSStyleSheet.getStyleSheetFactory().createRuleStyleSheet(this, null, null);
        SheetHandler sheetHandler = baseCSSStyleSheet.createSheetHandler(this.getOrigin(), (short)2);
        StringReader stringReader = new StringReader(string);
        try {
            this.parseRule((Reader)stringReader, sheetHandler);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        CSSRuleArrayList cSSRuleArrayList = baseCSSStyleSheet.getCssRules();
        int n = cSSRuleArrayList.getLength();
        if (n > 1) {
            throw new DOMException(13, "Attempted to parse more than one rule inside this one");
        }
        if (n == 1) {
            AbstractCSSRule abstractCSSRule = (AbstractCSSRule)cSSRuleArrayList.item(0);
            if (abstractCSSRule.getType() != this.getType()) {
                throw new DOMException(13, "Attempted to parse a rule of type " + abstractCSSRule.getType());
            }
            this.setRule(abstractCSSRule);
            if (baseCSSStyleSheet.hasRuleErrorsOrWarnings()) {
                abstractCSSStyleSheet.getErrorHandler().mergeState(baseCSSStyleSheet.getErrorHandler());
            }
        } else {
            this.clear();
        }
    }

    abstract void clear();

    void parseRule(Reader reader, CSSHandler cSSHandler) throws IOException {
        Parser parser = this.createSACParser();
        AllowWarningsRuleErrorHandler allowWarningsRuleErrorHandler = new AllowWarningsRuleErrorHandler();
        parser.setDocumentHandler(cSSHandler);
        parser.setErrorHandler(allowWarningsRuleErrorHandler);
        this.parseRule(reader, parser);
    }

    void parseRule(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            parser.parseRule(reader);
        }
        catch (CSSNamespaceParseException cSSNamespaceParseException) {
            DOMException dOMException = new DOMException(14, cSSNamespaceParseException.getMessage());
            dOMException.initCause(cSSNamespaceParseException);
            throw dOMException;
        }
        catch (CSSBudgetException cSSBudgetException) {
            DOMException dOMException = new DOMException(9, cSSBudgetException.getMessage());
            dOMException.initCause(cSSBudgetException);
            throw dOMException;
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, "Parse error at [" + cSSParseException.getLineNumber() + ',' + cSSParseException.getColumnNumber() + "]: " + cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(15, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (DOMException dOMException) {
            throw dOMException;
        }
        catch (RuntimeException runtimeException) {
            Object object;
            String string = runtimeException.getMessage();
            AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
            if (abstractCSSStyleSheet != null && (object = abstractCSSStyleSheet.getHref()) != null) {
                string = "Error in stylesheet at " + (String)object + ": " + string;
            }
            object = new DOMException(11, string);
            ((Throwable)object).initCause(runtimeException);
            throw object;
        }
    }

    abstract void setRule(AbstractCSSRule var1);

    protected StyleFormattingContext getStyleFormattingContext() {
        AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
        StyleFormattingContext styleFormattingContext = abstractCSSStyleSheet != null ? abstractCSSStyleSheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext() : new DefaultStyleFormattingContext();
        return styleFormattingContext;
    }

    protected URL getURL(String string) throws MalformedURLException {
        URL uRL;
        if (string.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        String string2 = this.getParentStyleSheet().getHref();
        if (string2 != null) {
            URL uRL2;
            try {
                uRL2 = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return new URL(string);
            }
            uRL = new URL(uRL2, string);
        } else {
            uRL = new URL(string);
        }
        return uRL;
    }

    class AllowWarningsRuleErrorHandler
    implements CSSErrorHandler {
        AllowWarningsRuleErrorHandler() {
        }

        @Override
        public void warning(CSSParseException cSSParseException) throws CSSParseException {
            AbstractCSSStyleSheet abstractCSSStyleSheet = BaseCSSRule.this.getParentStyleSheet();
            if (abstractCSSStyleSheet != null) {
                abstractCSSStyleSheet.getErrorHandler().ruleParseWarning(BaseCSSRule.this, cSSParseException);
            }
        }

        @Override
        public void error(CSSParseException cSSParseException) throws CSSParseException {
            throw cSSParseException;
        }
    }
}

