/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.event;

import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.event.AWTEventDispatcher;
import io.sf.carte.echosvg.gvt.event.GraphicsNodeEvent;
import java.awt.event.InputEvent;

public abstract class GraphicsNodeInputEvent
extends GraphicsNodeEvent {
    private static final long serialVersionUID = 1L;
    public static final int SHIFT_MASK = 64;
    public static final int CTRL_MASK = 128;
    public static final int META_MASK = 256;
    public static final int ALT_MASK = 512;
    public static final int ALT_GRAPH_MASK = 8192;
    public static final int BUTTON1_MASK = 1024;
    public static final int BUTTON2_MASK = 2048;
    public static final int BUTTON3_MASK = 4096;
    public static final int CAPS_LOCK_MASK = 1;
    public static final int NUM_LOCK_MASK = 2;
    public static final int SCROLL_LOCK_MASK = 4;
    public static final int KANA_LOCK_MASK = 8;
    long when;
    int modifiers;
    int lockState;

    protected GraphicsNodeInputEvent(GraphicsNode graphicsNode, int n, long l, int n2, int n3) {
        super(graphicsNode, n);
        this.when = l;
        this.modifiers = n2;
        this.lockState = n3;
    }

    protected GraphicsNodeInputEvent(GraphicsNode graphicsNode, InputEvent inputEvent, int n) {
        super(graphicsNode, inputEvent.getID());
        this.when = inputEvent.getWhen();
        this.modifiers = inputEvent.getModifiersEx();
        this.lockState = n;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isMetaDown() {
        return AWTEventDispatcher.isMetaDown(this.modifiers);
    }

    public boolean isAltDown() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x2000) != 0;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getLockState() {
        return this.lockState;
    }
}

