/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.math.linear3;

public class Matrices {
    public static void inverse3(double[][] dArray, double[][] dArray2) {
        double d = Matrices.determinant3(dArray);
        if (d == 0.0) {
            throw new IllegalArgumentException("Null determinant.");
        }
        dArray2[0][0] = dArray[2][2] * dArray[1][1] - dArray[2][1] * dArray[1][2];
        dArray2[0][1] = dArray[2][1] * dArray[0][2] - dArray[2][2] * dArray[0][1];
        dArray2[0][2] = dArray[1][2] * dArray[0][1] - dArray[1][1] * dArray[0][2];
        dArray2[1][0] = dArray[2][0] * dArray[1][2] - dArray[2][2] * dArray[1][0];
        dArray2[1][1] = dArray[2][2] * dArray[0][0] - dArray[2][0] * dArray[0][2];
        dArray2[1][2] = dArray[1][0] * dArray[0][2] - dArray[1][2] * dArray[0][0];
        dArray2[2][0] = dArray[2][1] * dArray[1][0] - dArray[2][0] * dArray[1][1];
        dArray2[2][1] = dArray[2][0] * dArray[0][1] - dArray[2][1] * dArray[0][0];
        dArray2[2][2] = dArray[1][1] * dArray[0][0] - dArray[1][0] * dArray[0][1];
        double[] dArray3 = dArray2[0];
        dArray3[0] = dArray3[0] / d;
        double[] dArray4 = dArray2[0];
        dArray4[1] = dArray4[1] / d;
        double[] dArray5 = dArray2[0];
        dArray5[2] = dArray5[2] / d;
        double[] dArray6 = dArray2[1];
        dArray6[0] = dArray6[0] / d;
        double[] dArray7 = dArray2[1];
        dArray7[1] = dArray7[1] / d;
        double[] dArray8 = dArray2[1];
        dArray8[2] = dArray8[2] / d;
        double[] dArray9 = dArray2[2];
        dArray9[0] = dArray9[0] / d;
        double[] dArray10 = dArray2[2];
        dArray10[1] = dArray10[1] / d;
        double[] dArray11 = dArray2[2];
        dArray11[2] = dArray11[2] / d;
    }

    public static double determinant3(double[][] dArray) {
        return dArray[0][0] * (dArray[1][1] * dArray[2][2] - dArray[2][1] * dArray[1][2]) - dArray[1][0] * (dArray[0][1] * dArray[2][2] - dArray[2][1] * dArray[0][2]) + dArray[2][0] * (dArray[0][1] * dArray[1][2] - dArray[1][1] * dArray[0][2]);
    }

    public static void multiplyByVector3(double[][] dArray, double[] dArray2, double[] dArray3) {
        Matrices.multiplyByVector3(dArray, dArray2[0], dArray2[1], dArray2[2], dArray3);
    }

    public static void multiplyByVector3(double[][] dArray, double d, double d2, double d3, double[] dArray2) {
        dArray2[0] = dArray[0][0] * d + dArray[0][1] * d2 + dArray[0][2] * d3;
        dArray2[1] = dArray[1][0] * d + dArray[1][1] * d2 + dArray[1][2] * d3;
        dArray2[2] = dArray[2][0] * d + dArray[2][1] * d2 + dArray[2][2] * d3;
    }

    public static void multiplyByMatrix3(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        dArray3[0][0] = dArray[0][0] * dArray2[0][0] + dArray[0][1] * dArray2[1][0] + dArray[0][2] * dArray2[2][0];
        dArray3[0][1] = dArray[0][0] * dArray2[0][1] + dArray[0][1] * dArray2[1][1] + dArray[0][2] * dArray2[2][1];
        dArray3[0][2] = dArray[0][0] * dArray2[0][2] + dArray[0][1] * dArray2[1][2] + dArray[0][2] * dArray2[2][2];
        dArray3[1][0] = dArray[1][0] * dArray2[0][0] + dArray[1][1] * dArray2[1][0] + dArray[1][2] * dArray2[2][0];
        dArray3[1][1] = dArray[1][0] * dArray2[0][1] + dArray[1][1] * dArray2[1][1] + dArray[1][2] * dArray2[2][1];
        dArray3[1][2] = dArray[1][0] * dArray2[0][2] + dArray[1][1] * dArray2[1][2] + dArray[1][2] * dArray2[2][2];
        dArray3[2][0] = dArray[2][0] * dArray2[0][0] + dArray[2][1] * dArray2[1][0] + dArray[2][2] * dArray2[2][0];
        dArray3[2][1] = dArray[2][0] * dArray2[0][1] + dArray[2][1] * dArray2[1][1] + dArray[2][2] * dArray2[2][1];
        dArray3[2][2] = dArray[2][0] * dArray2[0][2] + dArray[2][1] * dArray2[1][2] + dArray[2][2] * dArray2[2][2];
    }

    public static void transpose3(double[][] dArray) {
        double d = dArray[0][1];
        dArray[0][1] = dArray[1][0];
        dArray[1][0] = d;
        d = dArray[0][2];
        dArray[0][2] = dArray[2][0];
        dArray[2][0] = d;
        d = dArray[1][2];
        dArray[1][2] = dArray[2][1];
        dArray[2][1] = d;
    }

    public static double[][] rotX(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[][] dArray = new double[3][3];
        dArray[0][0] = 1.0;
        dArray[1][1] = d2;
        dArray[1][2] = -d3;
        dArray[2][1] = d3;
        dArray[2][2] = d2;
        return dArray;
    }

    public static double[][] rotY(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[][] dArray = new double[3][3];
        dArray[0][0] = d2;
        dArray[0][2] = d3;
        dArray[1][1] = 1.0;
        dArray[2][0] = -d3;
        dArray[2][2] = d2;
        return dArray;
    }

    public static double[][] rotZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double[][] dArray = new double[3][3];
        dArray[0][0] = d2;
        dArray[0][1] = -d3;
        dArray[1][0] = d3;
        dArray[1][1] = d2;
        dArray[2][2] = 1.0;
        return dArray;
    }

    public static double[][] rotation(double[] dArray, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0 - d3;
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = d3 + dArray[0] * dArray[0] * d4;
        dArray2[0][1] = dArray[0] * dArray[1] * d4 - dArray[2] * d2;
        dArray2[0][2] = dArray[0] * dArray[2] * d4 + dArray[1] * d2;
        dArray2[1][0] = dArray[0] * dArray[1] * d4 + dArray[2] * d2;
        dArray2[1][1] = d3 + dArray[1] * dArray[1] * d4;
        dArray2[1][2] = dArray[1] * dArray[2] * d4 - dArray[0] * d2;
        dArray2[2][0] = dArray[0] * dArray[2] * d4 - dArray[1] * d2;
        dArray2[2][1] = dArray[1] * dArray[2] * d4 + dArray[0] * d2;
        dArray2[2][2] = d3 + dArray[2] * dArray[2] * d4;
        return dArray2;
    }
}

