/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public abstract class GlyphOrientationManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 5;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case DIMENSION: {
                switch (lexicalUnit.getCssUnit()) {
                    case 80: {
                        return new FloatValue(80, lexicalUnit.getFloatValue());
                    }
                    case 81: {
                        return new FloatValue(81, lexicalUnit.getFloatValue());
                    }
                    case 82: {
                        return new FloatValue(82, lexicalUnit.getFloatValue());
                    }
                    case 83: {
                        return new FloatValue(80, lexicalUnit.getFloatValue() * 360.0f);
                    }
                }
                break;
            }
            case INTEGER: {
                int n = lexicalUnit.getIntegerValue();
                return new FloatValue(80, n);
            }
            case REAL: {
                float f = lexicalUnit.getFloatValue();
                return new FloatValue(80, f);
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lexicalUnit);
            }
            case CALC: {
                Value value = this.createCalc(lexicalUnit);
                if (value.getPrimitiveType() != CSSValue.Type.EXPRESSION) {
                    return value;
                }
                FloatValue floatValue = ((CalcValue)value).evaluate(null, null, cSSEngine, -1, null, (short)80);
                if (floatValue.getUnitType() == 0) {
                    floatValue = new FloatValue(80, floatValue.getFloatValue());
                }
                return floatValue;
            }
            case MATH_FUNCTION: {
                Value value;
                try {
                    value = this.createMathFunction(lexicalUnit, "<angle>");
                }
                catch (Exception exception) {
                    DOMException dOMException = this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    dOMException.initCause(exception);
                    throw dOMException;
                }
                return ((NumericDelegateValue)value).evaluate(null, null, cSSEngine, -1, null, (short)80);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        switch (s) {
            case 80: 
            case 81: 
            case 82: {
                return new FloatValue(s, f);
            }
        }
        float f2 = NumberValue.floatValueConversion((float)f, (short)s, (short)80);
        return new FloatValue(80, f2);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        return value;
    }
}

