/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueFactory;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.PendingValue;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.css.engine.value.css.FontSizeManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class FontShorthandManager
extends AbstractValueFactory
implements ShorthandManager {
    static LexicalUnit NORMAL_LU;
    static LexicalUnit BOLD_LU;
    static LexicalUnit MEDIUM_LU;
    static LexicalUnit SZ_10PT_LU;
    static LexicalUnit SZ_8PT_LU;
    static LexicalUnit FONT_FAMILY_LU;
    protected static final Set<String> values;

    @Override
    public String getPropertyName() {
        return "font";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    public void handleSystemFont(CSSEngine cSSEngine, ShorthandManager.PropertyHandler propertyHandler, String string, boolean bl) {
        LexicalUnit lexicalUnit = NORMAL_LU;
        LexicalUnit lexicalUnit2 = NORMAL_LU;
        LexicalUnit lexicalUnit3 = NORMAL_LU;
        LexicalUnit lexicalUnit4 = NORMAL_LU;
        LexicalUnit lexicalUnit5 = FONT_FAMILY_LU;
        LexicalUnit lexicalUnit6 = string.equals("small-caption") ? SZ_8PT_LU : SZ_10PT_LU;
        propertyHandler.property("font-family", lexicalUnit5, bl);
        propertyHandler.property("font-style", lexicalUnit, bl);
        propertyHandler.property("font-variant", lexicalUnit2, bl);
        propertyHandler.property("font-weight", lexicalUnit3, bl);
        propertyHandler.property("font-size", lexicalUnit6, bl);
        propertyHandler.property("line-height", lexicalUnit4, bl);
    }

    @Override
    public void setValues(CSSEngine cSSEngine, ShorthandManager.PropertyHandler propertyHandler, LexicalUnit lexicalUnit, boolean bl) {
        Object object;
        String string;
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                string = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT);
                if (!values.contains(string)) break;
                this.handleSystemFont(cSSEngine, propertyHandler, string, bl);
                return;
            }
            case INHERIT: 
            case UNSET: 
            case REVERT: {
                return;
            }
            case VAR: 
            case ATTR: {
                this.setPendingLonghands(cSSEngine, propertyHandler, lexicalUnit, bl);
                return;
            }
        }
        string = null;
        LexicalUnit lexicalUnit2 = null;
        LexicalUnit lexicalUnit3 = null;
        LexicalUnit lexicalUnit4 = null;
        LexicalUnit lexicalUnit5 = null;
        LexicalUnit lexicalUnit6 = null;
        ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
        int n = cSSEngine.getPropertyIndex("font-style");
        int n2 = cSSEngine.getPropertyIndex("font-variant");
        int n3 = cSSEngine.getPropertyIndex("font-weight");
        int n4 = cSSEngine.getFontSizeIndex();
        IdentifierManager identifierManager = (IdentifierManager)valueManagerArray[n];
        IdentifierManager identifierManager2 = (IdentifierManager)valueManagerArray[n2];
        IdentifierManager identifierManager3 = (IdentifierManager)valueManagerArray[n3];
        FontSizeManager fontSizeManager = (FontSizeManager)valueManagerArray[n4];
        StringMap stringMap = identifierManager.getIdentifiers();
        StringMap stringMap2 = identifierManager2.getIdentifiers();
        StringMap stringMap3 = identifierManager3.getIdentifiers();
        StringMap stringMap4 = fontSizeManager.getIdentifiers();
        boolean bl2 = false;
        LexicalUnit lexicalUnit7 = lexicalUnit;
        LexicalUnit lexicalUnit8 = null;
        while (!bl2 && lexicalUnit7 != null) {
            switch (lexicalUnit7.getLexicalUnitType()) {
                case IDENT: {
                    object = lexicalUnit7.getStringValue().toLowerCase(Locale.ROOT).intern();
                    if (string == null && stringMap.get((String)object) != null) {
                        string = lexicalUnit7;
                        if (lexicalUnit8 == null) break;
                        if (lexicalUnit3 == null) {
                            lexicalUnit3 = lexicalUnit8;
                            lexicalUnit8 = null;
                            break;
                        }
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit8.getLexicalUnitType());
                    }
                    if (lexicalUnit2 == null && stringMap2.get((String)object) != null) {
                        lexicalUnit2 = lexicalUnit7;
                        if (lexicalUnit8 == null) break;
                        if (lexicalUnit3 == null) {
                            lexicalUnit3 = lexicalUnit8;
                            lexicalUnit8 = null;
                            break;
                        }
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit8.getLexicalUnitType());
                    }
                    if (lexicalUnit8 == null && lexicalUnit3 == null && stringMap3.get((String)object) != null) {
                        lexicalUnit3 = lexicalUnit7;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case INTEGER: {
                    if (lexicalUnit8 == null && lexicalUnit3 == null) {
                        lexicalUnit8 = lexicalUnit7;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case VAR: 
                case ATTR: {
                    this.setPendingLonghands(cSSEngine, propertyHandler, lexicalUnit, bl);
                    return;
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) continue;
            lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
        }
        if (lexicalUnit7 == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        switch (lexicalUnit7.getLexicalUnitType()) {
            case IDENT: {
                object = lexicalUnit7.getStringValue().toLowerCase(Locale.ROOT).intern();
                if (stringMap4.get((String)object) == null) break;
                lexicalUnit4 = lexicalUnit7;
                lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
                break;
            }
            case DIMENSION: {
                if (!CSSUnit.isLengthUnitType((short)lexicalUnit7.getCssUnit())) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit7.getLexicalUnitType());
                }
            }
            case INTEGER: 
            case REAL: 
            case PERCENTAGE: {
                lexicalUnit4 = lexicalUnit7;
                lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
                break;
            }
            case VAR: 
            case ATTR: {
                this.setPendingLonghands(cSSEngine, propertyHandler, lexicalUnit, bl);
                return;
            }
            case CALC: {
                try {
                    object = this.createFontSizeCalc(lexicalUnit7);
                }
                catch (CSSProxyValueException cSSProxyValueException) {
                    this.setPendingLonghands(cSSEngine, propertyHandler, lexicalUnit, bl);
                    return;
                }
                if (object.getPrimitiveType() != CSSValue.Type.EXPRESSION || object.matches(new SyntaxParser().parseSyntax("<length-percentage>")) != CSSValueSyntax.Match.TRUE) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit7.getLexicalUnitType());
                }
                lexicalUnit4 = lexicalUnit7;
                lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
            }
        }
        if (lexicalUnit4 == null) {
            if (lexicalUnit8 != null) {
                lexicalUnit4 = lexicalUnit8;
                lexicalUnit8 = null;
            } else {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit7.getLexicalUnitType());
            }
        }
        if (lexicalUnit8 != null) {
            if (lexicalUnit3 == null) {
                lexicalUnit3 = lexicalUnit8;
            } else {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit8.getLexicalUnitType());
            }
        }
        if (lexicalUnit7 == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        switch (lexicalUnit7.getLexicalUnitType()) {
            case OPERATOR_SLASH: {
                lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
                if (lexicalUnit7 == null) {
                    throw this.createMalformedLexicalUnitDOMException();
                }
                lexicalUnit5 = lexicalUnit7;
                lexicalUnit7 = lexicalUnit7.getNextLexicalUnit();
                break;
            }
            case VAR: 
            case ATTR: {
                this.setPendingLonghands(cSSEngine, propertyHandler, lexicalUnit, bl);
                return;
            }
        }
        if (lexicalUnit7 == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        lexicalUnit6 = lexicalUnit7;
        if (string == null) {
            string = NORMAL_LU;
        }
        if (lexicalUnit2 == null) {
            lexicalUnit2 = NORMAL_LU;
        }
        if (lexicalUnit3 == null) {
            lexicalUnit3 = NORMAL_LU;
        }
        if (lexicalUnit5 == null) {
            lexicalUnit5 = NORMAL_LU;
        }
        try {
            propertyHandler.property("font-family", lexicalUnit6, bl);
            propertyHandler.property("font-style", (LexicalUnit)string, bl);
            propertyHandler.property("font-variant", lexicalUnit2, bl);
            propertyHandler.property("font-weight", lexicalUnit3, bl);
            propertyHandler.property("font-size", lexicalUnit4, bl);
            propertyHandler.property("line-height", lexicalUnit5, bl);
        }
        catch (CSSProxyValueException cSSProxyValueException) {
            this.setPendingLonghands(cSSEngine, propertyHandler, lexicalUnit, bl);
        }
    }

    private Value createFontSizeCalc(LexicalUnit lexicalUnit) throws DOMException {
        ValueFactory valueFactory = new ValueFactory();
        StyleValue styleValue = valueFactory.createCSSValue(lexicalUnit.shallowClone());
        CSSValue.Type type = styleValue.getPrimitiveType();
        if (type != CSSValue.Type.EXPRESSION) {
            if (type == CSSValue.Type.LEXICAL) {
                throw new CSSProxyValueException();
            }
            this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        CalcValue calcValue = new CalcValue((CSSExpressionValue)styleValue){
            private static final long serialVersionUID = 1L;

            @Override
            protected FloatValue absoluteValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, FloatValue floatValue) {
                return (FloatValue)new FontSizeManager().computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, floatValue);
            }
        };
        return calcValue;
    }

    private void setPendingLonghands(CSSEngine cSSEngine, ShorthandManager.PropertyHandler propertyHandler, LexicalUnit lexicalUnit, boolean bl) {
        PendingValue pendingValue = new PendingValue(this.getPropertyName(), lexicalUnit);
        propertyHandler.pendingValue("font-family", pendingValue, bl);
        propertyHandler.pendingValue("font-style", pendingValue, bl);
        propertyHandler.pendingValue("font-variant", pendingValue, bl);
        propertyHandler.pendingValue("font-weight", pendingValue, bl);
        propertyHandler.pendingValue("font-size", pendingValue, bl);
        propertyHandler.pendingValue("line-height", pendingValue, bl);
    }

    static {
        CSSParser cSSParser = new CSSParser();
        try {
            NORMAL_LU = cSSParser.parsePropertyValue((Reader)new StringReader("normal"));
            BOLD_LU = cSSParser.parsePropertyValue((Reader)new StringReader("bold"));
            MEDIUM_LU = cSSParser.parsePropertyValue((Reader)new StringReader("medium"));
            SZ_10PT_LU = cSSParser.parsePropertyValue((Reader)new StringReader("10pt"));
            SZ_8PT_LU = cSSParser.parsePropertyValue((Reader)new StringReader("8pt"));
            FONT_FAMILY_LU = cSSParser.parsePropertyValue((Reader)new StringReader("\"Dialog\",\"Helvetica\",sans-serif"));
        }
        catch (CSSParseException | IOException throwable) {
            // empty catch block
        }
        values = new HashSet<String>();
        values.add("caption");
        values.add("icon");
        values.add("menu");
        values.add("message-box");
        values.add("small-caption");
        values.add("status-bar");
    }
}

