/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;

public class CatchClause
extends AstNode {
    private Name varName;
    private AstNode catchCondition;
    private Scope body;
    private int ifPosition = -1;
    private int lp = -1;
    private int rp = -1;

    public CatchClause() {
        this.type = 128;
    }

    public CatchClause(int n) {
        super(n);
        this.type = 128;
    }

    public CatchClause(int n, int n2) {
        super(n, n2);
        this.type = 128;
    }

    public Name getVarName() {
        return this.varName;
    }

    public void setVarName(Name name) {
        this.varName = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    public AstNode getCatchCondition() {
        return this.catchCondition;
    }

    public void setCatchCondition(AstNode astNode) {
        this.catchCondition = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public Scope getBody() {
        return this.body;
    }

    public void setBody(Scope scope) {
        this.assertNotNull(scope);
        this.body = scope;
        scope.setParent(this);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    public int getIfPosition() {
        return this.ifPosition;
    }

    public void setIfPosition(int n) {
        this.ifPosition = n;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("catch (");
        stringBuilder.append(this.varName.toSource(0));
        if (this.catchCondition != null) {
            stringBuilder.append(" if ");
            stringBuilder.append(this.catchCondition.toSource(0));
        }
        stringBuilder.append(") ");
        stringBuilder.append(this.body.toSource(0));
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.varName.visit(nodeVisitor);
            if (this.catchCondition != null) {
                this.catchCondition.visit(nodeVisitor);
            }
            this.body.visit(nodeVisitor);
        }
    }
}

