/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mozilla.javascript.AbstractEcmaObjectOperations;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptableObject
implements Map {
    private static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = "Object";
    private static final int ConstructorId_getPrototypeOf = -1;
    private static final int ConstructorId_keys = -2;
    private static final int ConstructorId_getOwnPropertyNames = -3;
    private static final int ConstructorId_getOwnPropertyDescriptor = -4;
    private static final int ConstructorId_getOwnPropertyDescriptors = -5;
    private static final int ConstructorId_defineProperty = -6;
    private static final int ConstructorId_isExtensible = -7;
    private static final int ConstructorId_preventExtensions = -8;
    private static final int ConstructorId_defineProperties = -9;
    private static final int ConstructorId_create = -10;
    private static final int ConstructorId_isSealed = -11;
    private static final int ConstructorId_isFrozen = -12;
    private static final int ConstructorId_seal = -13;
    private static final int ConstructorId_freeze = -14;
    private static final int ConstructorId_getOwnPropertySymbols = -15;
    private static final int ConstructorId_assign = -16;
    private static final int ConstructorId_is = -17;
    private static final int ConstructorId_setPrototypeOf = -18;
    private static final int ConstructorId_entries = -19;
    private static final int ConstructorId_fromEntries = -20;
    private static final int ConstructorId_values = -21;
    private static final int ConstructorId_hasOwn = -22;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int Id___defineGetter__ = 9;
    private static final int Id___defineSetter__ = 10;
    private static final int Id___lookupGetter__ = 11;
    private static final int Id___lookupSetter__ = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Scriptable scriptable, boolean bl) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.exportAsJSClass(12, scriptable, bl);
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -1, "getPrototypeOf", 1);
        if (Context.getCurrentContext().version >= 200) {
            this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -18, "setPrototypeOf", 2);
            this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -19, "entries", 1);
            this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -20, "fromEntries", 1);
            this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -21, "values", 1);
            this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -22, "hasOwn", 1);
        }
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -2, "keys", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -3, "getOwnPropertyNames", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -15, "getOwnPropertySymbols", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -4, "getOwnPropertyDescriptor", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -5, "getOwnPropertyDescriptors", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -6, "defineProperty", 3);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -7, "isExtensible", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -8, "preventExtensions", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -9, "defineProperties", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -10, "create", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -11, "isSealed", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -12, "isFrozen", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -13, "seal", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -14, "freeze", 1);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -16, "assign", 2);
        this.addIdFunctionProperty(idFunctionObject, OBJECT_TAG, -17, "is", 2);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string = "hasOwnProperty";
                break;
            }
            case 6: {
                n2 = 1;
                string = "propertyIsEnumerable";
                break;
            }
            case 7: {
                n2 = 1;
                string = "isPrototypeOf";
                break;
            }
            case 8: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 9: {
                n2 = 2;
                string = "__defineGetter__";
                break;
            }
            case 10: {
                n2 = 2;
                string = "__defineSetter__";
                break;
            }
            case 11: {
                n2 = 1;
                string = "__lookupGetter__";
                break;
            }
            case 12: {
                n2 = 1;
                string = "__lookupSetter__";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(OBJECT_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(OBJECT_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 != null) {
                    return idFunctionObject.construct(context, scriptable, objectArray);
                }
                if (objectArray.length == 0 || objectArray[0] == null || Undefined.isUndefined(objectArray[0])) {
                    return context.newObject(scriptable);
                }
                return ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            }
            case 3: {
                if (scriptable2 == null) {
                    throw ScriptRuntime.notFunctionError(null);
                }
                Object object3 = ScriptableObject.getProperty(scriptable2, "toString");
                if (!(object3 instanceof Callable)) {
                    throw ScriptRuntime.notFunctionError(object3);
                }
                Callable callable = (Callable)object3;
                return callable.call(context, scriptable, scriptable2, ScriptRuntime.emptyArgs);
            }
            case 2: {
                if (context.hasFeature(4)) {
                    String string = ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
                    int n2 = string.length();
                    if (n2 != 0 && string.charAt(0) == '(' && string.charAt(n2 - 1) == ')') {
                        string = string.substring(1, n2 - 1);
                    }
                    return string;
                }
                return ScriptRuntime.defaultObjectToString(scriptable2);
            }
            case 4: {
                if (context.getLanguageVersion() >= 180 && (scriptable2 == null || Undefined.isUndefined(scriptable2))) {
                    throw ScriptRuntime.typeErrorById("msg." + (scriptable2 == null ? "null" : "undef") + ".to.object", new Object[0]);
                }
                return scriptable2;
            }
            case 5: {
                if (context.getLanguageVersion() >= 180 && (scriptable2 == null || Undefined.isUndefined(scriptable2))) {
                    throw ScriptRuntime.typeErrorById("msg." + (scriptable2 == null ? "null" : "undef") + ".to.object", new Object[0]);
                }
                Object object4 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                return AbstractEcmaObjectOperations.hasOwnProperty(context, scriptable2, object4);
            }
            case 6: {
                boolean bl;
                Object object5;
                if (context.getLanguageVersion() >= 180 && (scriptable2 == null || Undefined.isUndefined(scriptable2))) {
                    throw ScriptRuntime.typeErrorById("msg." + (scriptable2 == null ? "null" : "undef") + ".to.object", new Object[0]);
                }
                Object object6 = object5 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (object5 instanceof Symbol) {
                    bl = ((SymbolScriptable)((Object)scriptable2)).has((Symbol)object5, scriptable2);
                    bl = bl && this.isEnumerable((Symbol)object5, (Object)scriptable2);
                } else {
                    ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object5);
                    try {
                        bl = stringIdOrIndex.stringId == null ? (bl = scriptable2.has(stringIdOrIndex.index, scriptable2)) && this.isEnumerable(stringIdOrIndex.index, (Object)scriptable2) : (bl = scriptable2.has(stringIdOrIndex.stringId, scriptable2)) && this.isEnumerable(stringIdOrIndex.stringId, (Object)scriptable2);
                    }
                    catch (EvaluatorException evaluatorException) {
                        Object[] objectArray2 = new Object[1];
                        Object object7 = objectArray2[0] = stringIdOrIndex.stringId == null ? Integer.toString(stringIdOrIndex.index) : stringIdOrIndex.stringId;
                        if (evaluatorException.getMessage().startsWith(ScriptRuntime.getMessageById("msg.prop.not.found", objectArray2))) {
                            bl = false;
                        }
                        throw evaluatorException;
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 7: {
                if (context.getLanguageVersion() >= 180 && (scriptable2 == null || Undefined.isUndefined(scriptable2))) {
                    throw ScriptRuntime.typeErrorById("msg." + (scriptable2 == null ? "null" : "undef") + ".to.object", new Object[0]);
                }
                boolean bl = false;
                if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
                    Scriptable scriptable3 = (Scriptable)objectArray[0];
                    do {
                        if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
                        bl = true;
                        break;
                    } while (scriptable3 != null);
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 8: {
                return ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
            }
            case 9: 
            case 10: {
                if (objectArray.length < 2 || !(objectArray[1] instanceof Callable)) {
                    Object object8 = objectArray.length >= 2 ? objectArray[1] : Undefined.instance;
                    throw ScriptRuntime.notFunctionError(object8);
                }
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeErrorById("msg.extend.scriptable", scriptable2 == null ? "null" : scriptable2.getClass().getName(), String.valueOf(objectArray[0]));
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(objectArray[0]);
                int n3 = stringIdOrIndex.stringId != null ? 0 : stringIdOrIndex.index;
                Callable callable = (Callable)objectArray[1];
                boolean bl = n == 10;
                scriptableObject.setGetterOrSetter(stringIdOrIndex.stringId, n3, callable, bl);
                if (scriptableObject instanceof NativeArray) {
                    ((NativeArray)scriptableObject).setDenseOnly(false);
                }
                return Undefined.instance;
            }
            case 11: 
            case 12: {
                Scriptable scriptable4;
                Object object9;
                boolean bl;
                if (objectArray.length < 1 || !(scriptable2 instanceof ScriptableObject)) {
                    return Undefined.instance;
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(objectArray[0]);
                int n4 = stringIdOrIndex.stringId != null ? 0 : stringIdOrIndex.index;
                boolean bl2 = bl = n == 12;
                while ((object9 = scriptableObject.getGetterOrSetter(stringIdOrIndex.stringId, n4, this, bl)) == null && (scriptable4 = scriptableObject.getPrototype()) != null && scriptable4 instanceof ScriptableObject) {
                    scriptableObject = (ScriptableObject)scriptable4;
                }
                if (object9 != null) {
                    return object9;
                }
                return Undefined.instance;
            }
            case -1: {
                Object object10 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable5 = NativeObject.getCompatibleObject(context, scriptable, object10);
                return scriptable5.getPrototype();
            }
            case -18: {
                Scriptable scriptable6;
                if (objectArray.length < 2) {
                    throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Object.setPrototypeOf", "2", Integer.toString(objectArray.length));
                }
                Scriptable scriptable7 = scriptable6 = objectArray[1] == null ? null : NativeObject.ensureScriptable(objectArray[1]);
                if (scriptable6 instanceof Symbol) {
                    throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(scriptable6));
                }
                Object object11 = objectArray[0];
                if (context.getLanguageVersion() >= 200) {
                    ScriptRuntimeES6.requireObjectCoercible(context, object11, idFunctionObject);
                }
                if (!(object11 instanceof ScriptableObject)) {
                    return object11;
                }
                ScriptableObject scriptableObject = (ScriptableObject)object11;
                if (!scriptableObject.isExtensible()) {
                    throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
                }
                for (Scriptable scriptable8 = scriptable6; scriptable8 != null; scriptable8 = scriptable8.getPrototype()) {
                    if (scriptable8 != scriptableObject) continue;
                    throw ScriptRuntime.typeErrorById("msg.object.cyclic.prototype", scriptableObject.getClass().getSimpleName());
                }
                scriptableObject.setPrototype(scriptable6);
                return scriptableObject;
            }
            case -2: {
                Object object12 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable9 = NativeObject.getCompatibleObject(context, scriptable, object12);
                Object[] objectArray3 = scriptable9.getIds();
                for (int i = 0; i < objectArray3.length; ++i) {
                    objectArray3[i] = ScriptRuntime.toString(objectArray3[i]);
                }
                return context.newArray(scriptable, objectArray3);
            }
            case -19: {
                Object object13 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable10 = NativeObject.getCompatibleObject(context, scriptable, object13);
                Object[] objectArray4 = scriptable10.getIds();
                int n5 = 0;
                for (int i = 0; i < objectArray4.length; ++i) {
                    Object[] objectArray5;
                    if (objectArray4[i] instanceof Integer) {
                        int n6 = (Integer)objectArray4[i];
                        if (!scriptable10.has(n6, scriptable10) || !this.isEnumerable(n6, (Object)scriptable10)) continue;
                        objectArray5 = ScriptRuntime.toString(objectArray4[i]);
                        Object[] objectArray6 = new Object[]{objectArray5, scriptable10.get(n6, scriptable10)};
                        objectArray4[n5++] = context.newArray(scriptable, objectArray6);
                        continue;
                    }
                    String string = ScriptRuntime.toString(objectArray4[i]);
                    if (!scriptable10.has(string, scriptable10) || !this.isEnumerable(string, (Object)scriptable10)) continue;
                    objectArray5 = new Object[]{string, scriptable10.get(string, scriptable10)};
                    objectArray4[n5++] = context.newArray(scriptable, objectArray5);
                }
                if (n5 != objectArray4.length) {
                    objectArray4 = Arrays.copyOf(objectArray4, n5);
                }
                return context.newArray(scriptable, objectArray4);
            }
            case -20: {
                Object object14 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                object14 = NativeObject.getCompatibleObject(context, scriptable, object14);
                Scriptable scriptable11 = context.newObject(scriptable);
                ScriptRuntime.loadFromIterable(context, scriptable, object14, (object, object2) -> {
                    if (object instanceof Integer) {
                        scriptable11.put((Integer)object, scriptable11, object2);
                    } else if (object instanceof Symbol && scriptable11 instanceof SymbolScriptable) {
                        ((SymbolScriptable)((Object)scriptable11)).put((Symbol)object, scriptable11, object2);
                    } else {
                        scriptable11.put(ScriptRuntime.toString(object), scriptable11, object2);
                    }
                });
                return scriptable11;
            }
            case -21: {
                Object object15 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable12 = NativeObject.getCompatibleObject(context, scriptable, object15);
                Object[] objectArray7 = scriptable12.getIds();
                int n7 = 0;
                for (int i = 0; i < objectArray7.length; ++i) {
                    if (objectArray7[i] instanceof Integer) {
                        int n8 = (Integer)objectArray7[i];
                        if (!scriptable12.has(n8, scriptable12) || !this.isEnumerable(n8, (Object)scriptable12)) continue;
                        objectArray7[n7++] = scriptable12.get(n8, scriptable12);
                        continue;
                    }
                    String string = ScriptRuntime.toString(objectArray7[i]);
                    if (!scriptable12.has(string, scriptable12) || !this.isEnumerable(string, (Object)scriptable12)) continue;
                    objectArray7[n7++] = scriptable12.get(string, scriptable12);
                }
                if (n7 != objectArray7.length) {
                    objectArray7 = Arrays.copyOf(objectArray7, n7);
                }
                return context.newArray(scriptable, objectArray7);
            }
            case -22: {
                Object object16 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Object object17 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                return AbstractEcmaObjectOperations.hasOwnProperty(context, object16, object17);
            }
            case -3: {
                Object object18 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable13 = NativeObject.getCompatibleObject(context, scriptable, object18);
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(scriptable13);
                Object[] objectArray8 = scriptableObject.getIds(true, false);
                for (int i = 0; i < objectArray8.length; ++i) {
                    objectArray8[i] = ScriptRuntime.toString(objectArray8[i]);
                }
                return context.newArray(scriptable, objectArray8);
            }
            case -15: {
                Object object19 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable14 = NativeObject.getCompatibleObject(context, scriptable, object19);
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(scriptable14);
                Object[] objectArray9 = scriptableObject.getIds(true, true);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object20 : objectArray9) {
                    if (!(object20 instanceof Symbol)) continue;
                    arrayList.add(object20);
                }
                return context.newArray(scriptable, arrayList.toArray());
            }
            case -4: {
                Object object21 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable15 = NativeObject.getCompatibleObject(context, scriptable, object21);
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(scriptable15);
                Object object22 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                ScriptableObject scriptableObject2 = scriptableObject.getOwnPropertyDescriptor(context, object22);
                return scriptableObject2 == null ? Undefined.instance : scriptableObject2;
            }
            case -5: {
                Object object23 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable16 = NativeObject.getCompatibleObject(context, scriptable, object23);
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(scriptable16);
                ScriptableObject scriptableObject3 = (ScriptableObject)context.newObject(scriptable);
                for (Object object24 : scriptableObject.getIds(true, true)) {
                    ScriptableObject scriptableObject4 = scriptableObject.getOwnPropertyDescriptor(context, object24);
                    if (scriptableObject4 == null) continue;
                    if (object24 instanceof Symbol) {
                        scriptableObject3.put((Symbol)object24, (Scriptable)scriptableObject3, (Object)scriptableObject4);
                        continue;
                    }
                    if (object24 instanceof Integer) {
                        scriptableObject3.put((Integer)object24, (Scriptable)scriptableObject3, (Object)scriptableObject4);
                        continue;
                    }
                    scriptableObject3.put(ScriptRuntime.toString(object24), (Scriptable)scriptableObject3, (Object)scriptableObject4);
                }
                return scriptableObject3;
            }
            case -6: {
                Object object25 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(object25);
                Object object26 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                Object object27 = objectArray.length < 3 ? Undefined.instance : objectArray[2];
                ScriptableObject scriptableObject5 = NativeObject.ensureScriptableObject(object27);
                scriptableObject.defineOwnProperty(context, object26, scriptableObject5);
                return scriptableObject;
            }
            case -7: {
                Object object28;
                Object object29 = object28 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (context.getLanguageVersion() >= 200 && !(object28 instanceof ScriptableObject)) {
                    return Boolean.FALSE;
                }
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(object28);
                return scriptableObject.isExtensible();
            }
            case -8: {
                Object object30;
                Object object31 = object30 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (context.getLanguageVersion() >= 200 && !(object30 instanceof ScriptableObject)) {
                    return object30;
                }
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(object30);
                scriptableObject.preventExtensions();
                return scriptableObject;
            }
            case -9: {
                Object object32 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                ScriptableObject scriptableObject = NativeObject.ensureScriptableObject(object32);
                Object object33 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                Scriptable scriptable17 = Context.toObject(object33, scriptable);
                scriptableObject.defineOwnProperties(context, NativeObject.ensureScriptableObject(scriptable17));
                return scriptableObject;
            }
            case -10: {
                Object object34 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Scriptable scriptable18 = object34 == null ? null : NativeObject.ensureScriptable(object34);
                NativeObject nativeObject = new NativeObject();
                nativeObject.setParentScope(scriptable);
                nativeObject.setPrototype(scriptable18);
                if (objectArray.length > 1 && !Undefined.isUndefined(objectArray[1])) {
                    Scriptable scriptable19 = Context.toObject(objectArray[1], scriptable);
                    nativeObject.defineOwnProperties(context, NativeObject.ensureScriptableObject(scriptable19));
                }
                return nativeObject;
            }
            case -11: {
                Object object35;
                Object object36 = object35 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (context.getLanguageVersion() >= 200 && !(object35 instanceof ScriptableObject)) {
                    return Boolean.TRUE;
                }
                return AbstractEcmaObjectOperations.testIntegrityLevel(context, object35, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.SEALED);
            }
            case -12: {
                Object object37;
                Object object38 = object37 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (context.getLanguageVersion() >= 200 && !(object37 instanceof ScriptableObject)) {
                    return Boolean.TRUE;
                }
                return AbstractEcmaObjectOperations.testIntegrityLevel(context, object37, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.FROZEN);
            }
            case -13: {
                Object object39;
                Object object40 = object39 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (context.getLanguageVersion() >= 200 && !(object39 instanceof ScriptableObject)) {
                    return object39;
                }
                AbstractEcmaObjectOperations.setIntegrityLevel(context, object39, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.SEALED);
                return object39;
            }
            case -14: {
                Object object41;
                Object object42 = object41 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                if (context.getLanguageVersion() >= 200 && !(object41 instanceof ScriptableObject)) {
                    return object41;
                }
                AbstractEcmaObjectOperations.setIntegrityLevel(context, object41, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.FROZEN);
                return object41;
            }
            case -16: {
                Scriptable scriptable20 = objectArray.length > 0 ? ScriptRuntime.toObject(context, scriptable, objectArray[0]) : ScriptRuntime.toObject(context, scriptable, Undefined.instance);
                for (int i = 1; i < objectArray.length; ++i) {
                    Object[] objectArray10;
                    if (objectArray[i] == null || Undefined.isUndefined(objectArray[i])) continue;
                    Scriptable scriptable21 = ScriptRuntime.toObject(context, scriptable, objectArray[i]);
                    for (Object object43 : objectArray10 = scriptable21.getIds()) {
                        Object object44;
                        if (object43 instanceof Integer) {
                            int n9 = (Integer)object43;
                            if (!scriptable21.has(n9, scriptable21) || !this.isEnumerable(n9, (Object)scriptable21)) continue;
                            object44 = scriptable21.get(n9, scriptable21);
                            AbstractEcmaObjectOperations.put(context, scriptable20, n9, object44, true);
                            continue;
                        }
                        String string = ScriptRuntime.toString(object43);
                        if (!scriptable21.has(string, scriptable21) || !this.isEnumerable(string, (Object)scriptable21)) continue;
                        object44 = scriptable21.get(string, scriptable21);
                        AbstractEcmaObjectOperations.put(context, scriptable20, string, object44, true);
                    }
                }
                return scriptable20;
            }
            case -17: {
                Object object45 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                Object object46 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                return ScriptRuntime.wrapBoolean(ScriptRuntime.same(object45, object46));
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private boolean isEnumerable(int n, Object object) {
        if (object instanceof ScriptableObject) {
            ScriptableObject scriptableObject = (ScriptableObject)object;
            int n2 = scriptableObject.getAttributes(n);
            return (n2 & 2) == 0;
        }
        return true;
    }

    private boolean isEnumerable(String string, Object object) {
        if (object instanceof ScriptableObject) {
            ScriptableObject scriptableObject = (ScriptableObject)object;
            int n = scriptableObject.getAttributes(string);
            return (n & 2) == 0;
        }
        return true;
    }

    private boolean isEnumerable(Symbol symbol, Object object) {
        if (object instanceof ScriptableObject) {
            ScriptableObject scriptableObject = (ScriptableObject)object;
            int n = scriptableObject.getAttributes(symbol);
            return (n & 2) == 0;
        }
        return true;
    }

    private static Scriptable getCompatibleObject(Context context, Scriptable scriptable, Object object) {
        if (context.getLanguageVersion() >= 200) {
            Scriptable scriptable2 = ScriptRuntime.toObject(context, scriptable, object);
            return NativeObject.ensureScriptable(scriptable2);
        }
        return NativeObject.ensureScriptable(object);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof String) {
            return this.has((String)object, (Scriptable)this);
        }
        if (object instanceof Number) {
            return this.has(((Number)object).intValue(), (Scriptable)this);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object object2 : this.values()) {
            if (object != object2 && (object == null || !object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object object) {
        Object object2 = this.get(object);
        if (object instanceof String) {
            this.delete((String)object);
        } else if (object instanceof Number) {
            this.delete(((Number)object).intValue());
        }
        return object2;
    }

    public Set<Object> keySet() {
        return new KeySet();
    }

    public Collection<Object> values() {
        return new ValueCollection();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return new EntrySet();
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "toLocaleString": {
                n = 3;
                break;
            }
            case "valueOf": {
                n = 4;
                break;
            }
            case "hasOwnProperty": {
                n = 5;
                break;
            }
            case "propertyIsEnumerable": {
                n = 6;
                break;
            }
            case "isPrototypeOf": {
                n = 7;
                break;
            }
            case "toSource": {
                n = 8;
                break;
            }
            case "__defineGetter__": {
                n = 9;
                break;
            }
            case "__defineSetter__": {
                n = 10;
                break;
            }
            case "__lookupGetter__": {
                n = 11;
                break;
            }
            case "__lookupSetter__": {
                n = 12;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new Iterator<Map.Entry<Object, Object>>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.key = null;
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Map.Entry<Object, Object> next() {
                    final Object object = this.key = this.ids[this.index++];
                    final Object object2 = NativeObject.this.get(this.key);
                    return new Map.Entry<Object, Object>(){

                        @Override
                        public Object getKey() {
                            return object;
                        }

                        @Override
                        public Object getValue() {
                            return object2;
                        }

                        @Override
                        public Object setValue(Object object3) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean equals(Object object3) {
                            if (!(object3 instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry entry = (Map.Entry)object3;
                            return (object == null ? entry.getKey() == null : object.equals(entry.getKey())) && (object2 == null ? entry.getValue() == null : object2.equals(entry.getValue()));
                        }

                        @Override
                        public int hashCode() {
                            return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
                        }

                        public String toString() {
                            return object + "=" + object2;
                        }
                    };
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }

    class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public boolean contains(Object object) {
            return NativeObject.this.containsKey(object);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Object next() {
                    try {
                        this.key = this.ids[this.index++];
                        return this.key;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.key = null;
                        throw new NoSuchElementException();
                    }
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }

    class ValueCollection
    extends AbstractCollection<Object> {
        ValueCollection() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Object next() {
                    this.key = this.ids[this.index++];
                    return NativeObject.this.get(this.key);
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }
}

