/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdFunctionObjectES6;
import org.mozilla.javascript.NativeSymbol;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.UniqueTag;

public abstract class IdScriptableObject
extends ScriptableObject
implements IdFunctionCall {
    private static final long serialVersionUID = -3744239272168621609L;
    private transient PrototypeValues prototypeValues;

    public IdScriptableObject() {
    }

    public IdScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable, scriptable2);
    }

    protected final boolean defaultHas(String string) {
        return super.has(string, (Scriptable)this);
    }

    protected final Object defaultGet(String string) {
        return super.get(string, (Scriptable)this);
    }

    protected final void defaultPut(String string, Object object) {
        super.put(string, (Scriptable)this, object);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            int n3 = n2 >>> 16;
            if ((n3 & 4) != 0) {
                return true;
            }
            int n4 = n2 & 0xFFFF;
            return NOT_FOUND != this.getInstanceIdValue(n4);
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            return this.prototypeValues.has(n);
        }
        return super.has(string, scriptable);
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        int n;
        int n2 = this.findInstanceIdInfo(symbol);
        if (n2 != 0) {
            int n3 = n2 >>> 16;
            if ((n3 & 4) != 0) {
                return true;
            }
            int n4 = n2 & 0xFFFF;
            return NOT_FOUND != this.getInstanceIdValue(n4);
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(symbol)) != 0) {
            return this.prototypeValues.has(n);
        }
        return super.has(symbol, scriptable);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        int n;
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0 && (object = this.getInstanceIdValue(n = n2 & 0xFFFF)) != NOT_FOUND) {
            return object;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0 && (object = this.prototypeValues.get(n)) != NOT_FOUND) {
            return object;
        }
        return NOT_FOUND;
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        int n;
        Object object = super.get(symbol, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        int n2 = this.findInstanceIdInfo(symbol);
        if (n2 != 0 && (object = this.getInstanceIdValue(n = n2 & 0xFFFF)) != NOT_FOUND) {
            return object;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(symbol)) != 0 && (object = this.prototypeValues.get(n)) != NOT_FOUND) {
            return object;
        }
        return NOT_FOUND;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeErrorById("msg.modify.sealed", string);
            }
            int n3 = n2 >>> 16;
            if ((n3 & 1) == 0) {
                if (scriptable == this) {
                    int n4 = n2 & 0xFFFF;
                    this.setInstanceIdValue(n4, object);
                } else {
                    scriptable.put(string, scriptable, object);
                }
            }
            return;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeErrorById("msg.modify.sealed", string);
            }
            this.prototypeValues.set(n, scriptable, object);
            return;
        }
        super.put(string, scriptable, object);
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        int n;
        int n2 = this.findInstanceIdInfo(symbol);
        if (n2 != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeErrorById("msg.modify.sealed", new Object[0]);
            }
            int n3 = n2 >>> 16;
            if ((n3 & 1) == 0) {
                if (scriptable == this) {
                    int n4 = n2 & 0xFFFF;
                    this.setInstanceIdValue(n4, object);
                } else {
                    IdScriptableObject.ensureSymbolScriptable(scriptable).put(symbol, scriptable, object);
                }
            }
            return;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(symbol)) != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeErrorById("msg.modify.sealed", new Object[0]);
            }
            this.prototypeValues.set(n, scriptable, object);
            return;
        }
        super.put(symbol, scriptable, object);
    }

    @Override
    public void delete(String string) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0 && !this.isSealed()) {
            int n3 = n2 >>> 16;
            if ((n3 & 4) != 0) {
                Context context = Context.getContext();
                if (context.isStrictMode()) {
                    throw ScriptRuntime.typeErrorById("msg.delete.property.with.configurable.false", string);
                }
            } else {
                int n4 = n2 & 0xFFFF;
                this.setInstanceIdValue(n4, NOT_FOUND);
            }
            return;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            if (!this.isSealed()) {
                this.prototypeValues.delete(n);
            }
            return;
        }
        super.delete(string);
    }

    @Override
    public void delete(Symbol symbol) {
        int n;
        int n2 = this.findInstanceIdInfo(symbol);
        if (n2 != 0 && !this.isSealed()) {
            int n3 = n2 >>> 16;
            if ((n3 & 4) != 0) {
                Context context = Context.getContext();
                if (context.isStrictMode()) {
                    throw ScriptRuntime.typeErrorById("msg.delete.property.with.configurable.false", new Object[0]);
                }
            } else {
                int n4 = n2 & 0xFFFF;
                this.setInstanceIdValue(n4, NOT_FOUND);
            }
            return;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(symbol)) != 0) {
            if (!this.isSealed()) {
                this.prototypeValues.delete(n);
            }
            return;
        }
        super.delete(symbol);
    }

    @Override
    public int getAttributes(String string) {
        int n;
        int n2 = this.findInstanceIdInfo(string);
        if (n2 != 0) {
            int n3 = n2 >>> 16;
            return n3;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            return this.prototypeValues.getAttributes(n);
        }
        return super.getAttributes(string);
    }

    @Override
    public int getAttributes(Symbol symbol) {
        int n;
        int n2 = this.findInstanceIdInfo(symbol);
        if (n2 != 0) {
            int n3 = n2 >>> 16;
            return n3;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(symbol)) != 0) {
            return this.prototypeValues.getAttributes(n);
        }
        return super.getAttributes(symbol);
    }

    @Override
    public void setAttributes(String string, int n) {
        int n2;
        ScriptableObject.checkValidAttributes(n);
        int n3 = this.findInstanceIdInfo(string);
        if (n3 != 0) {
            int n4 = n3 & 0xFFFF;
            int n5 = n3 >>> 16;
            if (n != n5) {
                this.setInstanceIdAttributes(n4, n);
            }
            return;
        }
        if (this.prototypeValues != null && (n2 = this.prototypeValues.findId(string)) != 0) {
            this.prototypeValues.setAttributes(n2, n);
            return;
        }
        super.setAttributes(string, n);
    }

    @Override
    Object[] getIds(boolean bl, boolean bl2) {
        int n;
        Object[] objectArray = super.getIds(bl, bl2);
        if (this.prototypeValues != null) {
            objectArray = this.prototypeValues.getNames(bl, bl2, objectArray);
        }
        if ((n = this.getMaxInstanceId()) != 0) {
            Object[] objectArray2 = null;
            int n2 = 0;
            for (int i = n; i != 0; --i) {
                int n3;
                String string = this.getInstanceIdName(i);
                int n4 = this.findInstanceIdInfo(string);
                if (n4 == 0 || ((n3 = n4 >>> 16) & 4) == 0 && NOT_FOUND == this.getInstanceIdValue(i) || !bl && (n3 & 2) != 0) continue;
                if (n2 == 0) {
                    objectArray2 = new Object[i];
                }
                objectArray2[n2++] = string;
            }
            if (n2 != 0) {
                if (objectArray.length == 0 && objectArray2.length == n2) {
                    objectArray = objectArray2;
                } else {
                    Object[] objectArray3 = new Object[objectArray.length + n2];
                    System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, n2);
                    objectArray = objectArray3;
                }
            }
        }
        return objectArray;
    }

    protected int getMaxInstanceId() {
        return 0;
    }

    protected static int instanceIdInfo(int n, int n2) {
        return n << 16 | n2;
    }

    protected int findInstanceIdInfo(String string) {
        return 0;
    }

    protected int findInstanceIdInfo(Symbol symbol) {
        return 0;
    }

    protected String getInstanceIdName(int n) {
        throw new IllegalArgumentException(String.valueOf(n));
    }

    protected Object getInstanceIdValue(int n) {
        throw new IllegalStateException(String.valueOf(n));
    }

    protected void setInstanceIdValue(int n, Object object) {
        throw new IllegalStateException(String.valueOf(n));
    }

    protected void setInstanceIdAttributes(int n, int n2) {
        throw ScriptRuntime.constructError("InternalError", "Changing attributes not supported for " + this.getClassName() + " " + this.getInstanceIdName(n) + " property");
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        throw idFunctionObject.unknown();
    }

    public final IdFunctionObject exportAsJSClass(int n, Scriptable scriptable, boolean bl) {
        if (scriptable != this && scriptable != null) {
            this.setParentScope(scriptable);
            this.setPrototype(IdScriptableObject.getObjectPrototype(scriptable));
        }
        this.activatePrototypeMap(n);
        IdFunctionObject idFunctionObject = this.prototypeValues.createPrecachedConstructor();
        if (bl) {
            this.sealObject();
        }
        this.fillConstructorProperties(idFunctionObject);
        if (bl) {
            idFunctionObject.sealObject();
        }
        idFunctionObject.exportAsScopeProperty();
        return idFunctionObject;
    }

    public final boolean hasPrototypeMap() {
        return this.prototypeValues != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activatePrototypeMap(int n) {
        PrototypeValues prototypeValues = new PrototypeValues(this, n);
        IdScriptableObject idScriptableObject = this;
        synchronized (idScriptableObject) {
            if (this.prototypeValues != null) {
                throw new IllegalStateException();
            }
            this.prototypeValues = prototypeValues;
        }
    }

    public final IdFunctionObject initPrototypeMethod(Object object, int n, String string, int n2) {
        return this.initPrototypeMethod(object, n, string, string, n2);
    }

    public final IdFunctionObject initPrototypeMethod(Object object, int n, String string, String string2, int n2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope(this);
        IdFunctionObject idFunctionObject = this.newIdFunction(object, n, string2 != null ? string2 : string, n2, scriptable);
        this.prototypeValues.initValue(n, string, (Object)idFunctionObject, 2);
        return idFunctionObject;
    }

    public final IdFunctionObject initPrototypeMethod(Object object, int n, Symbol symbol, String string, int n2) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope(this);
        IdFunctionObject idFunctionObject = this.newIdFunction(object, n, string, n2, scriptable);
        this.prototypeValues.initValue(n, symbol, (Object)idFunctionObject, 2);
        return idFunctionObject;
    }

    public final void initPrototypeConstructor(IdFunctionObject idFunctionObject) {
        int n = this.prototypeValues.constructorId;
        if (n == 0) {
            throw new IllegalStateException();
        }
        if (idFunctionObject.methodId() != n) {
            throw new IllegalArgumentException();
        }
        if (this.isSealed()) {
            idFunctionObject.sealObject();
        }
        this.prototypeValues.initValue(n, "constructor", (Object)idFunctionObject, 2);
    }

    public final void initPrototypeValue(int n, String string, Object object, int n2) {
        this.prototypeValues.initValue(n, string, object, n2);
    }

    public final void initPrototypeValue(int n, Symbol symbol, Object object, int n2) {
        this.prototypeValues.initValue(n, symbol, object, n2);
    }

    protected void initPrototypeId(int n) {
        throw new IllegalStateException(String.valueOf(n));
    }

    protected int findPrototypeId(String string) {
        throw new IllegalStateException(string);
    }

    protected int findPrototypeId(Symbol symbol) {
        return 0;
    }

    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
    }

    protected void addIdFunctionProperty(Scriptable scriptable, Object object, int n, String string, int n2) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        IdFunctionObject idFunctionObject = this.newIdFunction(object, n, string, n2, scriptable2);
        idFunctionObject.addAsProperty(scriptable);
    }

    protected static <T> T ensureType(Object object, Class<T> clazz, IdFunctionObject idFunctionObject) {
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (object == null) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call.details", idFunctionObject.getFunctionName(), "null", clazz.getName());
        }
        throw ScriptRuntime.typeErrorById("msg.incompat.call.details", idFunctionObject.getFunctionName(), object.getClass().getName(), clazz.getName());
    }

    private IdFunctionObject newIdFunction(Object object, int n, String string, int n2, Scriptable scriptable) {
        IdFunctionObject idFunctionObject = null;
        idFunctionObject = Context.getContext().getLanguageVersion() < 200 ? new IdFunctionObject(this, object, n, string, n2, scriptable) : new IdFunctionObjectES6(this, object, n, string, n2, scriptable);
        if (this.isSealed()) {
            idFunctionObject.sealObject();
        }
        return idFunctionObject;
    }

    @Override
    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        if (object instanceof String) {
            int n;
            String string = (String)object;
            int n2 = this.findInstanceIdInfo(string);
            if (n2 != 0) {
                n = n2 & 0xFFFF;
                if (IdScriptableObject.isAccessorDescriptor(scriptableObject)) {
                    this.delete(n);
                } else {
                    Object object2;
                    this.checkPropertyDefinition(scriptableObject);
                    ScriptableObject scriptableObject2 = this.getOwnPropertyDescriptor(context, object);
                    this.checkPropertyChange(string, scriptableObject2, scriptableObject);
                    int n3 = n2 >>> 16;
                    Object object3 = IdScriptableObject.getProperty((Scriptable)scriptableObject, "value");
                    if (!(object3 == NOT_FOUND || (n3 & 1) != 0 && (n3 & 4) != 0 || this.sameValue(object3, object2 = this.getInstanceIdValue(n)))) {
                        this.setInstanceIdValue(n, object3);
                    }
                    n3 = this.applyDescriptorToAttributeBitset(n3, scriptableObject);
                    this.setAttributes(string, n3);
                    return;
                }
            }
            if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
                if (IdScriptableObject.isAccessorDescriptor(scriptableObject)) {
                    this.prototypeValues.delete(n);
                } else {
                    Object object4;
                    this.checkPropertyDefinition(scriptableObject);
                    ScriptableObject scriptableObject3 = this.getOwnPropertyDescriptor(context, object);
                    this.checkPropertyChange(string, scriptableObject3, scriptableObject);
                    int n4 = this.prototypeValues.getAttributes(n);
                    Object object5 = IdScriptableObject.getProperty((Scriptable)scriptableObject, "value");
                    if (object5 != NOT_FOUND && (n4 & 1) == 0 && !this.sameValue(object5, object4 = this.prototypeValues.get(n))) {
                        this.prototypeValues.set(n, this, object5);
                    }
                    this.prototypeValues.setAttributes(n, this.applyDescriptorToAttributeBitset(n4, scriptableObject));
                    if (super.has(string, (Scriptable)this)) {
                        super.delete(string);
                    }
                    return;
                }
            }
        }
        super.defineOwnProperty(context, object, scriptableObject, bl);
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        ScriptableObject scriptableObject = super.getOwnPropertyDescriptor(context, object);
        if (scriptableObject == null) {
            if (object instanceof String) {
                return this.getBuiltInDescriptor((String)object);
            }
            if (ScriptRuntime.isSymbol(object)) {
                if (object instanceof SymbolKey) {
                    return this.getBuiltInDescriptor((SymbolKey)object);
                }
                return this.getBuiltInDescriptor(((NativeSymbol)object).getKey());
            }
        }
        return scriptableObject;
    }

    private ScriptableObject getBuiltInDescriptor(String string) {
        int n;
        int n2;
        Object object = null;
        int n3 = 0;
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        if ((n2 = this.findInstanceIdInfo(string)) != 0) {
            int n4 = n2 & 0xFFFF;
            object = this.getInstanceIdValue(n4);
            n3 = n2 >>> 16;
            return IdScriptableObject.buildDataDescriptor(scriptable, object, n3);
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(string)) != 0) {
            object = this.prototypeValues.get(n);
            n3 = this.prototypeValues.getAttributes(n);
            return IdScriptableObject.buildDataDescriptor(scriptable, object, n3);
        }
        return null;
    }

    private ScriptableObject getBuiltInDescriptor(Symbol symbol) {
        int n;
        Object object = null;
        int n2 = 0;
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        if (this.prototypeValues != null && (n = this.prototypeValues.findId(symbol)) != 0) {
            object = this.prototypeValues.get(n);
            n2 = this.prototypeValues.getAttributes(n);
            return IdScriptableObject.buildDataDescriptor(scriptable, object, n2);
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.activatePrototypeMap(n);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        if (this.prototypeValues != null) {
            n = this.prototypeValues.getMaxId();
        }
        objectOutputStream.writeInt(n);
    }

    private static final class PrototypeValues
    implements Serializable {
        private static final long serialVersionUID = 3038645279153854371L;
        private static final int NAME_SLOT = 1;
        private static final int SLOT_SPAN = 2;
        private IdScriptableObject obj;
        private int maxId;
        private Object[] valueArray;
        private short[] attributeArray;
        int constructorId;
        private IdFunctionObject constructor;
        private short constructorAttrs;

        PrototypeValues(IdScriptableObject idScriptableObject, int n) {
            if (idScriptableObject == null) {
                throw new IllegalArgumentException();
            }
            if (n < 1) {
                throw new IllegalArgumentException();
            }
            this.obj = idScriptableObject;
            this.maxId = n;
        }

        final int getMaxId() {
            return this.maxId;
        }

        final void initValue(int n, String string, Object object, int n2) {
            if (1 > n || n > this.maxId) {
                throw new IllegalArgumentException();
            }
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (object == Scriptable.NOT_FOUND) {
                throw new IllegalArgumentException();
            }
            ScriptableObject.checkValidAttributes(n2);
            if (this.obj.findPrototypeId(string) != n) {
                throw new IllegalArgumentException(string);
            }
            if (n == this.constructorId) {
                if (!(object instanceof IdFunctionObject)) {
                    throw new IllegalArgumentException("consructor should be initialized with IdFunctionObject");
                }
                this.constructor = (IdFunctionObject)object;
                this.constructorAttrs = (short)n2;
                return;
            }
            this.initSlot(n, string, object, n2);
        }

        final void initValue(int n, Symbol symbol, Object object, int n2) {
            if (1 > n || n > this.maxId) {
                throw new IllegalArgumentException();
            }
            if (symbol == null) {
                throw new IllegalArgumentException();
            }
            if (object == Scriptable.NOT_FOUND) {
                throw new IllegalArgumentException();
            }
            ScriptableObject.checkValidAttributes(n2);
            if (this.obj.findPrototypeId(symbol) != n) {
                throw new IllegalArgumentException(symbol.toString());
            }
            if (n == this.constructorId) {
                if (!(object instanceof IdFunctionObject)) {
                    throw new IllegalArgumentException("consructor should be initialized with IdFunctionObject");
                }
                this.constructor = (IdFunctionObject)object;
                this.constructorAttrs = (short)n2;
                return;
            }
            this.initSlot(n, symbol, object, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initSlot(int n, Object object, Object object2, int n2) {
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                throw new IllegalStateException();
            }
            if (object2 == null) {
                object2 = UniqueTag.NULL_VALUE;
            }
            int n3 = (n - 1) * 2;
            PrototypeValues prototypeValues = this;
            synchronized (prototypeValues) {
                Object object3 = objectArray[n3];
                if (object3 == null) {
                    objectArray[n3] = object2;
                    objectArray[n3 + 1] = object;
                    this.attributeArray[n - 1] = (short)n2;
                } else if (!object.equals(objectArray[n3 + 1])) {
                    throw new IllegalStateException();
                }
            }
        }

        final IdFunctionObject createPrecachedConstructor() {
            if (this.constructorId != 0) {
                throw new IllegalStateException();
            }
            this.constructorId = this.obj.findPrototypeId("constructor");
            if (this.constructorId == 0) {
                throw new IllegalStateException("No id for constructor property");
            }
            this.obj.initPrototypeId(this.constructorId);
            if (this.constructor == null) {
                throw new IllegalStateException(this.obj.getClass().getName() + ".initPrototypeId() did not initialize id=" + this.constructorId);
            }
            this.constructor.initFunction(this.obj.getClassName(), ScriptableObject.getTopLevelScope(this.obj));
            this.constructor.markAsConstructor(this.obj);
            return this.constructor;
        }

        final int findId(String string) {
            return this.obj.findPrototypeId(string);
        }

        final int findId(Symbol symbol) {
            return this.obj.findPrototypeId(symbol);
        }

        final boolean has(int n) {
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                return true;
            }
            int n2 = (n - 1) * 2;
            Object object = objectArray[n2];
            if (object == null) {
                return true;
            }
            return object != Scriptable.NOT_FOUND;
        }

        final Object get(int n) {
            Object object = this.ensureId(n);
            if (object == UniqueTag.NULL_VALUE) {
                object = null;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void set(int n, Scriptable scriptable, Object object) {
            if (object == Scriptable.NOT_FOUND) {
                throw new IllegalArgumentException();
            }
            this.ensureId(n);
            short s = this.attributeArray[n - 1];
            if ((s & 1) == 0) {
                if (scriptable == this.obj) {
                    if (object == null) {
                        object = UniqueTag.NULL_VALUE;
                    }
                    int n2 = (n - 1) * 2;
                    PrototypeValues prototypeValues = this;
                    synchronized (prototypeValues) {
                        this.valueArray[n2] = object;
                    }
                } else {
                    int n3 = (n - 1) * 2 + 1;
                    Object object2 = this.valueArray[n3];
                    if (object2 instanceof Symbol) {
                        if (scriptable instanceof SymbolScriptable) {
                            ((SymbolScriptable)((Object)scriptable)).put((Symbol)object2, scriptable, object);
                        }
                    } else {
                        scriptable.put((String)object2, scriptable, object);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void delete(int n) {
            this.ensureId(n);
            short s = this.attributeArray[n - 1];
            if ((s & 4) != 0) {
                Context context = Context.getContext();
                if (context.isStrictMode()) {
                    int n2 = (n - 1) * 2 + 1;
                    String string = (String)this.valueArray[n2];
                    throw ScriptRuntime.typeErrorById("msg.delete.property.with.configurable.false", string);
                }
            } else {
                int n3 = (n - 1) * 2;
                PrototypeValues prototypeValues = this;
                synchronized (prototypeValues) {
                    this.valueArray[n3] = Scriptable.NOT_FOUND;
                    this.attributeArray[n - 1] = 0;
                }
            }
        }

        final int getAttributes(int n) {
            this.ensureId(n);
            return this.attributeArray[n - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setAttributes(int n, int n2) {
            ScriptableObject.checkValidAttributes(n2);
            this.ensureId(n);
            PrototypeValues prototypeValues = this;
            synchronized (prototypeValues) {
                this.attributeArray[n - 1] = (short)n2;
            }
        }

        final Object[] getNames(boolean bl, boolean bl2, Object[] objectArray) {
            Object[] objectArray2;
            int n;
            Object[] objectArray3 = null;
            int n2 = 0;
            for (n = 1; n <= this.maxId; ++n) {
                objectArray2 = this.ensureId(n);
                if (!bl && (this.attributeArray[n - 1] & 2) != 0 || objectArray2 == Scriptable.NOT_FOUND) continue;
                int n3 = (n - 1) * 2 + 1;
                Object object = this.valueArray[n3];
                if (object instanceof String) {
                    if (objectArray3 == null) {
                        objectArray3 = new Object[this.maxId];
                    }
                    objectArray3[n2++] = object;
                    continue;
                }
                if (!bl2 || !(object instanceof Symbol)) continue;
                if (objectArray3 == null) {
                    objectArray3 = new Object[this.maxId];
                }
                objectArray3[n2++] = object.toString();
            }
            if (n2 == 0) {
                return objectArray;
            }
            if (objectArray == null || objectArray.length == 0) {
                if (n2 != objectArray3.length) {
                    Object[] objectArray4 = new Object[n2];
                    System.arraycopy(objectArray3, 0, objectArray4, 0, n2);
                    objectArray3 = objectArray4;
                }
                return objectArray3;
            }
            n = objectArray.length;
            objectArray2 = new Object[n + n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray3, 0, objectArray2, n, n2);
            return objectArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object ensureId(int n) {
            int n2;
            Object object;
            Object[] objectArray = this.valueArray;
            if (objectArray == null) {
                PrototypeValues prototypeValues = this;
                synchronized (prototypeValues) {
                    objectArray = this.valueArray;
                    if (objectArray == null) {
                        this.valueArray = objectArray = new Object[this.maxId * 2];
                        this.attributeArray = new short[this.maxId];
                    }
                }
            }
            if ((object = objectArray[n2 = (n - 1) * 2]) == null) {
                if (n == this.constructorId) {
                    this.initSlot(this.constructorId, "constructor", this.constructor, this.constructorAttrs);
                    this.constructor = null;
                } else {
                    this.obj.initPrototypeId(n);
                }
                object = objectArray[n2];
                if (object == null) {
                    throw new IllegalStateException(this.obj.getClass().getName() + ".initPrototypeId(int id) did not initialize id=" + n);
                }
            }
            return object;
        }
    }
}

