/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.XBLOMContentElement;
import io.sf.carte.echosvg.bridge.svg12.AbstractContentSelector;
import io.sf.carte.echosvg.bridge.svg12.ContentManager;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.ArrayNodeList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPatternContentSelector
extends AbstractContentSelector {
    protected NSPrefixResolver prefixResolver = new NSPrefixResolver();
    protected XPathExpression xpath;
    protected SelectedNodes selectedContent;
    protected String expression;

    public XPathPatternContentSelector(ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element, String string) {
        super(contentManager, xBLOMContentElement, element);
        this.expression = string;
        this.parse();
    }

    protected void parse() {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(this.prefixResolver);
            this.xpath = xPath.compile(this.expression);
        }
        catch (XPathExpressionException xPathExpressionException) {
            AbstractDocument abstractDocument = (AbstractDocument)this.contentElement.getOwnerDocument();
            throw abstractDocument.createXPathException((short)51, "xpath.invalid.expression", new Object[]{this.expression, xPathExpressionException.getMessage()});
        }
    }

    @Override
    public NodeList getSelectedContent() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
        }
        return this.selectedContent;
    }

    @Override
    boolean update() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
            return true;
        }
        this.parse();
        return this.selectedContent.update();
    }

    protected class NSPrefixResolver
    implements NamespaceContext {
        protected NSPrefixResolver() {
        }

        @Override
        public String getNamespaceURI(String string) {
            return XPathPatternContentSelector.this.contentElement.lookupNamespaceURI(string);
        }

        @Override
        public String getPrefix(String string) {
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            return null;
        }
    }

    protected class SelectedNodes
    extends ArrayNodeList {
        public SelectedNodes() {
            this.update();
        }

        protected boolean update() {
            ArrayList arrayList = (ArrayList)this.nodes.clone();
            this.nodes.clear();
            for (Node node = XPathPatternContentSelector.this.boundElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.update(node);
            }
            int n = this.nodes.size();
            if (arrayList.size() != n) {
                return true;
            }
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) == this.nodes.get(i)) continue;
                return true;
            }
            return false;
        }

        protected boolean descendantSelected(Node node) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!XPathPatternContentSelector.this.isSelected(node) && !this.descendantSelected(node)) continue;
                return true;
            }
            return false;
        }

        protected void update(Node node) {
            if (!XPathPatternContentSelector.this.isSelected(node)) {
                try {
                    Double d = (Double)XPathPatternContentSelector.this.xpath.evaluate(node, XPathConstants.NUMBER);
                    if (d != null) {
                        if (!this.descendantSelected(node)) {
                            this.nodes.add(node);
                        }
                    } else {
                        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                            this.update(node);
                        }
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {
                    AbstractDocument abstractDocument = (AbstractDocument)XPathPatternContentSelector.this.contentElement.getOwnerDocument();
                    throw abstractDocument.createXPathException((short)51, "xpath.error", new Object[]{XPathPatternContentSelector.this.expression, xPathExpressionException.getMessage()});
                }
            }
        }
    }
}

