/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class IfStatement
extends AstNode {
    private AstNode condition;
    private AstNode thenPart;
    private int elsePosition = -1;
    private AstNode elsePart;
    private AstNode elseKeyWordInlineComment;
    private int lp = -1;
    private int rp = -1;

    public IfStatement() {
        this.type = 116;
    }

    public IfStatement(int n) {
        super(n);
        this.type = 116;
    }

    public IfStatement(int n, int n2) {
        super(n, n2);
        this.type = 116;
    }

    public AstNode getCondition() {
        return this.condition;
    }

    public void setCondition(AstNode astNode) {
        this.assertNotNull(astNode);
        this.condition = astNode;
        astNode.setParent(this);
    }

    public AstNode getThenPart() {
        return this.thenPart;
    }

    public void setThenPart(AstNode astNode) {
        this.assertNotNull(astNode);
        this.thenPart = astNode;
        astNode.setParent(this);
    }

    public AstNode getElsePart() {
        return this.elsePart;
    }

    public void setElsePart(AstNode astNode) {
        this.elsePart = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public int getElsePosition() {
        return this.elsePosition;
    }

    public void setElsePosition(int n) {
        this.elsePosition = n;
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    @Override
    public String toSource(int n) {
        String string = this.makeIndent(n);
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string);
        stringBuilder.append("if (");
        stringBuilder.append(this.condition.toSource(0));
        stringBuilder.append(") ");
        if (this.getInlineComment() != null) {
            stringBuilder.append("    ").append(this.getInlineComment().toSource()).append("\n");
        }
        if (this.thenPart.getType() != 133) {
            if (this.getInlineComment() == null) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(this.makeIndent(n + 1));
        }
        stringBuilder.append(this.thenPart.toSource(n).trim());
        if (this.elsePart != null) {
            if (this.thenPart.getType() != 133) {
                stringBuilder.append("\n").append(string).append("else ");
            } else {
                stringBuilder.append(" else ");
            }
            if (this.getElseKeyWordInlineComment() != null) {
                stringBuilder.append("    ").append(this.getElseKeyWordInlineComment().toSource()).append("\n");
            }
            if (this.elsePart.getType() != 133 && this.elsePart.getType() != 116) {
                if (this.getElseKeyWordInlineComment() == null) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(this.makeIndent(n + 1));
            }
            stringBuilder.append(this.elsePart.toSource(n).trim());
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.condition.visit(nodeVisitor);
            this.thenPart.visit(nodeVisitor);
            if (this.elsePart != null) {
                this.elsePart.visit(nodeVisitor);
            }
        }
    }

    public AstNode getElseKeyWordInlineComment() {
        return this.elseKeyWordInlineComment;
    }

    public void setElseKeyWordInlineComment(AstNode astNode) {
        this.elseKeyWordInlineComment = astNode;
    }
}

