/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.MorphologyRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.AffineRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.BufferedImageCachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.MorphologyOp;
import io.sf.carte.echosvg.ext.awt.image.rendered.PadRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.RenderedImageCachableRed;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;

public class MorphologyRable8Bit
extends AbstractRable
implements MorphologyRable {
    private double radiusX;
    private double radiusY;
    private boolean doDilation;

    public MorphologyRable8Bit(Filter filter, double d, double d2, boolean bl) {
        super(filter, null);
        this.setRadiusX(d);
        this.setRadiusY(d2);
        this.setDoDilation(bl);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds2D();
    }

    @Override
    public void setRadiusX(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.radiusX = d;
    }

    @Override
    public void setRadiusY(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.radiusY = d;
    }

    @Override
    public void setDoDilation(boolean bl) {
        this.touch();
        this.doDilation = bl;
    }

    @Override
    public boolean getDoDilation() {
        return this.doDilation;
    }

    @Override
    public double getRadiusX() {
        return this.radiusX;
    }

    @Override
    public double getRadiusY() {
        return this.radiusY;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        double d3 = affineTransform.getShearX();
        double d4 = affineTransform.getShearY();
        double d5 = affineTransform.getTranslateX();
        double d6 = affineTransform.getTranslateY();
        double d7 = Math.sqrt(d * d + d4 * d4);
        double d8 = Math.sqrt(d2 * d2 + d3 * d3);
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d7, d8);
        int n = (int)Math.round(this.radiusX * d7);
        int n2 = (int)Math.round(this.radiusY * d8);
        MorphologyOp morphologyOp = null;
        if (n > 0 && n2 > 0) {
            morphologyOp = new MorphologyOp(n, n2, this.doDilation);
        }
        AffineTransform affineTransform3 = new AffineTransform(d / d7, d4 / d7, d3 / d8, d2 / d8, d5, d6);
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)n / d7, rectangle2D.getY() - (double)n2 / d8, rectangle2D.getWidth() + (double)(2 * n) / d7, rectangle2D.getHeight() + (double)(2 * n2) / d8);
        RenderedImage renderedImage = this.getSource().createRendering(new RenderContext(affineTransform2, rectangle2D, renderingHints));
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = new RenderedImageCachableRed(renderedImage);
        Shape shape2 = affineTransform2.createTransformedShape(shape.getBounds2D());
        rectangle2D = shape2.getBounds2D();
        rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n2, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n2));
        cachableRed = new PadRed(cachableRed, rectangle2D.getBounds(), PadMode.ZERO_PAD, renderingHints);
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = cachableRed.getData();
        Point point = new Point(0, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), point);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = morphologyOp != null ? morphologyOp.filter(bufferedImage, null) : bufferedImage;
        int n3 = cachableRed.getMinX();
        int n4 = cachableRed.getMinY();
        cachableRed = new BufferedImageCachableRed(bufferedImage2, n3, n4);
        if (!affineTransform3.isIdentity()) {
            cachableRed = new AffineRed(cachableRed, affineTransform3, renderingHints);
        }
        return cachableRed;
    }

    @Override
    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        return super.getDependencyRegion(n, rectangle2D);
    }

    @Override
    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        return super.getDirtyRegion(n, rectangle2D);
    }
}

