/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.ColorSpaceHintKey;
import io.sf.carte.echosvg.ext.awt.RenderingHintsKeyExt;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.FilterAlphaRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.RenderedImageCachableRed;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;

public class FilterAlphaRable
extends AbstractRable {
    public FilterAlphaRable(Filter filter) {
        super(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds2D();
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape;
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        if ((shape = renderContext.getAreaOfInterest()) == null) {
            shape = this.getBounds2D();
        }
        renderingHints.put(RenderingHintsKeyExt.KEY_COLORSPACE, ColorSpaceHintKey.VALUE_COLORSPACE_ALPHA);
        RenderedImage renderedImage = this.getSource().createRendering(new RenderContext(affineTransform, shape, renderingHints));
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = RenderedImageCachableRed.wrap(renderedImage);
        Object object = cachableRed.getProperty("io.sf.carte.echosvg.gvt.filter.Colorspace");
        if (object == ColorSpaceHintKey.VALUE_COLORSPACE_ALPHA) {
            return cachableRed;
        }
        return new FilterAlphaRed(cachableRed);
    }
}

