/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.PadRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.RenderedImageCachableRed;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractRable
implements Filter {
    private Vector<RenderableImage> srcs;
    private Map<String, Object> props = new HashMap<String, Object>();
    private long stamp = 0L;

    protected AbstractRable() {
        this.srcs = new Vector();
    }

    protected AbstractRable(Filter filter) {
        this.init(filter, null);
    }

    protected AbstractRable(Filter filter, Map<String, ?> map) {
        this.init(filter, map);
    }

    protected AbstractRable(List<? extends RenderableImage> list) {
        this(list, null);
    }

    protected AbstractRable(List<? extends RenderableImage> list, Map<String, Object> map) {
        this.init(list, map);
    }

    public final void touch() {
        ++this.stamp;
    }

    @Override
    public long getTimeStamp() {
        return this.stamp;
    }

    protected void init(RenderableImage renderableImage) {
        this.touch();
        this.srcs = new Vector(1);
        if (renderableImage != null) {
            this.srcs.add(renderableImage);
        }
    }

    protected void init(Filter filter, Map<String, ?> map) {
        this.init(filter);
        if (map != null) {
            this.props.putAll(map);
        }
    }

    protected void init(List<? extends RenderableImage> list) {
        this.touch();
        this.srcs = new Vector<RenderableImage>(list);
    }

    protected void init(List<? extends RenderableImage> list, Map<String, Object> map) {
        this.init(list);
        if (map != null) {
            this.props.putAll(map);
        }
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = null;
        if (!this.srcs.isEmpty()) {
            Iterator<RenderableImage> iterator = this.srcs.iterator();
            Filter filter = (Filter)iterator.next();
            rectangle2D = (Rectangle2D)filter.getBounds2D().clone();
            while (iterator.hasNext()) {
                filter = (Filter)iterator.next();
                Rectangle2D rectangle2D2 = filter.getBounds2D();
                Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            }
        }
        return rectangle2D;
    }

    @Override
    public Vector<RenderableImage> getSources() {
        return this.srcs;
    }

    @Override
    public RenderedImage createDefaultRendering() {
        return this.createScaledRendering(100, 100, null);
    }

    @Override
    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        float f = (float)n / this.getWidth();
        float f2 = (float)n2 / this.getHeight();
        float f3 = Math.min(f, f2);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f3, f3);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        float f4 = this.getWidth() * f3 - (float)n;
        float f5 = this.getHeight() * f3 - (float)n2;
        RenderedImage renderedImage = this.createRendering(renderContext);
        CachableRed cachableRed = RenderedImageCachableRed.wrap(renderedImage);
        return new PadRed(cachableRed, new Rectangle((int)(f4 / 2.0f), (int)(f5 / 2.0f), n, n2), PadMode.ZERO_PAD, null);
    }

    @Override
    public float getMinX() {
        return (float)this.getBounds2D().getX();
    }

    @Override
    public float getMinY() {
        return (float)this.getBounds2D().getY();
    }

    @Override
    public float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    @Override
    public float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    @Override
    public Object getProperty(String string) {
        Object object = this.props.get(string);
        if (object != null) {
            return object;
        }
        for (RenderableImage renderableImage : this.srcs) {
            Object object2 = renderableImage.getProperty(string);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        Set<String> set = this.props.keySet();
        Iterator<String> iterator = set.iterator();
        String[] stringArray = new String[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        for (RenderableImage renderableImage : this.srcs) {
            String[] stringArray2 = renderableImage.getPropertyNames();
            if (stringArray2.length == 0) continue;
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray3, stringArray.length, stringArray2, 0, stringArray2.length);
            stringArray = stringArray3;
        }
        return stringArray;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        if (n < 0 || n > this.srcs.size()) {
            throw new IndexOutOfBoundsException("Nonexistant source requested.");
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        Rectangle2D rectangle2D3 = this.getBounds2D();
        if (!rectangle2D3.intersects(rectangle2D2)) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D3, rectangle2D2);
        return rectangle2D2;
    }

    @Override
    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        if (n < 0 || n > this.srcs.size()) {
            throw new IndexOutOfBoundsException("Nonexistant source requested.");
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        Rectangle2D rectangle2D3 = this.getBounds2D();
        if (!rectangle2D3.intersects(rectangle2D2)) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D3, rectangle2D2);
        return rectangle2D2;
    }
}

