/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ShorthandDatabase {
    private final Map<String, String[]> shorthand2subp = new HashMap<String, String[]>();
    private final Map<String, String> subp2shorthand = new HashMap<String, String>();
    private final Properties identifiers;
    private static final ShorthandDatabase singleton = new ShorthandDatabase();

    private ShorthandDatabase() {
        this(null);
    }

    public ShorthandDatabase(ClassLoader classLoader) {
        this.identifiers = this.loadPropertiesfromClasspath("identifier.properties", classLoader);
        Properties properties = this.loadPropertiesfromClasspath("shorthand.properties", classLoader);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
            this.addShorthand(string, arrayList.toArray(new String[0]));
            arrayList.clear();
        }
    }

    public static ShorthandDatabase getInstance() {
        return singleton;
    }

    public static ShorthandDatabase getInstance(ClassLoader classLoader) {
        return new ShorthandDatabase(classLoader);
    }

    public boolean isShorthand(String string) {
        return this.shorthand2subp.containsKey(string);
    }

    public boolean isShorthandSubproperty(String string) {
        return this.subp2shorthand.containsKey(string);
    }

    public String getShorthand(String string) {
        return this.subp2shorthand.get(string);
    }

    public boolean isShorthandSubpropertyOf(String string, String string2) {
        String[] stringArray;
        String string3 = this.subp2shorthand.get(string2);
        if (string3 == null) {
            return false;
        }
        if (string3.equals(string)) {
            return true;
        }
        if (string.equals(string3 = this.subp2shorthand.get(string3))) {
            return true;
        }
        for (String string4 : stringArray = this.shorthand2subp.get(string)) {
            if (!string4.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public String[] getShorthandSubproperties(String string) {
        return this.shorthand2subp.get(string);
    }

    public String[] getLonghandProperties(String string) {
        String[] stringArray = this.getShorthandSubproperties(string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!this.isShorthand(string2)) continue;
                return this.longhandArray(stringArray);
            }
        }
        return stringArray;
    }

    private String[] longhandArray(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : stringArray) {
            if (!this.isShorthand(string)) {
                linkedList.add(string);
                continue;
            }
            this.addLonghandsToList(linkedList, string);
        }
        return linkedList.toArray(new String[0]);
    }

    private void addLonghandsToList(LinkedList<String> linkedList, String string) {
        if (!this.isShorthand(string)) {
            linkedList.add(string);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = this.getShorthandSubproperties(string)) {
                this.addLonghandsToList(linkedList, string2);
            }
        }
    }

    private void addShorthand(String string, String[] stringArray) {
        this.shorthand2subp.put(string, stringArray);
        for (String string2 : stringArray) {
            String string3 = this.subp2shorthand.get(string2);
            if (string3 != null) {
                String string4 = this.subp2shorthand.get(string);
                String string5 = this.subp2shorthand.get(string3);
                if (string4 == null) {
                    if (string5 != null) {
                        this.subp2shorthand.put(string, string5);
                    }
                } else if (string5 == null) {
                    this.subp2shorthand.put(string3, string4);
                }
            }
            this.subp2shorthand.put(string2, string);
        }
    }

    public boolean isIdentifierValue(String string, String string2) {
        String string3 = this.identifiers.getProperty(string);
        if (string3 == null) {
            if (string.endsWith("-color")) {
                string2 = string2.toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(string2);
            }
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string4.trim().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasKnownIdentifierValues(String string) {
        return this.identifiers.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesfromClasspath(String string, ClassLoader classLoader) {
        InputStream inputStream = classLoader != null ? classLoader.getResourceAsStream(this.resourcePath(string)) : this.getClass().getResourceAsStream(this.resourcePath(string));
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            Properties properties2 = null;
            return properties2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private String resourcePath(String string) {
        return '/' + ShorthandDatabase.class.getPackage().getName().replace('.', '/') + '/' + string;
    }
}

