/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueFactory;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.ProductExpression;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.doc.style.css.property.SumExpression;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;

public class ExpressionFactory {
    private LexicalUnit nextLexicalUnit;

    public ExpressionFactory(LexicalUnit lexicalUnit) {
        this.nextLexicalUnit = lexicalUnit;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public CSSExpression createExpression(LexicalUnit lexicalUnit) {
        return this.createExpression(lexicalUnit, this.getCSSValueFactory());
    }

    protected CSSValueFactory getCSSValueFactory() {
        return new ValueFactory();
    }

    private StyleExpression createExpression(LexicalUnit lexicalUnit, CSSValueFactory cSSValueFactory) {
        Object object = null;
        LexicalUnit.LexicalType lexicalType = LexicalUnit.LexicalType.UNKNOWN;
        block10: while (lexicalUnit != null) {
            boolean bl = false;
            LexicalUnit.LexicalType lexicalType2 = lexicalUnit.getLexicalUnitType();
            switch (lexicalType2) {
                case OPERATOR_MINUS: {
                    bl = true;
                }
                case OPERATOR_PLUS: {
                    StyleExpression styleExpression;
                    if (object == null) {
                        if (bl) {
                            object = new SumExpression();
                            ((StyleExpression)object).nextOperandInverse = true;
                            break;
                        }
                        throw new DOMException(12, "Missing operand");
                    }
                    if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                        styleExpression = new SumExpression();
                        styleExpression.addExpression((StyleExpression)object);
                        styleExpression.nextOperandInverse = bl;
                        object = styleExpression;
                        break;
                    }
                    if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.SUM) {
                        ((StyleExpression)object).nextOperandInverse = bl;
                        break;
                    }
                    if (lexicalType != LexicalUnit.LexicalType.DIMENSION && lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                        throw new DOMException(12, "Missing operand");
                    }
                    Object object2 = ((StyleExpression)object).getParentExpression();
                    if (object2 == null) {
                        styleExpression = new SumExpression();
                        styleExpression.addExpression((StyleExpression)object);
                        styleExpression.nextOperandInverse = bl;
                        object = styleExpression;
                        break;
                    }
                    object = object2;
                    ((StyleExpression)object).nextOperandInverse = bl;
                    break;
                }
                case OPERATOR_SLASH: {
                    bl = true;
                }
                case OPERATOR_MULTIPLY: {
                    StyleExpression styleExpression;
                    if (object == null) {
                        throw new DOMException(12, "Missing factor");
                    }
                    if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                        styleExpression = new ProductExpression();
                        styleExpression.addExpression((StyleExpression)object);
                        styleExpression.nextOperandInverse = bl;
                        object = styleExpression;
                        break;
                    }
                    if (((StyleExpression)object).getPartType() == CSSExpression.AlgebraicPart.SUM) {
                        if (lexicalType != LexicalUnit.LexicalType.DIMENSION && lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                            throw new DOMException(12, "Missing operand");
                        }
                        styleExpression = new ProductExpression();
                        if (lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                            ((StyleExpression)object).replaceLastExpression(styleExpression);
                        } else {
                            styleExpression.addExpression((StyleExpression)object);
                        }
                        styleExpression.nextOperandInverse = bl;
                        object = styleExpression;
                        break;
                    }
                    if (lexicalType != LexicalUnit.LexicalType.DIMENSION && lexicalType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                        throw new DOMException(12, "Missing operand");
                    }
                    ((StyleExpression)object).nextOperandInverse = bl;
                    break;
                }
                case SUB_EXPRESSION: {
                    Object object2 = lexicalUnit.getSubValues();
                    if (object2 == null) {
                        throw new DOMException(12, "Empty sub-expression");
                    }
                    StyleExpression styleExpression = this.createExpression((LexicalUnit)object2, cSSValueFactory);
                    if (styleExpression != null) {
                        if (object != null) {
                            ((StyleExpression)object).addExpression(styleExpression);
                            if (((StyleExpression)object).getPartType() != CSSExpression.AlgebraicPart.SUM) break;
                            object = styleExpression;
                            break;
                        }
                        object = styleExpression;
                        break;
                    }
                    throw new DOMException(12, "Bad subexpression");
                }
                case OPERATOR_COMMA: {
                    if (this.nextLexicalUnit != null || ((StyleExpression)object).getParentExpression() != null) {
                        throw new DOMException(5, "Bad operand: ','");
                    }
                    this.nextLexicalUnit = lexicalUnit;
                    return object;
                }
                case IDENT: {
                    String string = lexicalUnit.getStringValue();
                    TypedValue typedValue = this.createConstant(string);
                    if (this.isInvalidOperand(typedValue, lexicalType2, lexicalType)) {
                        throw new DOMException(5, "Bad operands");
                    }
                    OperandExpression operandExpression = new OperandExpression();
                    operandExpression.setOperand(typedValue);
                    object = ExpressionFactory.addOperand((StyleExpression)object, operandExpression);
                    lexicalType = LexicalUnit.LexicalType.DIMENSION;
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    continue block10;
                }
                case CALC: {
                    StyleExpression styleExpression;
                    Object object2;
                    if (this.isCalcValue()) {
                        lexicalType2 = LexicalUnit.LexicalType.SUB_EXPRESSION;
                        object2 = lexicalUnit.getParameters();
                        if (object2 == null) {
                            throw new DOMException(12, "Empty sub-calc()");
                        }
                        styleExpression = this.createExpression((LexicalUnit)object2, cSSValueFactory);
                        if (styleExpression != null) {
                            styleExpression.setInverseOperation(bl);
                            if (object != null) {
                                ((StyleExpression)object).addExpression(styleExpression);
                                break;
                            }
                            object = styleExpression;
                            break;
                        }
                        throw new DOMException(12, "Invalid sub-calc()");
                    }
                }
                default: {
                    CSSPrimitiveValue cSSPrimitiveValue = cSSValueFactory.createCSSPrimitiveValue(lexicalUnit);
                    if (this.isInvalidOperand(cSSPrimitiveValue, lexicalType2, lexicalType)) {
                        throw new DOMException(5, "Bad operands");
                    }
                    OperandExpression operandExpression = new OperandExpression();
                    operandExpression.setOperand(cSSPrimitiveValue);
                    object = ExpressionFactory.addOperand((StyleExpression)object, operandExpression);
                    lexicalType = LexicalUnit.LexicalType.DIMENSION;
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    continue block10;
                }
            }
            lexicalType = lexicalType2;
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        if (ExpressionFactory.isOperatorType(lexicalType)) {
            throw new DOMException(12, "Missing operand");
        }
        if (((StyleExpression)object).getParentExpression() != null) {
            object = ((StyleExpression)object).getParentExpression();
        }
        return object;
    }

    private static StyleExpression addOperand(StyleExpression styleExpression, OperandExpression operandExpression) {
        if (styleExpression == null) {
            styleExpression = operandExpression;
        } else {
            if (styleExpression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                throw new DOMException(5, "Bad expression");
            }
            styleExpression.addExpression(operandExpression);
        }
        return styleExpression;
    }

    protected boolean isInvalidOperand(CSSPrimitiveValue cSSPrimitiveValue, LexicalUnit.LexicalType lexicalType, LexicalUnit.LexicalType lexicalType2) {
        if (ExpressionFactory.isOperatorType(lexicalType)) {
            return ExpressionFactory.isOperatorType(lexicalType2);
        }
        return !ExpressionFactory.isOperatorType(lexicalType2) && lexicalType2 != LexicalUnit.LexicalType.UNKNOWN && lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA;
    }

    private static boolean isOperatorType(LexicalUnit.LexicalType lexicalType) {
        switch (lexicalType) {
            case OPERATOR_MINUS: 
            case OPERATOR_PLUS: 
            case OPERATOR_SLASH: 
            case OPERATOR_MULTIPLY: {
                return true;
            }
        }
        return false;
    }

    private TypedValue createConstant(String string) {
        NumberValue numberValue = new NumberValue();
        if ("pi".equalsIgnoreCase(string)) {
            numberValue.setFloatValue((short)0, (float)Math.PI);
        } else if ("e".equalsIgnoreCase(string)) {
            numberValue.setFloatValue((short)0, (float)Math.E);
        } else {
            if (this.isCalcValue()) {
                throw new DOMException(5, "Unknown constant: " + string);
            }
            IdentifierValue identifierValue = new IdentifierValue();
            identifierValue.setStringValue(CSSValue.Type.IDENT, string);
            return identifierValue;
        }
        return numberValue;
    }

    protected boolean isCalcValue() {
        return false;
    }
}

