/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PropertyRule;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;
import org.w3c.dom.DOMException;

class PropertyDescriptorStyleDeclaration
extends BaseCSSStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private boolean hasSyntax;
    private boolean isUniversalSyntax;
    private boolean hasInherits;

    public PropertyDescriptorStyleDeclaration(BaseCSSDeclarationRule baseCSSDeclarationRule) {
        super(baseCSSDeclarationRule);
    }

    public PropertyDescriptorStyleDeclaration() {
    }

    public PropertyDescriptorStyleDeclaration(PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration) {
        super(propertyDescriptorStyleDeclaration);
    }

    @Override
    public void addStyle(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super.addStyle(baseCSSStyleDeclaration);
        this.updateValidity();
    }

    @Override
    public void setProperty(String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        if ("syntax".equals(string = this.getCanonicalPropertyName(string))) {
            CSSValueSyntax cSSValueSyntax;
            if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) {
                throw new DOMException(17, "'syntax' descriptor in @property rule must be a string.");
            }
            String string2 = lexicalUnit.getStringValue();
            try {
                cSSValueSyntax = new SyntaxParser().parseSyntax(string2);
            }
            catch (CSSException cSSException) {
                DOMException dOMException = new DOMException(12, cSSException.getMessage());
                dOMException.initCause(cSSException);
                throw dOMException;
            }
            this.isUniversalSyntax = cSSValueSyntax.getName().equals("*");
            this.hasSyntax = true;
        } else if ("inherits".equals(string)) {
            String string3;
            if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || !"true".equalsIgnoreCase(string3 = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT)) && !"false".equalsIgnoreCase(string3)) {
                throw new DOMException(17, "'inherits' descriptor in @property rule must be either 'true' or 'false'.");
            }
            this.hasInherits = true;
        } else if ("initial-value".equals(string)) {
            StyleValue styleValue;
            ValueFactory valueFactory = this.getValueFactory();
            try {
                styleValue = valueFactory.createCSSValue(lexicalUnit, this);
            }
            catch (DOMException dOMException) {
                StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
                if (styleDeclarationErrorHandler != null) {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for " + string, dOMException);
                    cSSPropertyValueException.setValueText(PropertyDescriptorStyleDeclaration.lexicalUnitToString(lexicalUnit));
                    styleDeclarationErrorHandler.wrongValue(string, cSSPropertyValueException);
                }
                throw dOMException;
            }
            if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                CSSPropertyValueException cSSPropertyValueException = null;
                StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
                if (styleDeclarationErrorHandler != null) {
                    cSSPropertyValueException = new CSSPropertyValueException("Wrong type for 'initial-value'." + string);
                    cSSPropertyValueException.setValueText(PropertyDescriptorStyleDeclaration.lexicalUnitToString(lexicalUnit));
                    styleDeclarationErrorHandler.wrongValue(string, cSSPropertyValueException);
                }
                DOMException dOMException = new DOMException(17, "Wrong type for 'initial-value'.");
                if (cSSPropertyValueException != null) {
                    dOMException.initCause(cSSPropertyValueException);
                }
                throw dOMException;
            }
            LexicalValue lexicalValue = new LexicalValue();
            lexicalValue.setLexicalUnit(lexicalUnit);
            this.setProperty(string, lexicalValue, bl);
            return;
        }
        super.setProperty(string, lexicalUnit, bl);
    }

    @Override
    public String removeProperty(String string) {
        if (!("syntax".equals(string = this.getCanonicalPropertyName(string)) || "inherits".equals(string) || !this.isUniversalSyntax && "initial-value".equals(string))) {
            return super.removeProperty(string);
        }
        return "";
    }

    void updateValidity() {
        this.hasSyntax = false;
        this.isUniversalSyntax = false;
        this.hasInherits = false;
        for (int i = 0; i < this.getLength(); ++i) {
            String string = this.item(i);
            StyleValue styleValue = this.getPropertyCSSValue(string);
            if ("syntax".equalsIgnoreCase(string)) {
                if (styleValue.getPrimitiveType() != CSSValue.Type.STRING) continue;
                this.hasSyntax = true;
                this.isUniversalSyntax = ((CSSTypedValue)((Object)styleValue)).getStringValue().trim().equals("*");
                continue;
            }
            if (!"inherits".equalsIgnoreCase(string) || styleValue.getPrimitiveType() != CSSValue.Type.IDENT) continue;
            String string2 = ((CSSTypedValue)((Object)styleValue)).getStringValue().trim();
            this.hasInherits = "true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2);
        }
    }

    boolean isValidDeclaration() {
        return this.hasSyntax && this.hasInherits && (this.isUniversalSyntax || this.hasInitial());
    }

    private boolean hasInitial() {
        PropertyRule propertyRule = (PropertyRule)this.getParentRule();
        CSSValueSyntax cSSValueSyntax = propertyRule.getSyntax();
        StyleValue styleValue = this.getPropertyCSSValue("initial-value");
        return styleValue != null && styleValue.matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE;
    }
}

