/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.EmptyIterator;
import io.sf.carte.doc.SingleItemIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.DOMException;

public class DOMTokenSetImpl
implements DOMTokenList,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean multiple = false;
    Object value = "";

    @Override
    public String getValue() {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            StringBuilder stringBuilder = new StringBuilder(32 + 8 * linkedList.size());
            Iterator iterator = linkedList.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append((String)iterator.next());
            }
            return stringBuilder.toString();
        }
        return (String)this.value;
    }

    @Override
    public String getSortedValue() {
        if (this.multiple) {
            TreeSet treeSet = new TreeSet((LinkedList)this.value);
            StringBuilder stringBuilder = new StringBuilder(32 + 8 * treeSet.size());
            Iterator iterator = treeSet.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append((String)iterator.next());
            }
            return stringBuilder.toString();
        }
        return (String)this.value;
    }

    public void setValue(String string) throws DOMException {
        if (!DOMTokenSetImpl.checkMultipleToken(string)) {
            this.multiple = false;
            this.value = string.trim();
        } else {
            LinkedList<String> linkedList;
            if (this.multiple) {
                linkedList = (LinkedList<String>)this.value;
                linkedList.clear();
            } else {
                this.multiple = true;
                this.value = linkedList = new LinkedList<String>();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
        }
    }

    public static boolean checkMultipleToken(String string) {
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            throw new DOMException(12, "Null value");
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl && (c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f')) {
                bl2 = true;
                continue;
            }
            if (bl2) {
                return true;
            }
            bl = true;
        }
        return false;
    }

    @Override
    public int getLength() {
        if (this.multiple) {
            return ((LinkedList)this.value).size();
        }
        return ((String)this.value).length() == 0 ? 0 : 1;
    }

    @Override
    public String item(int n) {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            if (n < 0 || n >= linkedList.size()) {
                return null;
            }
            return (String)linkedList.get(n);
        }
        if (n != 0 || ((String)this.value).length() == 0) {
            return null;
        }
        return (String)this.value;
    }

    @Override
    public Iterator<String> iterator() {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            return linkedList.iterator();
        }
        return ((String)this.value).length() == 0 ? new EmptyIterator() : new SingleItemIterator((String)this.value);
    }

    @Override
    public boolean contains(String string) {
        if (this.multiple) {
            return ((LinkedList)this.value).contains(string);
        }
        return this.value.equals(string);
    }

    @Override
    public boolean containsAll(DOMTokenList dOMTokenList) {
        if (dOMTokenList == null) {
            throw new DOMException(12, "Argument is null.");
        }
        int n = dOMTokenList.getLength();
        if (n == 0) {
            return true;
        }
        if (this.multiple) {
            if (n == 1) {
                return ((LinkedList)this.value).contains(dOMTokenList.item(0));
            }
            for (String string : dOMTokenList) {
                if (this.contains(string)) continue;
                return false;
            }
            return true;
        }
        return n == 1 && this.value.equals(dOMTokenList.item(0));
    }

    @Override
    public boolean containsAll(Collection<String> collection) {
        if (this.multiple) {
            return ((LinkedList)this.value).containsAll(collection);
        }
        int n = collection.size();
        return n == 0 || n == 1 && this.value.equals(collection.iterator().next());
    }

    @Override
    public void add(String string) throws DOMException {
        this.argumentCheckVoidSpaces(string);
        this.addUnchecked(string);
    }

    protected void addUnchecked(String string) throws DOMException {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            if (!linkedList.contains(string)) {
                linkedList.add(string);
            }
        } else {
            String string2 = (String)this.value;
            if (string2.length() != 0) {
                if (!string2.equals(string)) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    linkedList.add(string2);
                    linkedList.add(string);
                    this.value = linkedList;
                    this.multiple = true;
                }
            } else {
                this.value = string;
            }
        }
    }

    @Override
    public void remove(String string) throws DOMException {
        this.argumentCheckVoidSpaces(string);
        this.removeUnchecked(string);
    }

    protected void removeUnchecked(String string) throws DOMException {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            linkedList.remove(string);
            if (linkedList.size() == 1) {
                this.value = linkedList.getFirst();
                this.multiple = false;
            }
        } else if (this.value.equals(string)) {
            this.value = "";
        }
    }

    @Override
    public boolean toggle(String string) throws DOMException {
        this.argumentCheckVoidSpaces(string);
        return this.toggleUnchecked(string);
    }

    protected boolean toggleUnchecked(String string) throws DOMException {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            if (!linkedList.remove(string)) {
                linkedList.add(string);
                return true;
            }
            if (linkedList.size() == 1) {
                this.value = linkedList.getFirst();
                this.multiple = false;
                linkedList.clear();
            }
        } else if (this.value.equals(string)) {
            this.value = "";
        } else {
            if (((String)this.value).length() == 0) {
                this.value = string;
                return true;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add((String)this.value);
            linkedList.add(string);
            this.value = linkedList;
            this.multiple = true;
            return true;
        }
        return false;
    }

    @Override
    public void replace(String string, String string2) throws DOMException {
        this.argumentCheckVoidSpaces(string);
        this.argumentCheckVoidSpaces(string2);
        this.replaceUnchecked(string, string2);
    }

    protected void replaceUnchecked(String string, String string2) throws DOMException {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            int n = linkedList.indexOf(string);
            if (n != -1) {
                if (!linkedList.contains(string2)) {
                    linkedList.set(n, string2);
                } else {
                    linkedList.remove(n);
                }
            }
        } else if (this.value.equals(string)) {
            this.value = string2;
        }
    }

    public void clear() {
        if (this.multiple) {
            ((LinkedList)this.value).clear();
            this.multiple = false;
        }
        this.value = "";
    }

    protected void argumentCheckVoidSpaces(String string) throws DOMException {
        if (string == null || string.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (string.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
    }

    public String toString() {
        return this.getValue();
    }
}

