/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.values;

import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableValue;

public class AnimatableColorValue
extends AnimatableValue {
    protected float red;
    protected float green;
    protected float blue;

    protected AnimatableColorValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableColorValue(AnimationTarget animationTarget, float f, float f2, float f3) {
        super(animationTarget);
        this.red = f;
        this.green = f2;
        this.blue = f3;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableColorValue animatableColorValue = animatableValue == null ? new AnimatableColorValue(this.target) : (AnimatableColorValue)animatableValue;
        float f2 = animatableColorValue.red;
        float f3 = animatableColorValue.green;
        float f4 = animatableColorValue.blue;
        animatableColorValue.red = this.red;
        animatableColorValue.green = this.green;
        animatableColorValue.blue = this.blue;
        AnimatableColorValue animatableColorValue2 = (AnimatableColorValue)animatableValue2;
        AnimatableColorValue animatableColorValue3 = (AnimatableColorValue)animatableValue3;
        if (animatableValue2 != null) {
            animatableColorValue.red += f * (animatableColorValue2.red - animatableColorValue.red);
            animatableColorValue.green += f * (animatableColorValue2.green - animatableColorValue.green);
            animatableColorValue.blue += f * (animatableColorValue2.blue - animatableColorValue.blue);
        }
        if (animatableValue3 != null) {
            animatableColorValue.red += (float)n * animatableColorValue3.red;
            animatableColorValue.green += (float)n * animatableColorValue3.green;
            animatableColorValue.blue += (float)n * animatableColorValue3.blue;
        }
        if (animatableColorValue.red != f2 || animatableColorValue.green != f3 || animatableColorValue.blue != f4) {
            animatableColorValue.hasChanged = true;
        }
        return animatableColorValue;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableColorValue animatableColorValue = (AnimatableColorValue)animatableValue;
        float f = this.red - animatableColorValue.red;
        float f2 = this.green - animatableColorValue.green;
        float f3 = this.blue - animatableColorValue.blue;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableColorValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public String getCssText() {
        return "rgb(" + Math.round(this.red * 255.0f) + ',' + Math.round(this.green * 255.0f) + ',' + Math.round(this.blue * 255.0f) + ')';
    }
}

