/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.text;

import io.sf.carte.echosvg.gvt.text.GVTAttributedCharacterIterator;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;

public final class ArabicTextHandler {
    private static final int arabicStart = 1536;
    private static final int arabicEnd = 1791;
    private static final AttributedCharacterIterator.Attribute ARABIC_FORM = GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM;
    private static final Integer ARABIC_NONE = GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE;
    private static final Integer ARABIC_ISOLATED = GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED;
    private static final Integer ARABIC_TERMINAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL;
    private static final Integer ARABIC_INITIAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL;
    private static final Integer ARABIC_MEDIAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL;
    static int singleCharFirst = 1569;
    static int singleCharLast = 1610;
    static int[][] singleCharRemappings = new int[][]{{65152, -1, -1, -1}, {65153, 65154, -1, -1}, {65155, 65156, -1, -1}, {65157, 65158, -1, -1}, {65159, 65160, -1, -1}, {65161, 65162, 65163, 65164}, {65165, 65166, -1, -1}, {65167, 65168, 65169, 65170}, {65171, 65172, -1, -1}, {65173, 65174, 65175, 65176}, {65177, 65178, 65179, 65180}, {65181, 65182, 65183, 65184}, {65185, 65186, 65187, 65188}, {65189, 65190, 65191, 65192}, {65193, 65194, -1, -1}, {65195, 65196, -1, -1}, {65197, 65198, -1, -1}, {65199, 65200, -1, -1}, {65201, 65202, 65203, 65204}, {65205, 65206, 65207, 65208}, {65209, 65210, 65211, 65212}, {65213, 65214, 65215, 65216}, {65217, 65218, 65219, 65220}, {65221, 65222, 65223, 65224}, {65225, 65226, 65227, 65228}, {65229, 65230, 65231, 65232}, null, null, null, null, null, null, {65233, 65234, 65235, 65236}, {65237, 65238, 65239, 65240}, {65241, 65242, 65243, 65244}, {65245, 65246, 65247, 65248}, {65249, 65250, 65251, 65252}, {65253, 65254, 65255, 65256}, {65257, 65258, 65259, 65260}, {65261, 65262, -1, -1}, {65263, 65264, -1, -1}, {65265, 65266, 65267, 65268}};
    static int doubleCharFirst = 1570;
    static int doubleCharLast = 1618;
    static int[][][] doubleCharRemappings = new int[][][]{new int[][]{{1604, 65269, 65270, -1, -1}}, new int[][]{{1604, 65271, 65272, -1, -1}}, null, new int[][]{{1604, 65273, 65274, -1, -1}}, null, new int[][]{{1604, 65275, 65276, -1, -1}}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new int[][]{{32, 65136, -1, -1, -1}, {1600, -1, -1, -1, 65137}}, new int[][]{{32, 65138, -1, -1, -1}}, new int[][]{{32, 65140, -1, -1, -1}}, new int[][]{{32, 65142, -1, -1, -1}, {1600, -1, -1, -1, 65143}}, new int[][]{{32, 65144, -1, -1, -1}, {1600, -1, -1, -1, 65145}}, new int[][]{{32, 65146, -1, -1, -1}, {1600, -1, -1, -1, 65147}}, new int[][]{{32, 65148, -1, -1, -1}, {1600, -1, -1, -1, 65149}}, new int[][]{{32, 65150, -1, -1, -1}, {1600, -1, -1, -1, 65151}}};

    private ArabicTextHandler() {
    }

    public static AttributedString assignArabicForms(AttributedString attributedString) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!ArabicTextHandler.containsArabic(attributedString)) {
            return attributedString;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n5 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        int[] nArray = null;
        if (n5 >= 3) {
            n4 = attributedCharacterIterator.first();
            n3 = attributedCharacterIterator.next();
            n2 = 1;
            n = attributedCharacterIterator.next();
            while (n != 65535) {
                if (ArabicTextHandler.arabicCharTransparent((char)n3) && ArabicTextHandler.hasSubstitute((char)n4, (char)n)) {
                    int n6;
                    if (nArray == null) {
                        nArray = new int[n5];
                        for (n6 = 0; n6 < n5; ++n6) {
                            nArray[n6] = n6 + attributedCharacterIterator.getBeginIndex();
                        }
                    }
                    n6 = nArray[n2];
                    nArray[n2] = nArray[n2 - 1];
                    nArray[n2 - 1] = n6;
                }
                n4 = n3;
                n3 = n;
                n = attributedCharacterIterator.next();
                ++n2;
            }
        }
        if (nArray != null) {
            StringBuilder stringBuilder = new StringBuilder(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                n3 = attributedCharacterIterator.setIndex((int)nArray[n2]);
                stringBuilder.append((char)n3);
            }
            AttributedString attributedString2 = new AttributedString(stringBuilder.toString());
            for (n = 0; n < n5; ++n) {
                attributedCharacterIterator.setIndex(nArray[n]);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                attributedString2.addAttributes(map, n, n + 1);
            }
            if (nArray[0] != attributedCharacterIterator.getBeginIndex()) {
                attributedCharacterIterator.setIndex(nArray[0]);
                Float f = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float f2 = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                if (f != null && !f.isNaN()) {
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, Float.valueOf(Float.NaN), nArray[0], nArray[0] + 1);
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, f, 0, 1);
                }
                if (f2 != null && !f2.isNaN()) {
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, Float.valueOf(Float.NaN), nArray[0], nArray[0] + 1);
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, f2, 0, 1);
                }
            }
            attributedString = attributedString2;
        }
        attributedCharacterIterator = attributedString.getIterator();
        n4 = -1;
        n3 = attributedCharacterIterator.getBeginIndex();
        n2 = attributedCharacterIterator.first();
        while (n2 != 65535) {
            if (n2 >= 1536 && n2 <= 1791) {
                if (n4 == -1) {
                    n4 = n3;
                }
            } else if (n4 != -1) {
                attributedString.addAttribute(ARABIC_FORM, ARABIC_NONE, n4, n3);
                n4 = -1;
            }
            n2 = attributedCharacterIterator.next();
            ++n3;
        }
        if (n4 != -1) {
            attributedString.addAttribute(ARABIC_FORM, ARABIC_NONE, n4, n3);
        }
        attributedCharacterIterator = attributedString.getIterator();
        n2 = attributedCharacterIterator.getBeginIndex();
        Integer n7 = ARABIC_NONE;
        block5: while (attributedCharacterIterator.setIndex(n2) != '\uffff') {
            int n8 = attributedCharacterIterator.getRunStart(ARABIC_FORM);
            n2 = attributedCharacterIterator.getRunLimit(ARABIC_FORM);
            char c = attributedCharacterIterator.setIndex(n8);
            n7 = (Integer)attributedCharacterIterator.getAttribute(ARABIC_FORM);
            if (n7 == null) continue;
            int n9 = n8;
            int n10 = n8 - 1;
            while (n9 < n2) {
                char c2 = c;
                c = attributedCharacterIterator.setIndex(n9);
                while (ArabicTextHandler.arabicCharTransparent(c) && n9 < n2) {
                    c = attributedCharacterIterator.setIndex(++n9);
                }
                if (n9 >= n2) continue block5;
                Integer n11 = n7;
                n7 = ARABIC_NONE;
                if (n10 >= n8) {
                    if (ArabicTextHandler.arabicCharShapesRight(c2) && ArabicTextHandler.arabicCharShapesLeft(c)) {
                        n11 = n11 + 1;
                        attributedString.addAttribute(ARABIC_FORM, n11, n10, n10 + 1);
                        n7 = ARABIC_INITIAL;
                    } else if (ArabicTextHandler.arabicCharShaped(c)) {
                        n7 = ARABIC_ISOLATED;
                    }
                } else if (ArabicTextHandler.arabicCharShaped(c)) {
                    n7 = ARABIC_ISOLATED;
                }
                if (n7 != ARABIC_NONE) {
                    attributedString.addAttribute(ARABIC_FORM, n7, n9, n9 + 1);
                }
                n10 = n9++;
            }
        }
        return attributedString;
    }

    public static boolean arabicChar(char c) {
        return c >= '\u0600' && c <= '\u06ff';
    }

    public static boolean containsArabic(AttributedString attributedString) {
        return ArabicTextHandler.containsArabic(attributedString.getIterator());
    }

    public static boolean containsArabic(AttributedCharacterIterator attributedCharacterIterator) {
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            if (ArabicTextHandler.arabicChar(c)) {
                return true;
            }
            c = attributedCharacterIterator.next();
        }
        return false;
    }

    public static boolean arabicCharTransparent(char c) {
        char c2 = c;
        if (c2 < '\u064b' || c2 > '\u06ed') {
            return false;
        }
        return c2 <= '\u0655' || c2 == '\u0670' || c2 >= '\u06d6' && c2 <= '\u06e4' || c2 >= '\u06e7' && c2 <= '\u06e8' || c2 >= '\u06ea';
    }

    private static boolean arabicCharShapesRight(char c) {
        char c2 = c;
        return c2 >= '\u0622' && c2 <= '\u0625' || c2 == '\u0627' || c2 == '\u0629' || c2 >= '\u062f' && c2 <= '\u0632' || c2 == '\u0648' || c2 >= '\u0671' && c2 <= '\u0673' || c2 >= '\u0675' && c2 <= '\u0677' || c2 >= '\u0688' && c2 <= '\u0699' || c2 == '\u06c0' || c2 >= '\u06c2' && c2 <= '\u06cb' || c2 == '\u06cd' || c2 == '\u06cf' || c2 >= '\u06d2' && c2 <= '\u06d3' || ArabicTextHandler.arabicCharShapesDuel(c);
    }

    private static boolean arabicCharShapesDuel(char c) {
        char c2 = c;
        return c2 == '\u0626' || c2 == '\u0628' || c2 >= '\u062a' && c2 <= '\u062e' || c2 >= '\u0633' && c2 <= '\u063a' || c2 >= '\u0641' && c2 <= '\u0647' || c2 >= '\u0649' && c2 <= '\u064a' || c2 >= '\u0678' && c2 <= '\u0687' || c2 >= '\u069a' && c2 <= '\u06bf' || c2 == '\u06c1' || c2 == '\u06cc' || c2 == '\u06ce' || c2 >= '\u06d0' && c2 <= '\u06d1' || c2 >= '\u06fa' && c2 <= '\u06fc';
    }

    private static boolean arabicCharShapesLeft(char c) {
        return ArabicTextHandler.arabicCharShapesDuel(c);
    }

    private static boolean arabicCharShaped(char c) {
        return ArabicTextHandler.arabicCharShapesRight(c);
    }

    public static boolean hasSubstitute(char c, char c2) {
        if (c < doubleCharFirst || c > doubleCharLast) {
            return false;
        }
        int[][] nArray = doubleCharRemappings[c - doubleCharFirst];
        if (nArray == null) {
            return false;
        }
        for (int[] nArray2 : nArray) {
            if (nArray2[0] != c2) continue;
            return true;
        }
        return false;
    }

    public static int getSubstituteChar(char c, char c2, int n) {
        if (n == 0) {
            return -1;
        }
        if (c < doubleCharFirst || c > doubleCharLast) {
            return -1;
        }
        int[][] nArray = doubleCharRemappings[c - doubleCharFirst];
        if (nArray == null) {
            return -1;
        }
        for (int[] nArray2 : nArray) {
            if (nArray2[0] != c2) continue;
            return nArray2[n];
        }
        return -1;
    }

    public static int getSubstituteChar(char c, int n) {
        if (n == 0) {
            return -1;
        }
        if (c < singleCharFirst || c > singleCharLast) {
            return -1;
        }
        int[] nArray = singleCharRemappings[c - singleCharFirst];
        if (nArray == null) {
            return -1;
        }
        return nArray[n - 1];
    }

    public static String createSubstituteString(AttributedCharacterIterator attributedCharacterIterator) {
        int n = attributedCharacterIterator.getBeginIndex();
        int n2 = attributedCharacterIterator.getEndIndex();
        int n3 = n2 - n;
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i = n; i < n2; ++i) {
            char c;
            char c2 = attributedCharacterIterator.setIndex(i);
            if (!ArabicTextHandler.arabicChar(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            Integer n4 = (Integer)attributedCharacterIterator.getAttribute(ARABIC_FORM);
            if (ArabicTextHandler.charStartsLigature(c2) && i + 1 < n2) {
                c = attributedCharacterIterator.setIndex(i + 1);
                Integer n5 = (Integer)attributedCharacterIterator.getAttribute(ARABIC_FORM);
                if (n4 != null && n5 != null) {
                    int n6;
                    if (n4.equals(ARABIC_TERMINAL) && n5.equals(ARABIC_INITIAL)) {
                        n6 = ArabicTextHandler.getSubstituteChar(c2, c, ARABIC_ISOLATED);
                        if (n6 > -1) {
                            stringBuilder.append((char)n6);
                            ++i;
                            continue;
                        }
                    } else if (n4.equals(ARABIC_TERMINAL)) {
                        n6 = ArabicTextHandler.getSubstituteChar(c2, c, ARABIC_TERMINAL);
                        if (n6 > -1) {
                            stringBuilder.append((char)n6);
                            ++i;
                            continue;
                        }
                    } else if (n4.equals(ARABIC_MEDIAL) && n5.equals(ARABIC_MEDIAL) && (n6 = ArabicTextHandler.getSubstituteChar(c2, c, ARABIC_MEDIAL)) > -1) {
                        stringBuilder.append((char)n6);
                        ++i;
                        continue;
                    }
                }
            }
            if (n4 != null && n4 > 0 && (c = ArabicTextHandler.getSubstituteChar(c2, n4)) > '\uffffffff') {
                c2 = c;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static boolean charStartsLigature(char c) {
        char c2 = c;
        return c2 == '\u064b' || c2 == '\u064c' || c2 == '\u064d' || c2 == '\u064e' || c2 == '\u064f' || c2 == '\u0650' || c2 == '\u0651' || c2 == '\u0652' || c2 == '\u0622' || c2 == '\u0623' || c2 == '\u0625' || c2 == '\u0627';
    }

    public static int getNumChars(char c) {
        if (ArabicTextHandler.isLigature(c)) {
            return 2;
        }
        return 1;
    }

    public static boolean isLigature(char c) {
        char c2 = c;
        if (c2 < '\ufe70' || c2 > '\ufefc') {
            return false;
        }
        return c2 <= '\ufe72' || c2 == '\ufe74' || c2 >= '\ufe76' && c2 <= '\ufe7f' || c2 >= '\ufef5';
    }
}

