/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class AnimationShorthandSetter
extends ShorthandSetter {
    private StringBuilder layerBuffer = null;
    private StringBuilder miniLayerBuffer = null;
    private int layerCount = 0;
    private final ValueList lstDuration = ValueList.createCSValueList();
    private final ValueList lstTimingFunction = ValueList.createCSValueList();
    private final ValueList lstDelay = ValueList.createCSValueList();
    private final ValueList lstIterationCount = ValueList.createCSValueList();
    private final ValueList lstDirection = ValueList.createCSValueList();
    private final ValueList lstFillMode = ValueList.createCSValueList();
    private final ValueList lstPlayState = ValueList.createCSValueList();
    private final ValueList lstTimeline = ValueList.createCSValueList();
    private final ValueList lstName = ValueList.createCSValueList();

    AnimationShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "animation");
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        this.currentValue = lexicalUnit;
        this.setPriority(bl);
        this.countLayers(lexicalUnit);
    }

    void countLayers(LexicalUnit lexicalUnit) {
        this.layerCount = 0;
        int n = 0;
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (n <= 0) continue;
                ++this.layerCount;
                n = 0;
                continue;
            }
            ++n;
        }
        if (n > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    StringBuilder getValueItemBufferMini() {
        return this.miniLayerBuffer;
    }

    @Override
    public boolean assignSubproperties() {
        IdentifierValue identifierValue = new IdentifierValue("normal");
        identifierValue.setSubproperty(true);
        StyleValue styleValue = identifierValue;
        this.layerBuffer = new StringBuilder(64);
        this.miniLayerBuffer = new StringBuilder(64);
        String[] stringArray = this.getShorthandSubproperties();
        int n = 0;
        block0: while (n < this.layerCount && this.currentValue != null) {
            Object object;
            boolean bl = false;
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            Collections.addAll(hashSet, stringArray);
            while (this.currentValue != null) {
                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (!bl) break;
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    if (++n != this.layerCount) {
                        this.layerBuffer.append(',');
                        this.miniLayerBuffer.append(',');
                    }
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    break;
                }
                object = this.currentValue.getLexicalUnitType();
                if (object == LexicalUnit.LexicalType.INHERIT || object == LexicalUnit.LexicalType.INITIAL || object == LexicalUnit.LexicalType.UNSET || object == LexicalUnit.LexicalType.REVERT) {
                    StyleValue styleValue2 = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    if (this.layerCount != 1 || this.currentValue.getPreviousLexicalUnit() != null || this.currentValue.getNextLexicalUnit() != null) {
                        BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
                        if (baseCSSDeclarationRule != null) {
                            StyleDeclarationErrorHandler styleDeclarationErrorHandler = baseCSSDeclarationRule.getStyleDeclarationErrorHandler();
                            styleDeclarationErrorHandler.shorthandSyntaxError(this.getShorthandName(), "Keyword found mixed with other values.");
                        }
                        return false;
                    }
                    this.addSingleValueLayer(styleValue2);
                    this.appendValueItemString(styleValue2);
                    styleValue = styleValue2;
                    break block0;
                }
                if (this.assignLayerValue(hashSet)) {
                    bl = true;
                    continue;
                }
                this.reportUnknownValue(hashSet, this.currentValue);
                bl = false;
                break;
            }
            if (!bl) {
                this.layerBuffer.setLength(0);
                this.miniLayerBuffer.setLength(0);
                object = new StringBuilder(64);
                ((StringBuilder)object).append("Invalid layer found: ").append(n);
                if (this.currentValue != null) {
                    ((StringBuilder)object).append(' ').append(this.currentValue.toString());
                }
                this.reportDeclarationError("animation", ((StringBuilder)object).toString());
                return false;
            }
            if (hashSet.size() <= 0) continue;
            this.resetUnsetProperties(hashSet);
        }
        this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
        this.setListSubpropertyValue("animation-duration", this.lstDuration);
        this.setListSubpropertyValue("animation-timing-function", this.lstTimingFunction);
        this.setListSubpropertyValue("animation-delay", this.lstDelay);
        this.setListSubpropertyValue("animation-iteration-count", this.lstIterationCount);
        this.setListSubpropertyValue("animation-direction", this.lstDirection);
        this.setListSubpropertyValue("animation-fill-mode", this.lstFillMode);
        this.setListSubpropertyValue("animation-play-state", this.lstPlayState);
        this.setListSubpropertyValue("animation-timeline", this.lstTimeline);
        this.setListSubpropertyValue("animation-name", this.lstName);
        this.setSubpropertyValue("animation-range-start", styleValue);
        this.setSubpropertyValue("animation-range-end", styleValue);
        this.flush();
        return true;
    }

    private void addSingleValueLayer(StyleValue styleValue) {
        this.lstDuration.add(styleValue);
        this.lstTimingFunction.add(styleValue);
        this.lstDelay.add(styleValue);
        this.lstIterationCount.add(styleValue);
        this.lstDirection.add(styleValue);
        this.lstFillMode.add(styleValue);
        this.lstPlayState.add(styleValue);
        this.lstTimeline.add(styleValue);
        this.lstName.add(styleValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean assignLayerValue(Set<String> set) {
        short s = this.currentValue.getCssUnit();
        if (s == 90 || s == 91) {
            ValueList valueList;
            String string = "animation-duration";
            if (!set.contains(string)) {
                string = "animation-delay";
                if (!set.contains(string)) {
                    return false;
                }
                valueList = this.lstDelay;
            } else {
                valueList = this.lstDuration;
            }
            valueList.add(this.createCSSValue(string, this.currentValue));
            set.remove(string);
            this.nextCurrentValue();
            return true;
        } else {
            LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                int n = this.currentValue.getIntegerValue();
                if (n >= 0) return this.setIterationCountValue(set);
                return false;
            }
            if (lexicalType == LexicalUnit.LexicalType.REAL) {
                float f = this.currentValue.getFloatValue();
                if (!(f < 0.0f)) return this.setIterationCountValue(set);
                return false;
            }
            if (lexicalType == LexicalUnit.LexicalType.CUBIC_BEZIER_FUNCTION || lexicalType == LexicalUnit.LexicalType.STEPS_FUNCTION) {
                if (!set.contains("animation-timing-function")) {
                    return false;
                }
                this.lstTimingFunction.add(this.createCSSValue("animation-timing-function", this.currentValue));
                set.remove("animation-timing-function");
                this.nextCurrentValue();
                return true;
            } else if (lexicalType == LexicalUnit.LexicalType.FUNCTION) {
                if (!set.contains("animation-timeline") || !"scroll".equalsIgnoreCase(this.currentValue.getFunctionName()) && !"view".equalsIgnoreCase(this.currentValue.getFunctionName())) {
                    return false;
                }
                this.lstTimeline.add(this.createCSSValue("animation-timeline", this.currentValue));
                set.remove("animation-timeline");
                this.nextCurrentValue();
                return true;
            } else if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                if (set.contains("animation-timing-function") && this.testIdentifiers("transition-timing-function")) {
                    this.lstTimingFunction.add(this.createCSSValue("animation-timing-function", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-timing-function");
                    return true;
                } else if (set.contains("animation-iteration-count") && this.testIdentifiers("animation-iteration-count")) {
                    this.lstIterationCount.add(this.createCSSValue("animation-iteration-count", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-iteration-count");
                    return true;
                } else if (set.contains("animation-direction") && this.testIdentifiers("animation-direction")) {
                    this.lstDirection.add(this.createCSSValue("animation-direction", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-direction");
                    return true;
                } else if (set.contains("animation-fill-mode") && this.testIdentifiers("animation-fill-mode")) {
                    this.lstFillMode.add(this.createCSSValue("animation-fill-mode", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-fill-mode");
                    return true;
                } else if (set.contains("animation-play-state") && this.testIdentifiers("animation-play-state")) {
                    this.lstPlayState.add(this.createCSSValue("animation-play-state", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-play-state");
                    return true;
                } else if ("none".equalsIgnoreCase(this.currentValue.getStringValue())) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    return true;
                } else if (set.contains("animation-name") && !this.testIdentifiers("animation-timeline")) {
                    this.lstName.add(this.createCSSValue("animation-name", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-name");
                    return true;
                } else {
                    if (!set.contains("animation-timeline")) return false;
                    this.lstTimeline.add(this.createCSSValue("animation-timeline", this.currentValue));
                    this.nextCurrentValue();
                    set.remove("animation-timeline");
                }
                return true;
            } else {
                if (lexicalType != LexicalUnit.LexicalType.STRING) return false;
                if (!set.contains("animation-name")) {
                    return false;
                }
                this.lstName.add(this.createCSSValue("animation-name", this.currentValue));
                this.nextCurrentValue();
                set.remove("animation-name");
            }
        }
        return true;
    }

    private boolean setIterationCountValue(Set<String> set) {
        if (!set.contains("animation-iteration-count")) {
            return false;
        }
        this.lstIterationCount.add(this.createCSSValue("animation-iteration-count", this.currentValue));
        set.remove("animation-iteration-count");
        this.nextCurrentValue();
        return true;
    }

    private void reportUnknownValue(Set<String> set, LexicalUnit lexicalUnit) {
        BaseCSSDeclarationRule baseCSSDeclarationRule = this.styleDeclaration.getParentRule();
        if (baseCSSDeclarationRule != null) {
            StyleDeclarationErrorHandler styleDeclarationErrorHandler = baseCSSDeclarationRule.getStyleDeclarationErrorHandler();
            if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                styleDeclarationErrorHandler.unknownIdentifier("animation", lexicalUnit.getStringValue());
            } else {
                styleDeclarationErrorHandler.unassignedShorthandValues("animation", set.toArray(new String[0]), new LexicalUnit[]{lexicalUnit});
            }
        }
    }

    private void resetUnsetProperties(Set<String> set) {
        for (String string : set) {
            StyleValue styleValue = this.defaultPropertyValue(string);
            if ("animation-duration".equals(string)) {
                this.lstDuration.add(styleValue);
                continue;
            }
            if ("animation-timing-function".equals(string)) {
                this.lstTimingFunction.add(styleValue);
                continue;
            }
            if ("animation-delay".equals(string)) {
                this.lstDelay.add(styleValue);
                continue;
            }
            if ("animation-iteration-count".equals(string)) {
                this.lstIterationCount.add(styleValue);
                continue;
            }
            if ("animation-direction".equals(string)) {
                this.lstDirection.add(styleValue);
                continue;
            }
            if ("animation-fill-mode".equals(string)) {
                this.lstFillMode.add(styleValue);
                continue;
            }
            if ("animation-play-state".equals(string)) {
                this.lstPlayState.add(styleValue);
                continue;
            }
            if ("animation-timeline".equals(string)) {
                this.lstTimeline.add(styleValue);
                continue;
            }
            if (!"animation-name".equals(string)) continue;
            this.lstName.add(styleValue);
        }
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }
}

