/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.FontFace;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.FontFaceRule;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.echosvg.util.SVGConstants;
import java.util.LinkedList;
import java.util.List;

public class CSSFontFace
extends FontFace
implements SVGConstants {
    GVTFontFamily fontFamily = null;

    public CSSFontFace(List<Object> list, String string, float f, String string2, String string3, String string4, String string5, float f2, String string6, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        super(list, string, f, string2, string3, string4, string5, f2, string6, f3, f4, f5, f6, f7, f8, f9, f10);
    }

    protected CSSFontFace(String string) {
        super(string);
    }

    public static CSSFontFace createCSSFontFace(CSSEngine cSSEngine, FontFaceRule fontFaceRule) {
        StyleMap styleMap = fontFaceRule.getStyleMap();
        String string = CSSFontFace.getStringProp(styleMap, cSSEngine, 20);
        CSSFontFace cSSFontFace = new CSSFontFace(string);
        Value value = styleMap.getValue(26);
        if (value != null) {
            cSSFontFace.fontWeight = value.getCssText();
        }
        if ((value = styleMap.getValue(24)) != null) {
            cSSFontFace.fontStyle = value.getCssText();
        }
        if ((value = styleMap.getValue(25)) != null) {
            cSSFontFace.fontVariant = value.getCssText();
        }
        if ((value = styleMap.getValue(23)) != null) {
            cSSFontFace.fontStretch = value.getCssText();
        }
        value = styleMap.getValue(45);
        ParsedURL parsedURL = fontFaceRule.getURL();
        if (value != null && !value.isIdentifier("none")) {
            if (value.getCssValueType() == CSSValue.CssType.TYPED) {
                cSSFontFace.srcs = new LinkedList();
                cSSFontFace.srcs.add(CSSFontFace.getSrcValue(value, parsedURL));
            } else if (value.getCssValueType() == CSSValue.CssType.LIST) {
                cSSFontFace.srcs = new LinkedList();
                for (int i = 0; i < value.getLength(); ++i) {
                    cSSFontFace.srcs.add(CSSFontFace.getSrcValue(value.item(i), parsedURL));
                }
            }
        }
        return cSSFontFace;
    }

    public static Object getSrcValue(Value value, ParsedURL parsedURL) {
        if (value.getPrimitiveType() == CSSValue.Type.URI) {
            if (parsedURL != null) {
                return new ParsedURL(parsedURL, value.getURIValue());
            }
            return new ParsedURL(value.getURIValue());
        }
        if (value.getPrimitiveType() == CSSValue.Type.STRING) {
            return value.getStringValue();
        }
        return null;
    }

    public static String getStringProp(StyleMap styleMap, CSSEngine cSSEngine, int n) {
        Value value = styleMap.getValue(n);
        ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
        if (value == null) {
            ValueManager valueManager = valueManagerArray[n];
            value = valueManager.getDefaultValue();
        }
        while (value.getCssValueType() == CSSValue.CssType.LIST) {
            value = value.item(0);
        }
        return value.getStringValue();
    }

    public static float getFloatProp(StyleMap styleMap, CSSEngine cSSEngine, int n) {
        Value value = styleMap.getValue(n);
        ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
        if (value == null) {
            ValueManager valueManager = valueManagerArray[n];
            value = valueManager.getDefaultValue();
        }
        while (value.getCssValueType() == CSSValue.CssType.LIST) {
            value = value.item(0);
        }
        return value.getFloatValue();
    }

    @Override
    public GVTFontFamily getFontFamily(BridgeContext bridgeContext) {
        if (this.fontFamily != null) {
            return this.fontFamily;
        }
        this.fontFamily = super.getFontFamily(bridgeContext);
        return this.fontFamily;
    }
}

