/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.DirectionalityHelper;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.LangCondition;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.PseudoCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.Specificity;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class AbstractSelectorMatcher
implements SelectorMatcher,
Serializable {
    private static final long serialVersionUID = 2L;
    private String localName = null;
    private Condition pseudoElt = null;

    public String getLocalName() {
        return this.localName;
    }

    protected void setLocalName(String string) {
        this.localName = string;
    }

    protected String getClassAttribute(CSSDocument.ComplianceMode complianceMode) {
        String string = this.getAttributeValue("class");
        if (complianceMode != CSSDocument.ComplianceMode.STRICT) {
            if (string.length() == 0 && (string = this.getAttributeValue("CLASS")).length() == 0) {
                string = this.getAttributeValue("Class");
            }
            if (string.length() != 0) {
                string = string.toLowerCase(Locale.ROOT);
            }
        }
        return string;
    }

    @Override
    public Condition getPseudoElement() {
        return this.pseudoElt;
    }

    @Override
    public void setPseudoElement(Condition condition) {
        this.pseudoElt = condition;
    }

    protected boolean isActivePseudoClass(String string) {
        return false;
    }

    @Override
    public int matches(SelectorList selectorList) {
        int n = selectorList.getLength();
        Specificity specificity = null;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Selector selector = selectorList.item(i);
            if (!this.matches(selector)) continue;
            Specificity specificity2 = new Specificity(selector, this);
            if (specificity != null && Specificity.selectorCompare(specificity, specificity2) >= 0) continue;
            specificity = specificity2;
            n2 = i;
        }
        return n2;
    }

    @Override
    public boolean matches(Selector selector) {
        switch (selector.getSelectorType()) {
            case ELEMENT: {
                String string = ((ElementSelector)selector).getLocalName();
                String string2 = ((ElementSelector)selector).getNamespaceURI();
                if (string2 == null || string2.equals(this.getNamespaceURI())) {
                    return string == null || this.localName.equalsIgnoreCase(string) || string.equals("*");
                }
                if (string2.length() != 0 || this.getNamespaceURI() != null) break;
                return true;
            }
            case CONDITIONAL: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                return this.matchCondition(conditionalSelector.getCondition(), conditionalSelector.getSimpleSelector());
            }
            case UNIVERSAL: 
            case SCOPE_MARKER: {
                return true;
            }
            case CHILD: {
                SimpleSelector simpleSelector = ((CombinatorSelector)selector).getSecondSelector();
                if (!this.matches(simpleSelector)) break;
                Selector selector2 = ((CombinatorSelector)selector).getSelector();
                AbstractSelectorMatcher abstractSelectorMatcher = this.getParentSelectorMatcher();
                if (abstractSelectorMatcher == null || !abstractSelectorMatcher.matches(selector2)) break;
                return true;
            }
            case DESCENDANT: {
                SimpleSelector simpleSelector = ((CombinatorSelector)selector).getSecondSelector();
                if (!this.matches(simpleSelector)) break;
                Selector selector3 = ((CombinatorSelector)selector).getSelector();
                for (AbstractSelectorMatcher abstractSelectorMatcher = this.getParentSelectorMatcher(); abstractSelectorMatcher != null; abstractSelectorMatcher = abstractSelectorMatcher.getParentSelectorMatcher()) {
                    if (!abstractSelectorMatcher.matches(selector3)) continue;
                    return true;
                }
                break;
            }
            case DIRECT_ADJACENT: {
                if (!this.matches(((CombinatorSelector)selector).getSecondSelector())) break;
                Selector selector4 = ((CombinatorSelector)selector).getSelector();
                AbstractSelectorMatcher abstractSelectorMatcher = this.getPreviousSiblingSelectorMatcher();
                return abstractSelectorMatcher != null && abstractSelectorMatcher.matches(selector4);
            }
            case SUBSEQUENT_SIBLING: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                if (!this.matches(combinatorSelector.getSecondSelector())) break;
                Selector selector5 = combinatorSelector.getSelector();
                for (AbstractSelectorMatcher abstractSelectorMatcher = this.getPreviousSiblingSelectorMatcher(); abstractSelectorMatcher != null; abstractSelectorMatcher = abstractSelectorMatcher.getPreviousSiblingSelectorMatcher()) {
                    if (!abstractSelectorMatcher.matches(selector5)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean matchCondition(Condition condition, SimpleSelector simpleSelector) {
        switch (condition.getConditionType()) {
            case CLASS: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                String string = attributeCondition.getValue();
                return this.matchesClass(string) && this.matches(simpleSelector);
            }
            case ID: {
                return this.matchesId(((AttributeCondition)condition).getValue()) && this.matches(simpleSelector);
            }
            case ATTRIBUTE: {
                return this.matchesAttribute((AttributeCondition)condition, simpleSelector);
            }
            case ONE_OF_ATTRIBUTE: {
                return this.matchesOneOfAttribute((AttributeCondition)condition, simpleSelector);
            }
            case BEGIN_HYPHEN_ATTRIBUTE: {
                return this.matchesBeginHyphenAttribute((AttributeCondition)condition, simpleSelector);
            }
            case BEGINS_ATTRIBUTE: {
                return this.matchesBeginsAttribute((AttributeCondition)condition, simpleSelector);
            }
            case ENDS_ATTRIBUTE: {
                return this.matchesEndsAttribute((AttributeCondition)condition, simpleSelector);
            }
            case SUBSTRING_ATTRIBUTE: {
                return this.matchesSubstringAttribute((AttributeCondition)condition, simpleSelector);
            }
            case LANG: {
                return this.matchesLang((LangCondition)condition, simpleSelector);
            }
            case PSEUDO_CLASS: {
                if (!this.matches(simpleSelector)) break;
                PseudoCondition pseudoCondition = (PseudoCondition)condition;
                String string = pseudoCondition.getName();
                if ("only-child".equals(string = string.toLowerCase(Locale.ROOT).intern())) {
                    return this.isOnlyChild();
                }
                if ("only-of-type".equals(string)) {
                    return this.isOnlyOfType();
                }
                if ("any-link".equals(string)) {
                    return this.isAnyLink();
                }
                if ("link".equals(string)) {
                    return this.isNotVisitedLink();
                }
                if ("visited".equals(string)) {
                    return this.isVisitedLink();
                }
                if ("target".equals(string)) {
                    return this.isTarget();
                }
                if ("root".equals(string)) {
                    return this.isRoot();
                }
                if ("empty".equals(string)) {
                    return this.isEmpty();
                }
                if ("blank".equals(string)) {
                    return this.isBlank();
                }
                if ("disabled".equals(string)) {
                    return this.isDisabled();
                }
                if ("enabled".equals(string)) {
                    return this.isEnabled();
                }
                if ("read-write".equals(string)) {
                    return this.isReadWrite();
                }
                if ("read-only".equals(string)) {
                    return !this.isReadWrite();
                }
                if ("placeholder-shown".equals(string)) {
                    return this.isPlaceholderShown();
                }
                if ("default".equals(string)) {
                    return this.isUIDefault();
                }
                if ("checked".equals(string)) {
                    return this.isChecked();
                }
                if ("indeterminate".equals(string)) {
                    return this.isIndeterminate();
                }
                if ("dir".equals(string)) {
                    return this.isDir(pseudoCondition.getArgument());
                }
                return this.isActivePseudoClass(string);
            }
            case PSEUDO_ELEMENT: {
                return this.matches(simpleSelector) && this.matchesPseudoelement((PseudoCondition)condition);
            }
            case AND: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return this.matchCondition(combinatorCondition.getFirstCondition(), simpleSelector) && this.matchCondition(combinatorCondition.getSecondCondition(), simpleSelector);
            }
            case ONLY_CHILD: {
                return this.matches(simpleSelector) && this.isOnlyChild();
            }
            case ONLY_TYPE: {
                return this.matches(simpleSelector) && this.isOnlyOfType();
            }
            case POSITIONAL: {
                return this.matches(simpleSelector) && this.matchesPositional((PositionalCondition)condition);
            }
            case SELECTOR_ARGUMENT: {
                return this.matches(simpleSelector) && this.matchesArgument((ArgumentCondition)condition, simpleSelector);
            }
        }
        return false;
    }

    protected boolean matchesId(String string) {
        CSSDocument.ComplianceMode complianceMode = this.getComplianceMode();
        String string2 = this.getId();
        if (complianceMode != CSSDocument.ComplianceMode.STRICT) {
            if (string2.length() == 0) {
                string2 = this.getQuirksId();
            }
            return string2.equalsIgnoreCase(string);
        }
        return string2.equals(string);
    }

    private String getQuirksId() {
        String string = this.getAttributeValue("id");
        if (string.length() == 0 && (string = this.getAttributeValue("ID")).length() == 0) {
            string = this.getAttributeValue("Id");
        }
        return string;
    }

    private boolean matchesClass(String string) {
        CSSDocument.ComplianceMode complianceMode = this.getComplianceMode();
        String string2 = this.getClassAttribute(complianceMode);
        if (!DOMTokenSetImpl.checkMultipleToken(string2)) {
            string2 = string2.trim();
            if (complianceMode != CSSDocument.ComplianceMode.STRICT) {
                return string2.equalsIgnoreCase(string);
            }
            return string2.equals(string);
        }
        if (complianceMode != CSSDocument.ComplianceMode.STRICT) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesAttribute(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        String string = attributeCondition.getLocalName();
        if (this.hasAttribute(string) && this.matches(simpleSelector)) {
            String string2 = attributeCondition.getValue();
            if (string2 != null) {
                String string3 = this.getAttributeValue(string);
                if (attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I)) {
                    return string3.equalsIgnoreCase(string2);
                }
                return string3.equals(string2);
            }
            return true;
        }
        return false;
    }

    private boolean matchesOneOfAttribute(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        block4: {
            String string = attributeCondition.getLocalName();
            if (!this.hasAttribute(string) || !this.matches(simpleSelector)) break block4;
            boolean bl = attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I);
            String string2 = attributeCondition.getValue();
            String string3 = this.getAttributeValue(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            if (bl) {
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!string4.equalsIgnoreCase(string2)) continue;
                    return true;
                }
            } else {
                while (stringTokenizer.hasMoreElements()) {
                    String string5 = stringTokenizer.nextToken();
                    if (!string5.equals(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesBeginHyphenAttribute(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        String string = attributeCondition.getLocalName();
        if (this.hasAttribute(string) && this.matches(simpleSelector)) {
            String string2 = this.getAttributeValue(string);
            int n = string2.length();
            String string3 = attributeCondition.getValue();
            int n2 = string3.length();
            boolean bl = attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I);
            if (n2 == n) {
                return bl ? string2.equalsIgnoreCase(string3) : string2.equals(string3);
            }
            if (n2 < n) {
                return string2.regionMatches(bl, 0, string3, 0, n2) && string2.charAt(n2) == '-';
            }
        }
        return false;
    }

    private boolean matchesBeginsAttribute(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        String string = attributeCondition.getLocalName();
        if (this.hasAttribute(string)) {
            String string2 = this.getAttributeValue(string);
            if (this.matches(simpleSelector)) {
                boolean bl = attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I);
                String string3 = attributeCondition.getValue();
                return string2.regionMatches(bl, 0, string3, 0, string3.length());
            }
        }
        return false;
    }

    private boolean matchesEndsAttribute(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        String string = attributeCondition.getLocalName();
        if (this.hasAttribute(string)) {
            String string2 = this.getAttributeValue(string);
            if (this.matches(simpleSelector)) {
                boolean bl = attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I);
                String string3 = attributeCondition.getValue();
                int n = string2.length();
                int n2 = string3.length();
                return string2.regionMatches(bl, n - n2, string3, 0, n2);
            }
        }
        return false;
    }

    private boolean matchesSubstringAttribute(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        String string = attributeCondition.getLocalName();
        if (this.hasAttribute(string) && this.matches(simpleSelector)) {
            int n;
            String string2 = this.getAttributeValue(string);
            boolean bl = attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I);
            String string3 = attributeCondition.getValue();
            if (!bl) {
                return string2.contains(string3);
            }
            int n2 = string2.length();
            int n3 = n2 - (n = string3.length());
            if (n3 >= 0) {
                for (int i = 0; i <= n3; ++i) {
                    if (!string2.regionMatches(bl, i, string3, 0, n)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesLang(LangCondition langCondition, SimpleSelector simpleSelector) {
        String[] stringArray;
        if (!this.matches(simpleSelector)) {
            return false;
        }
        String string = this.getLanguage();
        String string2 = langCondition.getLang();
        if (string2.indexOf(44) == -1) {
            return this.matchesLangSpec(string2, string);
        }
        for (String string3 : stringArray = string2.split(",")) {
            if ((string3 = string3.trim()).length() == 0 || !this.matchesLangSpec(string3, string)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesLangSpec(String string, String string2) {
        int n;
        char c = string.charAt(0);
        if (c == '\'') {
            int n2 = string.length();
            if (string.charAt(n2 - 1) == '\'') {
                string = string.substring(1, n2 - 1);
            }
        } else if (c == '\"' && string.charAt((n = string.length()) - 1) == '\"') {
            string = string.substring(1, n - 1);
        }
        if (string.indexOf(42) == -1) {
            return string2.startsWith(string);
        }
        return this.matchesLangRange(string, string2);
    }

    private boolean matchesLangRange(String string, String string2) {
        if ((string = string.replaceAll("\\*", ".*")).charAt(string.length() - 1) != '*') {
            string = string + ".*";
        }
        return string2.matches(string);
    }

    protected boolean isDir(String string) {
        if (string != null) {
            DirectionalityHelper.Directionality directionality = this.getDirectionality();
            if ("rtl".equalsIgnoreCase(string)) {
                return directionality == DirectionalityHelper.Directionality.RTL;
            }
            if ("ltr".equalsIgnoreCase(string)) {
                return directionality == DirectionalityHelper.Directionality.LTR;
            }
        }
        return false;
    }

    private boolean matchesPositional(PositionalCondition positionalCondition) {
        int n = positionalCondition.getOffset();
        int n2 = positionalCondition.getFactor();
        if (positionalCondition.isOfType()) {
            if (positionalCondition.isForwardCondition()) {
                return this.isNthOfType(n2, n);
            }
            return this.isNthLastOfType(n2, n);
        }
        int n3 = positionalCondition.isForwardCondition() ? this.indexOf(positionalCondition.getOfList()) : this.reverseIndexOf(positionalCondition.getOfList());
        if (n3 == -1) {
            return false;
        }
        return n2 == 0 ? n3 == 0 : Math.floorMod(n3 -= n, n2) == 0;
    }

    private boolean matchesPseudoelement(PseudoCondition pseudoCondition) {
        Condition condition = this.getPseudoElement();
        if (condition != null) {
            if (condition.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT) {
                return pseudoCondition.getName().equals(((PseudoCondition)condition).getName());
            }
            if (condition.getConditionType() == Condition.ConditionType.AND) {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return pseudoCondition.getName().equals(((PseudoCondition)combinatorCondition.getFirstCondition()).getName()) || pseudoCondition.getName().equals(((PseudoCondition)combinatorCondition.getSecondCondition()).getName());
            }
        }
        return false;
    }

    private boolean matchesArgument(ArgumentCondition argumentCondition, SimpleSelector simpleSelector) {
        String string = argumentCondition.getName();
        SelectorList selectorList = argumentCondition.getSelectors();
        if ("not".equals(string)) {
            for (int i = 0; i < selectorList.getLength(); ++i) {
                if (!this.matches(selectorList.item(i))) continue;
                return false;
            }
            return true;
        }
        if ("has".equals(string)) {
            for (int i = 0; i < selectorList.getLength(); ++i) {
                if (!this.scopeMatch(selectorList.item(i), simpleSelector)) continue;
                return true;
            }
            return false;
        }
        if ("is".equals(string) || "where".equals(string)) {
            return this.matches(selectorList) >= 0;
        }
        return false;
    }

    private boolean scopeMatch(Selector selector, SimpleSelector simpleSelector) {
        switch (selector.getSelectorType()) {
            case ELEMENT: 
            case CONDITIONAL: {
                return this.scopeMatch(new CombinatorSelectorImpl(simpleSelector, (SimpleSelector)selector), simpleSelector);
            }
            case CHILD: 
            case DESCENDANT: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                if (combinatorSelector.getSelector().getSelectorType() == Selector.SelectorType.SCOPE_MARKER) {
                    return this.scopeMatchChild(combinatorSelector);
                }
                return this.scopeMatchDescendant(combinatorSelector);
            }
            case DIRECT_ADJACENT: 
            case SUBSEQUENT_SIBLING: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                if (combinatorSelector.getSelector().getSelectorType() == Selector.SelectorType.SCOPE_MARKER) {
                    return this.scopeMatchDirectAdjacent(combinatorSelector);
                }
                return this.scopeMatchDescendant(combinatorSelector);
            }
        }
        return false;
    }

    protected boolean isChecked() {
        String string = this.getLocalName();
        if ("input".equals(string)) {
            String string2 = this.getAttributeValue("type");
            return ("checkbox".equalsIgnoreCase(string2) || "radio".equalsIgnoreCase(string2)) && this.hasAttribute("checked");
        }
        if ("option".equals(string)) {
            return this.hasAttribute("selected");
        }
        return false;
    }

    protected boolean isEnabled() {
        return this.isFormElement() && !this.isDisabled();
    }

    protected boolean isFormElement() {
        String string = this.getLocalName();
        return string.equals("input") || string.equals("button") || string.equals("select") || string.equals("optgroup") || string.equals("option") || string.equals("textarea") || string.equals("keygen") || string.equals("fieldset");
    }

    protected boolean isIndeterminate() {
        String string = this.getAttributeValue("indeterminate");
        return string.length() != 0 && !string.equalsIgnoreCase("false");
    }

    protected boolean isAnyLink() {
        String string = this.getLinkHrefAttribute();
        return string.length() != 0;
    }

    protected boolean isNotVisitedLink() {
        String string = this.getLinkHrefAttribute();
        if (string.length() != 0) {
            return !this.isVisitedURI(string);
        }
        return false;
    }

    protected boolean isVisitedLink() {
        String string = this.getLinkHrefAttribute();
        if (string.length() != 0) {
            return this.isVisitedURI(string);
        }
        return false;
    }

    private String getLinkHrefAttribute() {
        String string = this.getAttributeValue("href");
        if (string.length() == 0 || !"a".equals(this.localName) && !"link".equals(this.localName) && !"area".equals(this.localName)) {
            string = this.getAttributeValue("xlink:href");
        }
        return string;
    }

    protected boolean isOnlyChild() {
        return this.isFirstChild() && this.isLastChild();
    }

    protected boolean isOnlyOfType() {
        return this.isFirstOfType() && this.isLastOfType();
    }

    protected boolean isPlaceholderShown() {
        return this.hasAttribute("placeholder");
    }

    protected boolean isReadWrite() {
        if ("true".equalsIgnoreCase(this.getAttributeValue("contenteditable"))) {
            return true;
        }
        return this.isEnabled();
    }

    protected boolean isUIDefault() {
        String string = this.getLocalName();
        if ("button".equals(string)) {
            return "submit".equalsIgnoreCase(this.getAttributeValue("type")) && this.isDefaultButton();
        }
        if ("option".equals(string)) {
            return this.hasAttribute("selected");
        }
        if ("input".equals(string)) {
            if (this.hasAttribute("checked")) {
                return true;
            }
            String string2 = this.getAttributeValue("type").toLowerCase(Locale.ROOT);
            if ("submit".equals(string2) || "image".equals(string2)) {
                return this.isDefaultButton();
            }
        }
        return false;
    }

    protected abstract CSSDocument.ComplianceMode getComplianceMode();

    protected abstract String getNamespaceURI();

    protected abstract boolean scopeMatchChild(CombinatorSelector var1);

    protected abstract boolean scopeMatchDescendant(CombinatorSelector var1);

    protected abstract boolean scopeMatchDirectAdjacent(CombinatorSelector var1);

    protected abstract AbstractSelectorMatcher getParentSelectorMatcher();

    protected abstract AbstractSelectorMatcher getPreviousSiblingSelectorMatcher();

    protected abstract String getAttributeValue(String var1);

    protected abstract boolean hasAttribute(String var1);

    protected abstract String getId();

    protected abstract String getLanguage();

    protected abstract DirectionalityHelper.Directionality getDirectionality();

    protected abstract boolean isFirstChild();

    protected abstract boolean isLastChild();

    protected abstract boolean isFirstOfType();

    protected abstract boolean isLastOfType();

    protected abstract int indexOf(SelectorList var1);

    protected abstract int reverseIndexOf(SelectorList var1);

    protected abstract boolean isNthOfType(int var1, int var2);

    protected abstract boolean isNthLastOfType(int var1, int var2);

    protected abstract boolean isTarget();

    protected abstract boolean isRoot();

    protected abstract boolean isEmpty();

    protected abstract boolean isBlank();

    protected abstract boolean isDisabled();

    protected abstract boolean isDefaultButton();

    protected abstract boolean isVisitedURI(String var1);

    public static void findStatePseudoClasses(Selector selector, List<String> list) {
        switch (selector.getSelectorType()) {
            case CONDITIONAL: {
                Condition condition = ((ConditionalSelector)selector).getCondition();
                if (condition.getConditionType() == Condition.ConditionType.PSEUDO_CLASS) {
                    String string = ((PseudoCondition)condition).getName();
                    int n = string.indexOf(40);
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    if ((string = string.toLowerCase(Locale.ROOT).intern()) != "first-child" && string != "last-child" && string != "only-child" && string != "any-link" && string != "link" && string != "visited" && string != "target" && string != "root" && string != "empty" && string != "blank" && string != "is" && string != "not" && string != "has" && string != "dir" && string != "lang" && string != "scope" && string != "empty" && string != "blank" && string != "valid" && string != "invalid" && string != "in-range" && string != "out-of-range" && string != "required" && string != "optional" && string != "user-invalid" && string != "nth-child" && string != "nth-last-child" && string != "nth-of-type" && string != "nth-last-of-type" && string != "disabled" && string != "enabled" && string != "read-write" && string != "read-only" && string != "placeholder-shown" && string != "default" && string != "checked" && string != "indeterminate" && string != "nth-col" && string != "nth-last-col") {
                        list.add(string);
                        break;
                    }
                }
                AbstractSelectorMatcher.findStatePseudoClasses(((ConditionalSelector)selector).getSimpleSelector(), list);
                break;
            }
            case CHILD: 
            case DESCENDANT: {
                AbstractSelectorMatcher.findStatePseudoClasses(((CombinatorSelector)selector).getSecondSelector(), list);
                AbstractSelectorMatcher.findStatePseudoClasses(((CombinatorSelector)selector).getSelector(), list);
                break;
            }
            case DIRECT_ADJACENT: {
                AbstractSelectorMatcher.findStatePseudoClasses(((CombinatorSelector)selector).getSecondSelector(), list);
            }
        }
    }

    public String toString() {
        CSSDocument.ComplianceMode complianceMode;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        AbstractSelectorMatcher abstractSelectorMatcher = this.getParentSelectorMatcher();
        if (abstractSelectorMatcher != null) {
            stringBuilder.append(abstractSelectorMatcher.getLocalName()).append(' ').append('>').append(' ');
        }
        if (this.localName != null) {
            stringBuilder.append(this.localName);
        }
        if ((string = this.getClassAttribute(complianceMode = this.getComplianceMode())).length() != 0) {
            stringBuilder.append('.').append(string);
        } else if (this.getId().length() != 0) {
            stringBuilder.append('#').append(this.getId());
        }
        if (this.pseudoElt != null) {
            stringBuilder.append(':').append(this.pseudoElt);
        }
        return stringBuilder.toString();
    }

    private static class CombinatorSelectorImpl
    implements CombinatorSelector {
        SimpleSelector simpleSelector;
        Selector scope;

        CombinatorSelectorImpl(Selector selector, SimpleSelector simpleSelector) {
            this.scope = selector;
            this.simpleSelector = simpleSelector;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.DESCENDANT;
        }

        @Override
        public Selector getSelector() {
            return this.scope;
        }

        @Override
        public SimpleSelector getSecondSelector() {
            return this.simpleSelector;
        }
    }
}

