/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGColorManager;
import org.w3c.dom.DOMException;

public class SVGPaintManager
extends SVGColorManager {
    public SVGPaintManager(String string) {
        super(string);
    }

    public SVGPaintManager(String string, Value value) {
        super(string, value);
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 7;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
            }
            default: {
                return super.createValue(lexicalUnit, cSSEngine);
            }
            case URI: 
        }
        String string = lexicalUnit.getStringValue();
        String string2 = SVGPaintManager.resolveURI(cSSEngine.getCSSBaseURI(), string);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        if (lexicalUnit == null) {
            return new URIValue(string, string2);
        }
        ListValue listValue = new ListValue(' ');
        listValue.append(new URIValue(string, string2));
        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
            listValue.append(ValueConstants.NONE_VALUE);
            return listValue;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if (value instanceof ListValue) {
            for (int i = 0; i < value.getLength(); ++i) {
                listValue.append(value.item(i));
            }
        } else {
            listValue.append(value);
        }
        return listValue;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        Value value2;
        if (value.isIdentifier("none")) {
            return value;
        }
        if (value.getCssValueType() == CSSValue.CssType.LIST && (value2 = value.item(0)).getPrimitiveType() == CSSValue.Type.URI) {
            if (styleMap.isAttrTainted(n)) {
                CSSEngineUserAgent cSSEngineUserAgent = cSSEngine.getCSSEngineUserAgent();
                if (cSSEngineUserAgent != null) {
                    cSSEngineUserAgent.displayMessage("attr()-tainted value: " + value.getCssText());
                }
                return null;
            }
            value2 = value.item(1);
            if (value2 == null || value2.isIdentifier("none")) {
                return value;
            }
            Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue = new ListValue(' ');
                listValue.append(value.item(0));
                listValue.append(value3);
                if (value.getLength() == 3) {
                    listValue.append(value.item(1));
                }
                return listValue;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }
}

