/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.BaseProfiledColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.jclf.math.linear3.Matrices;
import java.util.Arrays;
import java.util.Objects;

class ProfiledColorImpl
extends BaseProfiledColor {
    private static final long serialVersionUID = 1L;
    private ColorProfile profile;

    ProfiledColorImpl(String string, ColorProfile colorProfile, double[] dArray) {
        super(string, new PrimitiveValue[dArray.length]);
        this.profile = colorProfile;
        this.setColorComponents(dArray);
    }

    ProfiledColorImpl(ProfiledColorImpl profiledColorImpl) {
        super(profiledColorImpl);
        this.profile = profiledColorImpl.profile;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        this.profile = ((ProfiledColorImpl)baseColor).profile;
    }

    @Override
    public double[] toXYZ(Illuminant illuminant) {
        double[] dArray = this.toNumberArray();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.profile.linearComponent(dArray[i]);
        }
        double[] dArray2 = new double[3];
        this.profile.linearRgbToXYZ(dArray[0], dArray[1], dArray[2], dArray2);
        if (illuminant != this.profile.getIlluminant()) {
            dArray2 = illuminant == Illuminant.D50 ? ColorUtil.d65xyzToD50(dArray2) : ColorUtil.d50xyzToD65(dArray2);
        }
        return dArray2;
    }

    @Override
    public double[] toXYZ(double[] dArray) {
        double[] dArray2 = this.toNumberArray();
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = this.profile.linearComponent(dArray2[i]);
        }
        double[] dArray3 = new double[3];
        this.profile.linearRgbToXYZ(dArray2, dArray3);
        double[] dArray4 = this.profile.getWhitePoint();
        if (!Arrays.equals(dArray4, dArray)) {
            double[][] dArray5 = new double[3][3];
            ChromaticAdaption.chromaticAdaptionMatrix(dArray4, dArray, dArray5);
            double[] dArray6 = new double[3];
            Matrices.multiplyByVector3((double[][])dArray5, (double[])dArray3, (double[])dArray6);
            dArray3 = dArray6;
        }
        return dArray3;
    }

    @Override
    double[] toSRGB(boolean bl) {
        double[] dArray = this.toXYZ(Illuminant.D65);
        double[] dArray2 = new double[3];
        ColorUtil.d65xyzToSRGB(dArray, dArray2);
        if (!ColorUtil.rangeRoundCheck(dArray2) && bl) {
            double[] dArray3 = ColorUtil.d65xyzToD50(dArray);
            double[] dArray4 = new double[3];
            ColorUtil.xyzD50ToLab(dArray3, dArray4);
            SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
            ColorUtil.clampRGB(dArray4[0], dArray4[1], dArray4[2], sRGBColorProfile, dArray2);
        }
        return dArray2;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(this.profile);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProfiledColorImpl profiledColorImpl = (ProfiledColorImpl)object;
        return Objects.equals(this.profile, profiledColorImpl.profile);
    }

    @Override
    public ProfiledColorImpl clone() {
        return new ProfiledColorImpl(this);
    }
}

