/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.NumberFormat;
import io.sf.jclf.text.format.ObjectFormat;
import java.util.Random;

public class IntegerFormat
extends NumberFormat {
    public IntegerFormat() {
        this.precision = 1;
    }

    @Override
    public String format(Object object) {
        if (!(object instanceof Integer || object instanceof Long || object instanceof Short)) {
            throw new IllegalArgumentException("Object must be an Integer, Short or Long");
        }
        StringBuilder stringBuilder = new StringBuilder(14);
        String string = object.toString();
        if (this.precision != 0 || !string.equals("0")) {
            if (this.signpre && string.charAt(0) != '-') {
                this.rightAppend(stringBuilder, '+' + string, '0', this.precision, 0);
            } else {
                this.rightAppend(stringBuilder, string, '0', this.precision, 0);
            }
        }
        if (this.width > 0) {
            if (this.ralign) {
                char c = ' ';
                if (this.zeropadding) {
                    c = '0';
                }
                return ObjectFormat.rightJustify(stringBuilder.toString(), c, this.width, '%');
            }
            return ObjectFormat.leftJustify(stringBuilder.toString(), ' ', this.width, '%');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.ralign) {
            stringBuilder.append('-');
        }
        if (this.width != 0) {
            stringBuilder.append(this.width);
        }
        if (this.precision > 0 && this.precision != this.width) {
            stringBuilder.append('.').append(this.precision);
        }
        stringBuilder.append('d');
        return stringBuilder.toString();
    }

    @Override
    public Object sample() {
        return new Random().nextInt();
    }
}

