/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class ColorMatrixRed
extends AbstractRed {
    private float[][] matrix;

    public float[][] getMatrix() {
        return this.copyMatrix(this.matrix);
    }

    public void setMatrix(float[][] fArray) {
        float[][] fArray2 = this.copyMatrix(fArray);
        if (fArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (fArray2.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 4; ++i) {
            if (fArray2[i].length == 5) continue;
            throw new IllegalArgumentException(String.valueOf(i) + " : " + fArray2[i].length);
        }
        this.matrix = fArray;
    }

    private float[][] copyMatrix(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            fArrayArray[i] = new float[fArray[i].length];
            System.arraycopy(fArray[i], 0, fArrayArray[i], 0, fArray[i].length);
        }
        return fArrayArray;
    }

    public ColorMatrixRed(CachableRed cachableRed, float[][] fArray) {
        this.setMatrix(fArray);
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = null;
        if (colorModel != null) {
            colorSpace = colorModel.getColorSpace();
        }
        ColorModel colorModel2 = colorSpace == null ? GraphicsUtil.Linear_sRGB_Unpre : (colorSpace == ColorSpace.getInstance(1004) ? GraphicsUtil.Linear_sRGB_Unpre : GraphicsUtil.sRGB_Unpre);
        SampleModel sampleModel = colorModel2.createCompatibleSampleModel(cachableRed.getWidth(), cachableRed.getHeight());
        this.init(cachableRed, cachableRed.getBounds(), colorModel2, sampleModel, cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        writableRaster = cachableRed.copyData(writableRaster);
        ColorModel colorModel = cachableRed.getColorModel();
        GraphicsUtil.coerceData(writableRaster, colorModel, false);
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n5 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n - writableRaster.getSampleModelTranslateX(), n2 - writableRaster.getSampleModelTranslateY());
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        int n8 = n5;
        int n9 = 0;
        int n10 = 0;
        float f = this.matrix[0][0] / 255.0f;
        float f2 = this.matrix[0][1] / 255.0f;
        float f3 = this.matrix[0][2] / 255.0f;
        float f4 = this.matrix[0][3] / 255.0f;
        float f5 = this.matrix[0][4] / 255.0f;
        float f6 = this.matrix[1][0] / 255.0f;
        float f7 = this.matrix[1][1] / 255.0f;
        float f8 = this.matrix[1][2] / 255.0f;
        float f9 = this.matrix[1][3] / 255.0f;
        float f10 = this.matrix[1][4] / 255.0f;
        float f11 = this.matrix[2][0] / 255.0f;
        float f12 = this.matrix[2][1] / 255.0f;
        float f13 = this.matrix[2][2] / 255.0f;
        float f14 = this.matrix[2][3] / 255.0f;
        float f15 = this.matrix[2][4] / 255.0f;
        float f16 = this.matrix[3][0] / 255.0f;
        float f17 = this.matrix[3][1] / 255.0f;
        float f18 = this.matrix[3][2] / 255.0f;
        float f19 = this.matrix[3][3] / 255.0f;
        float f20 = this.matrix[3][4] / 255.0f;
        for (n9 = 0; n9 < n4; ++n9) {
            for (n10 = 0; n10 < n3; ++n10) {
                int n11 = nArray[n8];
                int n12 = n11 >>> 24;
                int n13 = n11 >> 16 & 0xFF;
                int n14 = n11 >> 8 & 0xFF;
                int n15 = n11 & 0xFF;
                int n16 = (int)((f * (float)n13 + f2 * (float)n14 + f3 * (float)n15 + f4 * (float)n12 + f5) * 255.0f);
                int n17 = (int)((f6 * (float)n13 + f7 * (float)n14 + f8 * (float)n15 + f9 * (float)n12 + f10) * 255.0f);
                int n18 = (int)((f11 * (float)n13 + f12 * (float)n14 + f13 * (float)n15 + f14 * (float)n12 + f15) * 255.0f);
                int n19 = (int)((f16 * (float)n13 + f17 * (float)n14 + f18 * (float)n15 + f19 * (float)n12 + f20) * 255.0f);
                if ((n16 & 0xFFFFFF00) != 0) {
                    int n20 = n16 = (n16 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n17 & 0xFFFFFF00) != 0) {
                    int n21 = n17 = (n17 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n18 & 0xFFFFFF00) != 0) {
                    int n22 = n18 = (n18 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n19 & 0xFFFFFF00) != 0) {
                    n19 = (n19 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[n8++] = n19 << 24 | n16 << 16 | n17 << 8 | n18;
            }
            n8 += n7;
        }
        return writableRaster;
    }
}

