/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.NativeRegExpInstantiator;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    protected String input;
    protected boolean multiline;
    protected SubString[] parens;
    protected SubString lastMatch;
    protected SubString lastParen;
    protected SubString leftContext;
    protected SubString rightContext;

    @Override
    public boolean isRegExp(Scriptable scriptable) {
        return scriptable instanceof NativeRegExp;
    }

    @Override
    public Object compileRegExp(Context context, String string, String string2) {
        return NativeRegExp.compileRE(context, string, string2, false);
    }

    @Override
    public Scriptable wrapRegExp(Context context, Scriptable scriptable, Object object) {
        return NativeRegExpInstantiator.withLanguageVersionScopeCompiled(context.getLanguageVersion(), scriptable, (RECompiled)object);
    }

    @Override
    public Object action(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, int n) {
        GlobData globData = new GlobData();
        globData.mode = n;
        globData.str = ScriptRuntime.toString(scriptable2);
        switch (n) {
            case 1: {
                int n2 = Integer.MAX_VALUE;
                if (context.getLanguageVersion() < 160) {
                    n2 = 1;
                }
                NativeRegExp nativeRegExp = RegExpImpl.createRegExp(context, scriptable, objectArray, n2, false);
                Object object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, nativeRegExp);
                return globData.arrayobj == null ? object : globData.arrayobj;
            }
            case 4: {
                int n3 = Integer.MAX_VALUE;
                if (context.getLanguageVersion() < 160) {
                    n3 = 1;
                }
                NativeRegExp nativeRegExp = RegExpImpl.createRegExp(context, scriptable, objectArray, n3, false);
                return RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, nativeRegExp);
            }
            case 2: 
            case 3: {
                Object object;
                Object object2;
                boolean bl;
                boolean bl2 = bl = objectArray.length > 0 && objectArray[0] instanceof NativeRegExp;
                if (context.getLanguageVersion() < 160) {
                    bl |= objectArray.length > 2;
                }
                NativeRegExp nativeRegExp = null;
                String string = null;
                if (bl) {
                    nativeRegExp = RegExpImpl.createRegExp(context, scriptable, objectArray, 2, true);
                    if (3 == n && (nativeRegExp.getFlags() & 1) == 0) {
                        throw ScriptRuntime.typeError("replaceAll must be called with a global RegExp");
                    }
                } else {
                    object2 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                    string = ScriptRuntime.toString(object2);
                }
                object2 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                String string2 = null;
                Function function = null;
                if (object2 instanceof Function && (context.getLanguageVersion() < 200 || !(object2 instanceof NativeRegExp))) {
                    function = (Function)object2;
                } else {
                    string2 = ScriptRuntime.toString(object2);
                }
                globData.lambda = function;
                globData.repstr = string2;
                globData.dollar = string2 == null ? -1 : string2.indexOf(36);
                globData.charBuf = null;
                globData.leftIndex = 0;
                if (bl) {
                    object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, nativeRegExp);
                    if (globData.charBuf == null) {
                        if (globData.global || object == null || !Boolean.TRUE.equals(object)) {
                            return globData.str;
                        }
                        SubString subString = this.leftContext;
                        RegExpImpl.replace_glob(globData, context, scriptable, this, subString.index, subString.length);
                    }
                } else {
                    object = globData.str;
                    int n4 = ((String)object).length();
                    int n5 = string.length();
                    int n6 = -1;
                    int n7 = 0;
                    do {
                        n6 = string.isEmpty() ? (n6 == -1 ? 0 : (n7 < n4 ? n7 + 1 : -1)) : ((String)object).indexOf(string, n7);
                        if (n6 == -1) {
                            if (globData.charBuf != null) break;
                            return object;
                        }
                        this.parens = null;
                        this.lastParen = null;
                        this.leftContext = new SubString((String)object, 0, n6);
                        this.lastMatch = new SubString((String)object, n6, n5);
                        this.rightContext = new SubString((String)object, n6 + n5, n4 - n6 - n5);
                        RegExpImpl.replace_glob(globData, context, scriptable, this, n7, n6 - n7);
                        n7 = n6 + n5;
                    } while (n == 3);
                }
                object = this.rightContext;
                globData.charBuf.append(((SubString)object).str, ((SubString)object).index, ((SubString)object).index + ((SubString)object).length);
                return globData.charBuf.toString();
            }
        }
        throw Kit.codeBug();
    }

    private static NativeRegExp createRegExp(Context context, Scriptable scriptable, Object[] objectArray, int n, boolean bl) {
        NativeRegExp nativeRegExp;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        if (objectArray.length == 0 || objectArray[0] == Undefined.instance) {
            RECompiled rECompiled = NativeRegExp.compileRE(context, "", "", false);
            nativeRegExp = NativeRegExpInstantiator.withLanguageVersionScopeCompiled(context.getLanguageVersion(), scriptable2, rECompiled);
        } else if (objectArray[0] instanceof NativeRegExp) {
            nativeRegExp = (NativeRegExp)objectArray[0];
        } else {
            String string;
            String string2 = ScriptRuntime.toString(objectArray[0]);
            if (n < objectArray.length) {
                objectArray[0] = string2;
                string = ScriptRuntime.toString(objectArray[n]);
            } else {
                string = null;
            }
            RECompiled rECompiled = NativeRegExp.compileRE(context, string2, string, bl);
            nativeRegExp = NativeRegExpInstantiator.withLanguageVersionScopeCompiled(context.getLanguageVersion(), scriptable2, rECompiled);
        }
        return nativeRegExp;
    }

    private static Object matchOrReplace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, RegExpImpl regExpImpl, GlobData globData, NativeRegExp nativeRegExp) {
        String string = globData.str;
        globData.global = (nativeRegExp.getFlags() & 1) != 0;
        int[] nArray = new int[]{0};
        Object object = null;
        if (globData.mode == 4) {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, nArray, 0);
            object = object != null && object.equals(Boolean.TRUE) ? Integer.valueOf(regExpImpl.leftContext.length) : Integer.valueOf(-1);
        } else if (globData.global) {
            nativeRegExp.lastIndex = ScriptRuntime.zeroObj;
            int n = 0;
            while (nArray[0] <= string.length() && (object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, nArray, 0)) != null && object.equals(Boolean.TRUE)) {
                if (globData.mode == 1) {
                    RegExpImpl.match_glob(globData, context, scriptable, n, regExpImpl);
                } else {
                    if (globData.mode != 2 && globData.mode != 3) {
                        Kit.codeBug();
                    }
                    SubString subString = regExpImpl.lastMatch;
                    int n2 = globData.leftIndex;
                    int n3 = subString.index - n2;
                    globData.leftIndex = subString.index + subString.length;
                    RegExpImpl.replace_glob(globData, context, scriptable, regExpImpl, n2, n3);
                }
                if (regExpImpl.lastMatch.length == 0) {
                    if (nArray[0] == string.length()) break;
                    nArray[0] = nArray[0] + 1;
                }
                ++n;
            }
        } else {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, nArray, globData.mode == 2 ? 0 : 1);
        }
        return object;
    }

    @Override
    public int find_split(Context context, Scriptable scriptable, String string, String string2, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n;
        SubString subString;
        int n2;
        block5: {
            int n3 = nArray[0];
            int n4 = string.length();
            int n5 = context.getLanguageVersion();
            NativeRegExp nativeRegExp = (NativeRegExp)scriptable2;
            while (true) {
                n2 = nArray[0];
                nArray[0] = ++n3;
                Object object = nativeRegExp.executeRegExp(context, scriptable, this, string, nArray, 0);
                if (!Boolean.TRUE.equals(object)) {
                    nArray[0] = n2;
                    nArray2[0] = 1;
                    blArray[0] = false;
                    return n4;
                }
                n3 = nArray[0];
                nArray[0] = n2;
                blArray[0] = true;
                subString = this.lastMatch;
                nArray2[0] = subString.length;
                if (nArray2[0] != 0 || n3 != nArray[0]) break;
                if (n3 != n4) continue;
                if (n5 == 120) {
                    nArray2[0] = 1;
                    n = n3;
                } else {
                    n = -1;
                }
                break block5;
            }
            n = n3 - nArray2[0];
        }
        n2 = this.parens == null ? 0 : this.parens.length;
        stringArray[0] = new String[n2];
        for (int i = 0; i < n2; ++i) {
            subString = this.getParenSubString(i);
            stringArray[0][i] = subString.toString();
        }
        return n;
    }

    SubString getParenSubString(int n) {
        SubString subString;
        if (this.parens != null && n < this.parens.length && (subString = this.parens[n]) != null) {
            return subString;
        }
        return new SubString();
    }

    private static void match_glob(GlobData globData, Context context, Scriptable scriptable, int n, RegExpImpl regExpImpl) {
        if (globData.arrayobj == null) {
            globData.arrayobj = context.newArray(scriptable, 0);
        }
        SubString subString = regExpImpl.lastMatch;
        String string = subString.toString();
        globData.arrayobj.put(n, globData.arrayobj, (Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replace_glob(GlobData globData, Context context, Scriptable scriptable, RegExpImpl regExpImpl, int n, int n2) {
        int n3;
        String string;
        int n4;
        Object[] objectArray;
        if (globData.lambda != null) {
            Object object;
            objectArray = regExpImpl.parens;
            n4 = objectArray == null ? 0 : objectArray.length;
            Object[] objectArray2 = new Object[n4 + 3];
            objectArray2[0] = regExpImpl.lastMatch.toString();
            for (int i = 0; i < n4; ++i) {
                object = objectArray[i];
                objectArray2[i + 1] = object != null ? ((SubString)object).toString() : Undefined.instance;
            }
            objectArray2[n4 + 1] = regExpImpl.leftContext.length;
            objectArray2[n4 + 2] = globData.str;
            if (regExpImpl != ScriptRuntime.getRegExpProxy(context)) {
                Kit.codeBug();
            }
            RegExpImpl regExpImpl2 = new RegExpImpl();
            regExpImpl2.multiline = regExpImpl.multiline;
            regExpImpl2.input = regExpImpl.input;
            ScriptRuntime.setRegExpProxy(context, regExpImpl2);
            try {
                object = ScriptableObject.getTopLevelScope(scriptable);
                Object object2 = globData.lambda.call(context, (Scriptable)object, (Scriptable)object, objectArray2);
                string = ScriptRuntime.toString(object2);
            }
            finally {
                ScriptRuntime.setRegExpProxy(context, regExpImpl);
            }
            n3 = string.length();
        } else {
            string = null;
            n3 = globData.repstr.length();
            if (globData.dollar >= 0) {
                objectArray = new int[1];
                n4 = globData.dollar;
                do {
                    SubString subString;
                    if ((subString = RegExpImpl.interpretDollar(context, regExpImpl, globData.repstr, n4, (int[])objectArray)) != null) {
                        n3 += subString.length - objectArray[0];
                        n4 += objectArray[0];
                        continue;
                    }
                    ++n4;
                } while ((n4 = globData.repstr.indexOf(36, n4)) >= 0);
            }
        }
        int n5 = n2 + n3 + regExpImpl.rightContext.length;
        StringBuilder stringBuilder = globData.charBuf;
        if (stringBuilder == null) {
            globData.charBuf = stringBuilder = new StringBuilder(n5);
        } else {
            stringBuilder.ensureCapacity(globData.charBuf.length() + n5);
        }
        stringBuilder.append(regExpImpl.leftContext.str, n, n + n2);
        if (globData.lambda != null) {
            stringBuilder.append(string);
        } else {
            RegExpImpl.do_replace(globData, context, regExpImpl);
        }
    }

    private static SubString interpretDollar(Context context, RegExpImpl regExpImpl, String string, int n, int[] nArray) {
        int n2;
        if (string.charAt(n) != '$') {
            Kit.codeBug();
        }
        if ((n2 = context.getLanguageVersion()) != 0 && n2 <= 140 && n > 0 && string.charAt(n - 1) == '\\') {
            return null;
        }
        int n3 = string.length();
        if (n + 1 >= n3) {
            return null;
        }
        char c = string.charAt(n + 1);
        if (NativeRegExp.isDigit(c)) {
            int n4;
            int n5;
            int n6;
            if (n2 != 0 && n2 <= 140) {
                if (c == '0') {
                    return null;
                }
                n6 = 0;
                n5 = n;
                while (++n5 < n3 && NativeRegExp.isDigit(c = string.charAt(n5)) && (n4 = 10 * n6 + (c - 48)) >= n6) {
                    n6 = n4;
                }
            } else {
                n6 = c - 48;
                int n7 = regExpImpl.parens == null ? 0 : regExpImpl.parens.length;
                if (n6 > n7) {
                    return null;
                }
                n5 = n + 2;
                if (n + 2 < n3 && NativeRegExp.isDigit(c = string.charAt(n + 2)) && (n4 = 10 * n6 + (c - 48)) <= n7) {
                    ++n5;
                    n6 = n4;
                }
                if (n6 == 0) {
                    return null;
                }
            }
            nArray[0] = n5 - n;
            return regExpImpl.getParenSubString(--n6);
        }
        nArray[0] = 2;
        switch (c) {
            case '$': {
                return new SubString("$");
            }
            case '&': {
                return regExpImpl.lastMatch;
            }
            case '+': {
                return regExpImpl.lastParen;
            }
            case '`': {
                if (n2 == 120) {
                    regExpImpl.leftContext.index = 0;
                    regExpImpl.leftContext.length = regExpImpl.lastMatch.index;
                }
                return regExpImpl.leftContext;
            }
            case '\'': {
                return regExpImpl.rightContext;
            }
        }
        return null;
    }

    private static void do_replace(GlobData globData, Context context, RegExpImpl regExpImpl) {
        int n;
        StringBuilder stringBuilder = globData.charBuf;
        int n2 = 0;
        String string = globData.repstr;
        int n3 = globData.dollar;
        if (n3 != -1) {
            int[] nArray = new int[1];
            do {
                int n4 = n3 - n2;
                stringBuilder.append(string, n2, n3);
                n2 = n3;
                SubString subString = RegExpImpl.interpretDollar(context, regExpImpl, string, n3, nArray);
                if (subString != null) {
                    n4 = subString.length;
                    if (n4 > 0) {
                        stringBuilder.append(subString.str, subString.index, subString.index + n4);
                    }
                    n2 += nArray[0];
                    n3 += nArray[0];
                    continue;
                }
                ++n3;
            } while ((n3 = string.indexOf(36, n3)) >= 0);
        }
        if ((n = string.length()) > n2) {
            stringBuilder.append(string, n2, n);
        }
    }

    @Override
    public Object js_split(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        int n;
        Object object;
        Scriptable scriptable2 = context.newArray(scriptable, 0);
        boolean bl = objectArray.length > 1 && objectArray[1] != Undefined.instance;
        long l = 0L;
        if (bl) {
            l = ScriptRuntime.toUint32(objectArray[1]);
            if (l == 0L) {
                return scriptable2;
            }
            if (l > (long)string.length()) {
                l = 1 + string.length();
            }
        }
        if (objectArray.length < 1 || objectArray[0] == Undefined.instance) {
            scriptable2.put(0, scriptable2, (Object)string);
            return scriptable2;
        }
        String string2 = null;
        int[] nArray = new int[1];
        Object object2 = null;
        RegExpProxy regExpProxy = null;
        if (objectArray[0] instanceof Scriptable && (regExpProxy = ScriptRuntime.getRegExpProxy(context)) != null && regExpProxy.isRegExp((Scriptable)(object = (Object)((Scriptable)objectArray[0])))) {
            object2 = object;
        }
        if (object2 == null) {
            string2 = ScriptRuntime.toString(objectArray[0]);
            nArray[0] = string2.length();
        }
        object = new int[]{0};
        int n2 = 0;
        boolean[] blArray = new boolean[]{false};
        String[][] stringArray = new String[][]{null};
        int n3 = context.getLanguageVersion();
        while (!((n = RegExpImpl.find_split(context, scriptable, string, string2, n3, regExpProxy, (Scriptable)object2, object, nArray, blArray, stringArray)) < 0 || bl && (long)n2 >= l || n > string.length())) {
            String string3 = string.length() == 0 ? string : string.substring(object[0], n);
            scriptable2.put(n2, scriptable2, (Object)string3);
            ++n2;
            if (object2 != null && blArray[0]) {
                int n4 = stringArray[0].length;
                for (int i = 0; !(i >= n4 || bl && (long)n2 >= l); ++i) {
                    scriptable2.put(n2, scriptable2, (Object)stringArray[0][i]);
                    ++n2;
                }
                blArray[0] = false;
            }
            object[0] = n + nArray[0];
            if (n3 >= 130 || n3 == 0 || bl || object[0] != string.length()) continue;
            break;
        }
        return scriptable2;
    }

    private static int find_split(Context context, Scriptable scriptable, String string, String string2, int n, RegExpProxy regExpProxy, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n2;
        int n3 = string.length();
        if (n == 120 && scriptable2 == null && string2.length() == 1 && string2.charAt(0) == ' ') {
            int n4;
            if (n2 == 0) {
                for (n2 = nArray[0]; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                nArray[0] = n2;
            }
            if (n2 == n3) {
                return -1;
            }
            while (n2 < n3 && !Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            for (n4 = n2; n4 < n3 && Character.isWhitespace(string.charAt(n4)); ++n4) {
            }
            nArray2[0] = n4 - n2;
            return n2;
        }
        if (n2 > n3) {
            return -1;
        }
        if (scriptable2 != null) {
            return regExpProxy.find_split(context, scriptable, string, string2, scriptable2, nArray, nArray2, blArray, stringArray);
        }
        if (n != 0 && n < 130 && n3 == 0) {
            return -1;
        }
        if (string2.length() == 0) {
            if (n == 120) {
                if (n2 == n3) {
                    nArray2[0] = 1;
                    return n2;
                }
                return n2 + 1;
            }
            return n2 == n3 ? -1 : n2 + 1;
        }
        if (nArray[0] >= n3) {
            return n3;
        }
        n2 = string.indexOf(string2, nArray[0]);
        return n2 != -1 ? n2 : n3;
    }
}

