/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.Viewport;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class LengthManager
extends AbstractValueManager {
    public static final float DEFAULT_LINE_HEIGHT = 1.1f;
    static final double SQRT2 = Math.sqrt(2.0);
    protected static final int HORIZONTAL_ORIENTATION = 0;
    protected static final int VERTICAL_ORIENTATION = 1;
    protected static final int BOTH_ORIENTATION = 2;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case DIMENSION: {
                return this.createLength(lexicalUnit);
            }
            case INTEGER: {
                return new FloatValue(0, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lexicalUnit.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lexicalUnit);
            }
            case CALC: {
                return this.createCalc(lexicalUnit);
            }
            case MATH_FUNCTION: {
                Value value;
                try {
                    value = this.createMathFunction(lexicalUnit, "<length-percentage>");
                }
                catch (Exception exception) {
                    DOMException dOMException = this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    dOMException.initCause(exception);
                    throw dOMException;
                }
                return value;
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    FloatValue createLength(LexicalUnit lexicalUnit) throws DOMException {
        if (CSSUnit.isLengthUnitType((short)lexicalUnit.getCssUnit())) {
            return new FloatValue(lexicalUnit.getCssUnit(), lexicalUnit.getFloatValue());
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        if (s == 0 || s == 2 || CSSUnit.isLengthUnitType((short)s)) {
            return new FloatValue(s, f);
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        CSSValue.Type type = value.getPrimitiveType();
        if (type != CSSValue.Type.NUMERIC) {
            if (type != CSSValue.Type.EXPRESSION && type != CSSValue.Type.MATH_FUNCTION) {
                return value;
            }
            try {
                return this.evaluateMath((NumericDelegateValue)value, cSSStylableElement, string, cSSEngine, n, styleMap, (short)3);
            }
            catch (Exception exception) {
                return this.isInheritedProperty() ? null : this.getDefaultValue();
            }
        }
        switch (value.getUnitType()) {
            case 0: 
            case 3: {
                return value;
            }
            case 8: {
                float f = value.getFloatValue();
                return new FloatValue(3, f * 3.7795277f);
            }
            case 7: {
                float f = value.getFloatValue();
                return new FloatValue(3, f * 37.795277f);
            }
            case 4: {
                float f = value.getFloatValue();
                return new FloatValue(3, f * 96.0f);
            }
            case 6: {
                float f = value.getFloatValue();
                return new FloatValue(3, f / 0.75f);
            }
            case 5: {
                float f = value.getFloatValue();
                return new FloatValue(3, f * 16.0f);
            }
            case 20: {
                styleMap.putFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n2 = cSSEngine.getFontSizeIndex();
                Value value2 = cSSEngine.getComputedStyle(cSSStylableElement, string, n2);
                float f2 = this.lengthValue(value2);
                return new FloatValue(3, f * f2);
            }
            case 21: {
                styleMap.putFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n3 = cSSEngine.getFontSizeIndex();
                Value value3 = cSSEngine.getComputedStyle(cSSStylableElement, string, n3);
                float f3 = value3.getFloatValue();
                return new FloatValue(3, f * f3 * 0.5f);
            }
            case 2: {
                float f;
                CSSContext cSSContext = cSSEngine.getCSSContext();
                switch (this.getOrientation()) {
                    case 0: {
                        styleMap.putBlockWidthRelative(n, true);
                        f = value.getFloatValue() * cSSContext.getBlockWidth(cSSStylableElement) / 100.0f;
                        break;
                    }
                    case 1: {
                        styleMap.putBlockHeightRelative(n, true);
                        f = value.getFloatValue() * cSSContext.getBlockHeight(cSSStylableElement) / 100.0f;
                        break;
                    }
                    default: {
                        styleMap.putBlockWidthRelative(n, true);
                        styleMap.putBlockHeightRelative(n, true);
                        double d = cSSContext.getBlockWidth(cSSStylableElement);
                        double d2 = cSSContext.getBlockHeight(cSSStylableElement);
                        f = (float)((double)value.getFloatValue() * (Math.sqrt(d * d + d2 * d2) / SQRT2) / 100.0);
                    }
                }
                return new FloatValue(3, f);
            }
            case 25: {
                styleMap.putLineHeightRelative(n, true);
                float f = value.getFloatValue();
                int n4 = cSSEngine.getLineHeightIndex();
                Value value4 = cSSEngine.getComputedStyle(cSSStylableElement, string, n4);
                float f4 = this.lineHeightValue(cSSStylableElement, string, cSSEngine, value4);
                return new FloatValue(3, f * f4);
            }
            case 26: {
                styleMap.putRootFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n5 = cSSEngine.getFontSizeIndex();
                CSSStylableElement cSSStylableElement2 = (CSSStylableElement)cSSStylableElement.getOwnerDocument().getDocumentElement();
                Value value5 = cSSEngine.getComputedStyle(cSSStylableElement2, null, n5);
                float f5 = value5.getFloatValue();
                return new FloatValue(3, f * f5);
            }
            case 28: {
                styleMap.putRootFontSizeRelative(n, true);
                float f = value.getFloatValue();
                int n6 = cSSEngine.getFontSizeIndex();
                CSSStylableElement cSSStylableElement3 = (CSSStylableElement)cSSStylableElement.getOwnerDocument().getDocumentElement();
                Value value6 = cSSEngine.getComputedStyle(cSSStylableElement3, null, n6);
                float f6 = value6.getFloatValue();
                return new FloatValue(3, f * f6 * 0.5f);
            }
            case 27: {
                styleMap.putRootLineHeightRelative(n, true);
                float f = value.getFloatValue();
                int n7 = cSSEngine.getLineHeightIndex();
                CSSStylableElement cSSStylableElement4 = (CSSStylableElement)cSSStylableElement.getOwnerDocument().getDocumentElement();
                Value value7 = cSSEngine.getComputedStyle(cSSStylableElement4, null, n7);
                float f7 = this.lineHeightValue(cSSStylableElement4, null, cSSEngine, value7);
                return new FloatValue(3, f * f7);
            }
            case 45: {
                styleMap.putViewportRelative(n, true);
                float f = value.getFloatValue();
                return new FloatValue(3, f * cSSEngine.getCSSContext().getViewport(cSSStylableElement).getWidth() / 100.0f);
            }
            case 41: {
                styleMap.putViewportRelative(n, true);
                float f = value.getFloatValue();
                return new FloatValue(3, f * cSSEngine.getCSSContext().getViewport(cSSStylableElement).getHeight() / 100.0f);
            }
            case 44: {
                styleMap.putViewportRelative(n, true);
                float f = value.getFloatValue();
                Viewport viewport = cSSEngine.getCSSContext().getViewport(cSSStylableElement);
                float f8 = viewport.getWidth();
                float f9 = viewport.getHeight();
                float f10 = Math.min(f8, f9);
                return new FloatValue(3, f * f10 / 100.0f);
            }
            case 43: {
                styleMap.putViewportRelative(n, true);
                float f = value.getFloatValue();
                Viewport viewport = cSSEngine.getCSSContext().getViewport(cSSStylableElement);
                float f11 = viewport.getWidth();
                float f12 = viewport.getHeight();
                float f13 = Math.max(f11, f12);
                return new FloatValue(3, f * f13 / 100.0f);
            }
            case 1: 
            case 255: {
                break;
            }
            default: {
                try {
                    value = new FloatValue(3, NumberValue.floatValueConversion((float)value.getFloatValue(), (short)value.getUnitType(), (short)3));
                    break;
                }
                catch (DOMException dOMException) {
                    value = null;
                }
            }
        }
        return value;
    }

    protected float lineHeightValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, Value value) throws DOMException {
        short s = value.getUnitType();
        if (s == 0) {
            int n = cSSEngine.getFontSizeIndex();
            Value value2 = cSSEngine.getComputedStyle(cSSStylableElement, string, n);
            float f = value2.getFloatValue();
            return f * value.getFloatValue();
        }
        if (s == 3) {
            return value.getFloatValue();
        }
        return NumberValue.floatValueConversion((float)value.getFloatValue(), (short)s, (short)3);
    }

    protected abstract int getOrientation();
}

