/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableUnitValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import org.w3c.api.DOMSyntaxException;
import org.w3c.api.DOMTypeException;
import org.w3c.css.om.typed.CSSUnitValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class FloatValue
extends NumericValue
implements CSSNumberValue,
CSSUnitValue {
    private static final long serialVersionUID = 1L;
    private float floatValue;
    private short unitType;
    private boolean calculated = false;
    private boolean specified = true;

    public static String getCssText(short s, float f) {
        if (s == 255) {
            throw new DOMException(12, "");
        }
        String string = String.valueOf(f);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string + CSSUnit.dimensionUnitString((short)s);
    }

    public static FloatValue createConstant(short s, float f) {
        return new ImmutableUnitValue(s, f);
    }

    public FloatValue(short s, float f) {
        this.unitType = s;
        this.floatValue = f;
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.NUMERIC;
    }

    @Override
    public short getUnitType() {
        return this.unitType;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    public double getValue() {
        return this.floatValue;
    }

    public void setValue(double d) {
        this.floatValue = (float)d;
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    public void setValue(String string) throws DOMException {
        this.setCssText(string);
    }

    public String getUnit() {
        return CSSUnit.dimensionUnitString((short)this.unitType);
    }

    public String getCssText() {
        return FloatValue.getCssText(this.unitType, this.floatValue);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        CSSParser cSSParser = new CSSParser();
        try {
            LexicalUnit lexicalUnit = cSSParser.parsePropertyValue((Reader)new StringReader(string));
            if (lexicalUnit.getNextLexicalUnit() != null) {
                throw new DOMSyntaxException("Invalid number " + string);
            }
            switch (lexicalUnit.getLexicalUnitType()) {
                case INTEGER: {
                    this.floatValue = lexicalUnit.getIntegerValue();
                    this.unitType = 0;
                    break;
                }
                case REAL: {
                    this.floatValue = lexicalUnit.getFloatValue();
                    this.unitType = 0;
                    break;
                }
                case PERCENTAGE: {
                    this.floatValue = lexicalUnit.getFloatValue();
                    this.unitType = (short)2;
                    break;
                }
                case DIMENSION: {
                    this.floatValue = lexicalUnit.getFloatValue();
                    this.unitType = lexicalUnit.getCssUnit();
                    break;
                }
                default: {
                    throw new DOMTypeException("Invalid unit value: " + string);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CSSParseException cSSParseException) {
            throw new DOMSyntaxException((Throwable)cSSParseException);
        }
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    @Override
    public boolean isCalculatedNumber() {
        return this.calculated;
    }

    public void setCalculatedNumber(boolean bl) {
        this.calculated = bl;
        this.specified = this.specified && !bl;
    }

    @Override
    public void setExpectInteger() throws DOMException {
        if (this.getUnitType() != 0) {
            super.setExpectInteger();
        } else if (this.calculated) {
            this.floatValue = Math.round(this.floatValue);
        } else if (!this.isInteger()) {
            super.setExpectInteger();
        }
    }

    private boolean isInteger() {
        return Math.rint(this.floatValue) == (double)this.floatValue;
    }

    public void roundToInteger() throws DOMException {
        this.setExpectInteger();
        this.floatValue = Math.round(this.floatValue);
    }

    public boolean isNegativeNumber() {
        return this.floatValue < 0.0f;
    }

    @Override
    public boolean isNumberZero() {
        return this.floatValue == 0.0f;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(Float.valueOf(this.floatValue), this.unitType);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        return value.getUnitType() == this.unitType && Float.floatToIntBits(this.floatValue) == Float.floatToIntBits(value.getFloatValue());
    }

    public CSSUnitValue to(String string) {
        short s = UnitStringToId.unitFromString((String)string);
        float f = NumberValue.floatValueConversion((float)this.floatValue, (short)this.unitType, (short)s);
        FloatValue floatValue = new FloatValue(s, f);
        return floatValue;
    }

    @Override
    short getCSSUnit() {
        return this.unitType;
    }

    @Override
    public FloatValue clone() {
        FloatValue floatValue = (FloatValue)super.clone();
        floatValue.floatValue = this.floatValue;
        floatValue.unitType = this.unitType;
        floatValue.calculated = this.calculated;
        floatValue.specified = this.specified;
        return floatValue;
    }
}

