/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.ComponentHandler;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.dom.DOMException;

public abstract class ComponentValue
extends AbstractValue {
    private static final long serialVersionUID = 1L;
    private ComponentModificationHandler componentHandler = new ComponentModificationHandler();

    protected ComponentValue() {
    }

    protected ComponentModificationHandler getComponentHandler() {
        return this.componentHandler;
    }

    protected void componentize(Value value) {
        value.setModificationHandler(this.componentHandler);
    }

    protected void componentChanged(Value value) {
        this.componentHandler.componentChanged(value);
    }

    protected void componentAdded(Value value) {
        this.componentHandler.componentAdded(value);
    }

    protected void componentRemoved(Value value) {
        this.componentHandler.componentRemoved(value);
    }

    class ComponentModificationHandler
    implements ComponentHandler {
        ComponentModificationHandler() {
        }

        @Override
        public void componentChanged(Value value) {
            this.propertyChanged();
        }

        @Override
        public void componentAdded(Value value) {
            this.propertyChanged();
        }

        @Override
        public void componentRemoved(Value value) {
            this.propertyChanged();
        }

        @Override
        public void listValueChanged(int n, Value value) throws DOMException {
            this.propertyChanged();
        }

        @Override
        public void valueChanged(Value value) {
            this.propertyChanged();
        }

        private void propertyChanged() {
            if (ComponentValue.this.handler != null) {
                ComponentValue.this.handler.valueChanged(this.getValue());
            }
        }

        @Override
        public Value getValue() {
            return ComponentValue.this;
        }
    }
}

