/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class NamespaceRule
extends BaseCSSRule
implements CSSNamespaceRule {
    private static final long serialVersionUID = 1L;
    private String namespaceURI = null;
    private String prefix = null;

    protected NamespaceRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by, String string, String string2) {
        super(abstractCSSStyleSheet, (short)10, by);
        this.prefix = string;
        this.namespaceURI = string2;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String string) {
        this.prefix = string;
        AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
        if (abstractCSSStyleSheet != null) {
            abstractCSSStyleSheet.unregisterNamespace(this.namespaceURI);
            abstractCSSStyleSheet.registerNamespace(this);
            this.updateSelectorText(abstractCSSStyleSheet.getCssRules());
        }
    }

    private void updateSelectorText(CSSRuleArrayList cSSRuleArrayList) {
        for (CSSRule cSSRule : cSSRuleArrayList) {
            short s = cSSRule.getType();
            if (s == 1) {
                ((CSSStyleDeclarationRule)cSSRule).updateSelectorText();
                continue;
            }
            if (!(cSSRule instanceof GroupingRule)) continue;
            this.updateSelectorText(((GroupingRule)cSSRule).getCssRules());
        }
    }

    @Override
    void clear() {
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        NamespaceRule namespaceRule = (NamespaceRule)abstractCSSRule;
        this.setPrecedingComments(abstractCSSRule.getPrecedingComments());
        this.setTrailingComments(abstractCSSRule.getTrailingComments());
        this.namespaceURI = namespaceRule.namespaceURI;
        this.prefix = namespaceRule.prefix;
    }

    @Override
    public String getCssText() {
        if (this.namespaceURI == null) {
            return null;
        }
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.namespaceURI.length() + 32);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.namespaceURI == null) {
            return;
        }
        simpleWriter.write((CharSequence)"@namespace ");
        if (this.prefix != null) {
            simpleWriter.write((CharSequence)this.prefix);
            simpleWriter.write(' ');
        }
        styleFormattingContext.writeURL(simpleWriter, this.namespaceURI);
        styleFormattingContext.writeSemiColon(simpleWriter);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
        n2 = 31 * n2 + (this.prefix == null ? 0 : this.prefix.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NamespaceRule namespaceRule = (NamespaceRule)object;
        if (this.namespaceURI == null ? namespaceRule.namespaceURI != null : !this.namespaceURI.equals(namespaceRule.namespaceURI)) {
            return false;
        }
        return !(this.prefix == null ? namespaceRule.prefix != null : !this.prefix.equals(namespaceRule.prefix));
    }

    @Override
    public NamespaceRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return new NamespaceRule(abstractCSSStyleSheet, this.getOrigin(), this.prefix, this.namespaceURI);
    }
}

