/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class SystemDefaultValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private static final SystemDefaultValue strictmode = new SystemDefaultValue();

    protected SystemDefaultValue() {
        super(CSSValue.Type.UNKNOWN);
    }

    public static SystemDefaultValue getInstance() {
        return strictmode;
    }

    @Override
    public String getCssText() {
        return "initial";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getCssText());
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(13, "Attempt to modify a system-default value.");
    }

    @Override
    public boolean isSubproperty() {
        return true;
    }

    @Override
    public boolean isSystemDefault() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SystemDefaultValue)) {
            return false;
        }
        SystemDefaultValue systemDefaultValue = (SystemDefaultValue)object;
        return this.getCssText().equals(systemDefaultValue.getCssText());
    }

    @Override
    public int hashCode() {
        return this.getCssText().hashCode();
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return null;
    }

    @Override
    public SystemDefaultValue clone() {
        return this;
    }
}

