/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class BaselineShiftManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 40;
    }

    @Override
    public String getPropertyName() {
        return "baseline-shift";
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.BASELINE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                Object object = values.get(lexicalUnit.getStringValue().toLowerCase(Locale.ROOT).intern());
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
                }
                return (Value)object;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String string, CSSEngine cSSEngine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object object = values.get(string.toLowerCase(Locale.ROOT).intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getUnitType() == 2) {
            styleMap.putLineHeightRelative(n, true);
            int n2 = cSSEngine.getLineHeightIndex();
            CSSStylableElement cSSStylableElement2 = (CSSStylableElement)cSSStylableElement.getParentNode();
            if (cSSStylableElement2 == null) {
                cSSStylableElement2 = cSSStylableElement;
            }
            Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, null, n2);
            float f = this.lineHeightValue(cSSStylableElement2, null, cSSEngine, value2);
            float f2 = value.getFloatValue();
            return new FloatValue(3, f * f2 * 0.01f);
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    @Override
    protected int getOrientation() {
        return 2;
    }

    static {
        values.put("baseline", SVGValueConstants.BASELINE_VALUE);
        values.put("sub", SVGValueConstants.SUB_VALUE);
        values.put("super", SVGValueConstants.SUPER_VALUE);
    }
}

