/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.echosvg.css.dom.CSSOMValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.Map;
import org.w3c.css.om.CSSRule;
import org.w3c.css.om.CSSStyleDeclaration;
import org.w3c.dom.DOMException;

public class CSSOMComputedStyle
implements CSSStyleDeclaration {
    protected CSSEngine cssEngine;
    protected CSSStylableElement element;
    protected String pseudoElement;
    protected Map<String, CSSVal> values = new HashMap<String, CSSVal>();

    public CSSOMComputedStyle(CSSEngine cSSEngine, CSSStylableElement cSSStylableElement, String string) {
        this.cssEngine = cSSEngine;
        this.element = cSSStylableElement;
        this.pseudoElement = string;
    }

    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.cssEngine.getNumberOfProperties(); ++i) {
            stringBuilder.append(this.cssEngine.getPropertyName(i));
            stringBuilder.append(": ");
            stringBuilder.append(this.cssEngine.getComputedStyle(this.element, this.pseudoElement, i).getCssText());
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "");
    }

    public String getPropertyValue(String string) {
        int n = this.cssEngine.getPropertyIndex(string);
        if (n == -1) {
            return "";
        }
        Value value = this.cssEngine.getComputedStyle(this.element, this.pseudoElement, n);
        return value.getCssText();
    }

    public CSSVal getCSSStyleValue(String string) {
        return this.getCSSValue(string);
    }

    public CSSVal getCSSValue(String string) {
        int n;
        CSSVal cSSVal = this.values.get(string);
        if (cSSVal == null && (n = this.cssEngine.getPropertyIndex(string)) != -1) {
            cSSVal = this.createCSSValue(n);
            this.values.put(string, cSSVal);
        }
        return cSSVal;
    }

    public String removeProperty(String string) throws DOMException {
        throw new DOMException(7, "");
    }

    public String getPropertyPriority(String string) {
        return "";
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        throw new DOMException(7, "");
    }

    public int getLength() {
        return this.cssEngine.getNumberOfProperties();
    }

    public String item(int n) {
        if (n < 0 || n >= this.cssEngine.getNumberOfProperties()) {
            return "";
        }
        return this.cssEngine.getPropertyName(n);
    }

    public CSSRule getParentRule() {
        return null;
    }

    protected CSSVal createCSSValue(int n) {
        return new ComputedCSSValue(n);
    }

    public class ComputedCSSValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        private static final long serialVersionUID = 1L;
        protected int index;

        public ComputedCSSValue(int n) {
            super(null);
            this.valueProvider = this;
            this.index = n;
        }

        @Override
        public Value getValue() {
            return CSSOMComputedStyle.this.cssEngine.getComputedStyle(CSSOMComputedStyle.this.element, CSSOMComputedStyle.this.pseudoElement, this.index);
        }
    }
}

